/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.RunLengthFilterException;
import java.io.InputStream;

public class RunLengthInputStream
extends DecodeInputStream {
    private static final int ED = 128;

    public RunLengthInputStream(InputStream in, int inSize, int outSize, FilterParams diparams) {
        super(in, inSize, outSize, 128, diparams);
    }

    public RunLengthInputStream(InputStream in, FilterParams p) {
        super(in, 128, p);
    }

    public RunLengthInputStream(InputStream in) {
        this(in, null);
    }

    @Override
    public void fill() {
        block0: while (this.outCount <= this.outBuf.length - 128 && !this.pendingEOF && this.pendingException == null) {
            int newChar;
            int count;
            if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                this.pendingException = new RunLengthFilterException("RunLength missing EOF");
                break;
            }
            if ((count = this.inBuf[this.inPos++] & 0xFF) == 128) {
                this.pendingEOF = true;
                break;
            }
            if (count > 128) {
                count = 256 - count;
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingException = new RunLengthFilterException("RunLength no repeat char");
                    break;
                }
                newChar = this.inBuf[this.inPos++] & 0xFF;
                while (count-- >= 0) {
                    this.outBuf[this.outCount++] = (byte)newChar;
                }
                continue;
            }
            while (count-- >= 0) {
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingException = new RunLengthFilterException("RunLength no run char");
                    break block0;
                }
                newChar = this.inBuf[this.inPos++] & 0xFF;
                this.outBuf[this.outCount++] = (byte)newChar;
            }
        }
    }
}

