/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.IOException;
import java.util.Map;

public class CosDictionaryValuesIterator
extends CosContainerValuesIterator {
    private Map.Entry[] mEntries;
    int mInd;

    public CosDictionaryValuesIterator(Map.Entry[] entries) {
        this.mEntries = entries;
        this.mInd = 0;
    }

    @Override
    public boolean hasNext() {
        return this.mInd < this.mEntries.length;
    }

    @Override
    public CosContainerValuesIterator.Entry next() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject curObj = (CosObject)this.mEntries[this.mInd].getValue();
            if (curObj instanceof CosObjectRef) {
                curObj = curObj.getDocument().resolveReference((CosObjectRef)curObj);
            }
            CosContainerValuesIterator.Entry entry = this.createEntry((ASName)this.mEntries[this.mInd].getKey(), -1, curObj);
            return entry;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            ++this.mInd;
        }
    }
}

