/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.afml;

import com.adobe.internal.afml.AFMLAnomalies;
import com.adobe.internal.afml.AFMLAttribute__ClassId;
import com.adobe.internal.afml.AFMLAttribute__TypeId;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;
import com.adobe.internal.afml.AFMLSVGNamedColorMap;
import java.util.HashMap;
import java.util.Map;

public abstract class AFMLAttribute__Abstract {
    private static Map<String, Double> afmlLenToConvMap = AFMLAttribute__Abstract.computeAFMLLengthToConversionMap();
    private AFMLAttribute__TypeId pvt_attributeTypeId;
    private AFMLAttribute__ClassId pvt_attributeClassId;
    private boolean pvt_isInheritable;

    public AFMLAttribute__Abstract(AFMLAttribute__TypeId in_attributeTypeId, AFMLAttribute__ClassId in_attributeClassId, boolean in_isInheritable) {
        this.pvt_attributeTypeId = in_attributeTypeId;
        this.pvt_attributeClassId = in_attributeClassId;
        this.pvt_isInheritable = in_isInheritable;
    }

    public abstract boolean equals(AFMLAttribute__Abstract var1);

    public abstract Object clone();

    public AFMLAttribute__TypeId getAttributeTypeId() {
        return this.pvt_attributeTypeId;
    }

    public AFMLAttribute__ClassId getAttributeClassId() {
        return this.pvt_attributeClassId;
    }

    public boolean isInheritable() {
        return this.pvt_isInheritable;
    }

    public static boolean isAFMLAttributeColor(String in_attributeValue) {
        int var_currentIndex = 0;
        int var_count = in_attributeValue.length();
        if (in_attributeValue.charAt(var_currentIndex) == '#') {
            if (in_attributeValue.charAt(++var_currentIndex) == '$') {
                switch (var_count - ++var_currentIndex) {
                    case 4: 
                    case 5: 
                    case 8: 
                    case 10: {
                        return true;
                    }
                }
            } else {
                switch (var_count - var_currentIndex) {
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: {
                        return true;
                    }
                }
            }
            return false;
        }
        if (AFMLSVGNamedColorMap.convertSVGNamedColorToRGB(in_attributeValue) != 0xFFFFFFL) {
            return true;
        }
        return in_attributeValue.charAt(in_attributeValue.length() - 1) == ')' && (in_attributeValue.regionMatches(true, 0, "rgb(", 0, 4) || in_attributeValue.regionMatches(true, 0, "rgba(", 0, 5) || in_attributeValue.regionMatches(true, 0, "cmyk(", 0, 5) || in_attributeValue.regionMatches(true, 0, "cmyka(", 0, 6));
    }

    protected static int getAFMLHexValue(char in_charValue) throws AFMLExceptionInvalidParameter {
        switch (in_charValue) {
            case ' ': 
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        AFMLAnomalies.AFMLInvalidParameterStop("'" + in_charValue + "' is not a hex digit");
        return 0;
    }

    protected static double getAFMLLengthToPointConversion(String in_attributeValue) {
        if (in_attributeValue.length() < 2) {
            return 0.0;
        }
        String var_String = in_attributeValue.substring(in_attributeValue.length() - 2);
        Double value = afmlLenToConvMap.get(var_String);
        if (value != null) {
            return value;
        }
        return 0.0;
    }

    protected static String getAFMLLengthNumberString(String in_attributeValue) {
        return in_attributeValue.substring(0, in_attributeValue.length() - 2);
    }

    public static double convertAFMLLengthToPoints(String in_attributeValue) {
        if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue, false)) {
            in_attributeValue = in_attributeValue + "in";
        }
        double var_UnitConversion = AFMLAttribute__Abstract.getAFMLLengthToPointConversion(in_attributeValue);
        String var_LengthNumberString = AFMLAttribute__Abstract.getAFMLLengthNumberString(in_attributeValue);
        return var_UnitConversion * Double.parseDouble(var_LengthNumberString);
    }

    protected static double getAFMLEMLengthToFactorConversion(String in_attributeValue) {
        if (in_attributeValue.length() < 2) {
            return 0.0;
        }
        String var_unitString = in_attributeValue.substring(in_attributeValue.length() - 2);
        if (var_unitString.equalsIgnoreCase("em")) {
            return 1.0;
        }
        if (var_unitString.equalsIgnoreCase("en")) {
            return 0.5;
        }
        if (var_unitString.equalsIgnoreCase("ex")) {
            return 0.3333333333333333;
        }
        return 0.0;
    }

    private static Map<String, Double> computeAFMLLengthToConversionMap() {
        afmlLenToConvMap = new HashMap<String, Double>(32);
        afmlLenToConvMap.put("pt", 1.0);
        afmlLenToConvMap.put("pc", 12.0);
        afmlLenToConvMap.put("pp", 0.9962640099626402);
        afmlLenToConvMap.put("pi", 11.955168119551681);
        afmlLenToConvMap.put("in", 72.0);
        afmlLenToConvMap.put("cm", 28.346456692913385);
        afmlLenToConvMap.put("ci", 12.792132283464568);
        afmlLenToConvMap.put("tw", 0.05);
        afmlLenToConvMap.put("di", 1.0660110236220472);
        afmlLenToConvMap.put("ft", 864.0);
        afmlLenToConvMap.put("yd", 2592.0);
        afmlLenToConvMap.put("mm", 2.834645669291339);
        afmlLenToConvMap.put("mp", 0.001);
        afmlLenToConvMap.put("me", 2834.645669291339);
        afmlLenToConvMap.put("m.", 2834.645669291339);
        return afmlLenToConvMap;
    }

    protected static String getAFMLEMLengthNumberString(String in_attributeValue) {
        return in_attributeValue.substring(0, in_attributeValue.length() - 2);
    }

    protected static double convertAFMLEMLengthToFactor(String in_attributeValue) {
        double var_UnitConversion = AFMLAttribute__Abstract.getAFMLEMLengthToFactorConversion(in_attributeValue);
        String var_EMLengthNumberString = AFMLAttribute__Abstract.getAFMLEMLengthNumberString(in_attributeValue);
        return var_UnitConversion * Double.parseDouble(var_EMLengthNumberString);
    }

    protected static double getAFMLPercentageOrFactorConversion(String in_attributeValue) {
        switch (in_attributeValue.charAt(in_attributeValue.length() - 1)) {
            case '%': {
                return 0.01;
            }
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return 1.0;
            }
        }
        return 0.0;
    }

    protected static String getAFMLPercentageOrFactorNumberString(String in_attributeValue) {
        switch (in_attributeValue.charAt(in_attributeValue.length() - 1)) {
            case '%': {
                return in_attributeValue.substring(0, in_attributeValue.length() - 1);
            }
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return in_attributeValue;
            }
        }
        return in_attributeValue;
    }

    protected static double convertAFMLPercentageOrFactor(String in_attributeValue) {
        double var_PercentageConversion = AFMLAttribute__Abstract.getAFMLPercentageOrFactorConversion(in_attributeValue);
        String var_PercentageNumberString = AFMLAttribute__Abstract.getAFMLPercentageOrFactorNumberString(in_attributeValue);
        return var_PercentageConversion * Double.parseDouble(var_PercentageNumberString);
    }

    public static boolean isAFMLAttributeLength(String in_attributeValue) {
        if (AFMLAttribute__Abstract.getAFMLLengthToPointConversion(in_attributeValue) == 0.0) {
            return false;
        }
        String var_numberComponent = AFMLAttribute__Abstract.getAFMLLengthNumberString(in_attributeValue);
        if (var_numberComponent.length() == 0) {
            return false;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(var_numberComponent)) {
            return true;
        }
        return AFMLAttribute__Abstract.isAFMLAttributeNumber(var_numberComponent);
    }

    public static boolean isAFMLAttributeEMLength(String in_attributeValue) {
        if (AFMLAttribute__Abstract.getAFMLEMLengthToFactorConversion(in_attributeValue) == 0.0) {
            return false;
        }
        String var_numberComponent = AFMLAttribute__Abstract.getAFMLEMLengthNumberString(in_attributeValue);
        if (var_numberComponent.length() == 0) {
            return false;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(var_numberComponent)) {
            return true;
        }
        return AFMLAttribute__Abstract.isAFMLAttributeNumber(var_numberComponent);
    }

    public static boolean isAFMLAttributePercentageOrFactor(String in_attributeValue) {
        if (AFMLAttribute__Abstract.getAFMLPercentageOrFactorConversion(in_attributeValue) == 0.0) {
            return false;
        }
        String var_numberComponent = AFMLAttribute__Abstract.getAFMLPercentageOrFactorNumberString(in_attributeValue);
        if (var_numberComponent.length() == 0) {
            return false;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(var_numberComponent)) {
            return true;
        }
        return AFMLAttribute__Abstract.isAFMLAttributeNumber(var_numberComponent);
    }

    public static boolean isAFMLAttributePercentage(String in_attributeValue) {
        if (in_attributeValue.charAt(in_attributeValue.length() - 1) == '%') {
            String var_numberComponent = AFMLAttribute__Abstract.getAFMLPercentageOrFactorNumberString(in_attributeValue);
            if (var_numberComponent.length() == 0) {
                return false;
            }
            if (AFMLAttribute__Abstract.isAFMLAttributeInteger(var_numberComponent)) {
                return true;
            }
            if (AFMLAttribute__Abstract.isAFMLAttributeNumber(var_numberComponent)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAFMLAttributeNumber(String in_attributeValue, boolean checkDecimal) {
        if (in_attributeValue.length() == 0) {
            return false;
        }
        int var_currentIndex = 0;
        boolean var_decimalPointFound = false;
        boolean exponentialNotationFound = false;
        block7: for (var_currentIndex = 0; var_currentIndex < in_attributeValue.length(); ++var_currentIndex) {
            switch (in_attributeValue.charAt(var_currentIndex)) {
                case '-': {
                    if (exponentialNotationFound || var_currentIndex == 0) continue block7;
                    return false;
                }
                case '+': {
                    if (exponentialNotationFound || var_currentIndex == 0) continue block7;
                    return false;
                }
                case '.': {
                    if (var_decimalPointFound) {
                        return false;
                    }
                    var_decimalPointFound = true;
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block7;
                }
                case 'E': {
                    if (exponentialNotationFound) {
                        return false;
                    }
                    exponentialNotationFound = true;
                    return AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue.substring(var_currentIndex + 1));
                }
                default: {
                    return false;
                }
            }
        }
        if (checkDecimal) {
            return var_decimalPointFound;
        }
        return true;
    }

    public static boolean isAFMLAttributeNumber(String in_attributeValue) {
        return AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue, true);
    }

    public static boolean isAFMLAttributeInteger(String in_attributeValue) {
        if (in_attributeValue.length() == 0) {
            return false;
        }
        int var_currentIndex = 0;
        block5: for (var_currentIndex = 0; var_currentIndex < in_attributeValue.length(); ++var_currentIndex) {
            switch (in_attributeValue.charAt(var_currentIndex)) {
                case '-': {
                    if (var_currentIndex == 0) continue block5;
                    return false;
                }
                case '+': {
                    if (var_currentIndex == 0) continue block5;
                    return false;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

