/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.css20;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontProxy;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.FontSetStack;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.inlineformatting.FallbackFontSet;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSet;
import com.adobe.fontengine.inlineformatting.css20.CSS20GenericFontFamily;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.css20.PassThroughFamilyNameNormalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class CSS20FontDatabase
extends FontSetStack
implements CSS20FontSet {
    static final long serialVersionUID = 1L;
    private final FamilyNameNormalizer normalizer;
    private final boolean ignoreVariant;
    private HashMap fontsByFamilyName = new HashMap();
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private ArrayList serif = new ArrayList();
    private ArrayList sansSerif = new ArrayList();
    private ArrayList monospace = new ArrayList();
    private ArrayList fantasy = new ArrayList();
    private ArrayList cursive = new ArrayList();
    private FallbackFontSet fallbackFontSet = new FallbackFontSet();

    public CSS20FontDatabase() {
        this(new PassThroughFamilyNameNormalizer(), true);
    }

    public CSS20FontDatabase(boolean ignoreVariant) {
        this(new PassThroughFamilyNameNormalizer(), ignoreVariant);
    }

    public CSS20FontDatabase(FamilyNameNormalizer normalizer) {
        this(normalizer, true);
    }

    public CSS20FontDatabase(FamilyNameNormalizer normalizer, boolean ignoreVariant) {
        if (normalizer == null) {
            normalizer = new PassThroughFamilyNameNormalizer();
        }
        this.normalizer = normalizer;
        this.ignoreVariant = ignoreVariant;
    }

    public CSS20FontDatabase(CSS20FontDatabase original) {
        super(original);
        this.normalizer = original.normalizer;
        this.ignoreVariant = original.ignoreVariant;
        this.resolutionPriority = original.resolutionPriority;
        this.serif = (ArrayList)original.serif.clone();
        this.sansSerif = (ArrayList)original.sansSerif.clone();
        this.monospace = (ArrayList)original.monospace.clone();
        this.fantasy = (ArrayList)original.fantasy.clone();
        this.cursive = (ArrayList)original.cursive.clone();
        this.fallbackFontSet = original.fallbackFontSet;
        Set keySet = original.fontsByFamilyName.keySet();
        for (Object key : keySet) {
            CSSFontsWithSameName fontsByName = new CSSFontsWithSameName((CSSFontsWithSameName)original.fontsByFamilyName.get(key));
            this.fontsByFamilyName.put(key, fontsByName);
        }
    }

    public FontResolutionPriority setResolutionPriority(FontResolutionPriority priority) {
        FontResolutionPriority oldPriority = this.resolutionPriority;
        this.resolutionPriority = priority;
        return oldPriority;
    }

    public void addFont(Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        CSS20FontDescription[] fontDesc = font.getCSS20FontDescription();
        if (fontDesc == null) {
            throw new InvalidFontException("Font has no CSS20FontDescription", font);
        }
        for (int i = 0; i < fontDesc.length; ++i) {
            FontProxy fontProxy = new FontProxy(fontDesc[i], font);
            this.addFontProxy(fontProxy);
        }
    }

    public void addFont(CSS20FontDescription fontDesc, Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontProxy fontProxy = new FontProxy(fontDesc, font);
        this.addFontProxy(fontProxy);
    }

    private boolean addFontProxy(FontProxy fontProxy) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        boolean added;
        String familyName = this.normalizer.normalize(((CSS20FontDescription)fontProxy.getFontDescription()).getFamilyName());
        CSSFontsWithSameName fontsWithSameName = (CSSFontsWithSameName)this.fontsByFamilyName.get(familyName);
        if (fontsWithSameName == null) {
            fontsWithSameName = new CSSFontsWithSameName();
            this.fontsByFamilyName.put(familyName, fontsWithSameName);
        }
        if (added = fontsWithSameName.addFont(fontProxy)) {
            super.fontAdded(fontProxy);
        }
        return added;
    }

    protected void removeFontProxy(FontProxy fontProxy) {
        String familyName = this.normalizer.normalize(((CSS20FontDescription)fontProxy.getFontDescription()).getFamilyName());
        CSSFontsWithSameName fontsWithSameName = (CSSFontsWithSameName)this.fontsByFamilyName.get(familyName);
        if (fontsWithSameName != null) {
            fontsWithSameName.removeFont(fontProxy);
        }
    }

    public boolean isEmpty() {
        return this.fontsByFamilyName.isEmpty();
    }

    public void setGenericFont(CSS20GenericFontFamily genericFamily, String[] replacementFontNames) {
        ArrayList genericFamilyList = null;
        if (genericFamily == CSS20GenericFontFamily.SERIF) {
            genericFamilyList = this.serif;
        } else if (genericFamily == CSS20GenericFontFamily.SANS_SERIF) {
            genericFamilyList = this.sansSerif;
        } else if (genericFamily == CSS20GenericFontFamily.CURSIVE) {
            genericFamilyList = this.cursive;
        } else if (genericFamily == CSS20GenericFontFamily.FANTASY) {
            genericFamilyList = this.fantasy;
        } else if (genericFamily == CSS20GenericFontFamily.MONOSPACE) {
            genericFamilyList = this.monospace;
        } else {
            return;
        }
        genericFamilyList.clear();
        genericFamilyList.ensureCapacity(replacementFontNames.length);
        for (int i = 0; i < replacementFontNames.length; ++i) {
            genericFamilyList.add(i, replacementFontNames[i]);
        }
    }

    public void setFallbackFonts(FallbackFontSet fallbackFontSet) {
        this.fallbackFontSet = fallbackFontSet;
    }

    protected List getGenericFont(CSS20GenericFontFamily genericFamily) {
        if (genericFamily == CSS20GenericFontFamily.SERIF) {
            return this.serif;
        }
        if (genericFamily == CSS20GenericFontFamily.SANS_SERIF) {
            return this.sansSerif;
        }
        if (genericFamily == CSS20GenericFontFamily.CURSIVE) {
            return this.cursive;
        }
        if (genericFamily == CSS20GenericFontFamily.FANTASY) {
            return this.fantasy;
        }
        if (genericFamily == CSS20GenericFontFamily.MONOSPACE) {
            return this.monospace;
        }
        return null;
    }

    protected FallbackFontSet getFallbackFontSet() {
        return this.fallbackFontSet;
    }

    protected boolean replaceGenericFontFamily(List fontFamilyNames) {
        boolean foundGenerics = false;
        for (int i = 0; i < fontFamilyNames.size(); ++i) {
            String fontName = (String)fontFamilyNames.get(i);
            if (fontName.equals("serif")) {
                List serif = this.getGenericFont(CSS20GenericFontFamily.SERIF);
                fontFamilyNames.remove(i);
                if (serif == null) continue;
                fontFamilyNames.addAll(i, serif);
                foundGenerics = true;
                continue;
            }
            if (fontName.equals("sans-serif")) {
                List sansSerif = this.getGenericFont(CSS20GenericFontFamily.SANS_SERIF);
                fontFamilyNames.remove(i);
                if (sansSerif == null) continue;
                fontFamilyNames.addAll(i, sansSerif);
                foundGenerics = true;
                continue;
            }
            if (fontName.equals("cursive")) {
                List cursive = this.getGenericFont(CSS20GenericFontFamily.CURSIVE);
                fontFamilyNames.remove(i);
                if (cursive == null) continue;
                fontFamilyNames.addAll(i, cursive);
                foundGenerics = true;
                continue;
            }
            if (fontName.equals("fantasy")) {
                List fantasy = this.getGenericFont(CSS20GenericFontFamily.FANTASY);
                fontFamilyNames.remove(i);
                if (fantasy == null) continue;
                fontFamilyNames.addAll(i, fantasy);
                foundGenerics = true;
                continue;
            }
            if (!fontName.equals("monospace")) continue;
            List monospace = this.getGenericFont(CSS20GenericFontFamily.MONOSPACE);
            fontFamilyNames.remove(i);
            if (monospace == null) continue;
            fontFamilyNames.addAll(i, monospace);
            foundGenerics = true;
        }
        return foundGenerics;
    }

    protected Font[] findFont(String familyName, CSS20Attribute attributes) {
        Font[] foundFonts = null;
        CSSFontsWithSameName fontsWithSameName = (CSSFontsWithSameName)this.fontsByFamilyName.get(this.normalizer.normalize(familyName));
        if (fontsWithSameName != null) {
            foundFonts = fontsWithSameName.findFont(attributes);
        }
        return foundFonts;
    }

    public Font findFont(CSS20Attribute attributes, ULocale locale) throws FontException {
        List fontFamilyList = attributes.getFamilyNamesList();
        this.replaceGenericFontFamily(fontFamilyList);
        for (int i = 0; i < fontFamilyList.size(); ++i) {
            String familyName = (String)fontFamilyList.get(i);
            Font[] proposedFonts = this.findFont(familyName, attributes);
            if (proposedFonts == null) continue;
            return proposedFonts[0];
        }
        Iterator it = this.getFallbackFontSet().getFallbackFonts(locale);
        if (it.hasNext()) {
            return (Font)it.next();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CSS20FontDatabase)) {
            return false;
        }
        CSS20FontDatabase o = (CSS20FontDatabase)obj;
        return this.fontsByFamilyName.equals(o.fontsByFamilyName) && this.serif.equals(o.serif) && this.sansSerif.equals(o.sansSerif) && this.monospace.equals(o.monospace) && this.fantasy.equals(o.fantasy) && this.cursive.equals(o.cursive) && this.fallbackFontSet.equals(o.fallbackFontSet);
    }

    public int hashCode() {
        int hashCode = 0;
        int hashCode1 = this.fontsByFamilyName.hashCode();
        int hashCode2 = this.serif.hashCode();
        int hashCode3 = this.sansSerif.hashCode();
        int hashCode4 = this.monospace.hashCode();
        int hashCode5 = this.fantasy.hashCode();
        int hashCode6 = this.cursive.hashCode();
        int hashCode7 = this.fallbackFontSet.hashCode();
        hashCode = hashCode1 ^ hashCode2 ^ hashCode3 ^ hashCode4 ^ hashCode5 ^ hashCode6 ^ hashCode7;
        return hashCode;
    }

    public String toString() {
        TreeSet tempSet = new TreeSet();
        Iterator it = this.fontsByFamilyName.keySet().iterator();
        while (it.hasNext()) {
            tempSet.add(it.next());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("family names:\n");
        for (String k : tempSet) {
            sb.append("  ");
            sb.append(k);
            sb.append(" = ");
            sb.append(this.fontsByFamilyName.get(k).toString());
            sb.append("\n");
        }
        sb.append("generic names:\n");
        this.toString(sb, "serif", this.serif);
        this.toString(sb, "sans", this.sansSerif);
        this.toString(sb, "mono", this.monospace);
        this.toString(sb, "fantasy", this.fantasy);
        this.toString(sb, "cursive", this.cursive);
        sb.append("fallback fonts:\n");
        sb.append(this.fallbackFontSet.toString());
        return sb.toString();
    }

    protected void toString(StringBuffer sb, String key, ArrayList al) {
        TreeMap<String, Integer> tempMap = new TreeMap<String, Integer>();
        for (String name : al) {
            int count = 0;
            if (tempMap.containsKey(name)) {
                count = (Integer)tempMap.get(name);
            }
            tempMap.put(name, new Integer(++count));
        }
        sb.append("  ");
        sb.append(key);
        sb.append(" = {");
        String prefix = "'";
        for (String name : tempMap.keySet()) {
            int count = (Integer)tempMap.get(name);
            while (count-- > 0) {
                sb.append(prefix);
                sb.append("'");
                sb.append(name);
                sb.append("'");
                prefix = ", ";
            }
        }
        sb.append("}\n");
    }

    final class CSSFontsWithSameName
    implements Serializable {
        static final long serialVersionUID = 1L;
        private ArrayList[][] fonts = new ArrayList[2][3];
        private static final int kVariantNormal = 0;
        private static final int kVariantSmallCaps = 1;
        private static final int kVariantSize = 2;
        private static final int kStyleNormal = 0;
        private static final int kStyleOblique = 1;
        private static final int kStyleItalic = 2;
        private static final int kStyleSize = 3;

        protected CSSFontsWithSameName() {
        }

        protected CSSFontsWithSameName(CSSFontsWithSameName original) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (original.fonts[i][j] == null) continue;
                    this.fonts[i][j] = (ArrayList)original.fonts[i][j].clone();
                }
            }
        }

        protected boolean addFont(FontProxy fontProxy) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
            CSS20FontDescription fontDesc = (CSS20FontDescription)fontProxy.getFontDescription();
            ArrayList fontList = this.pickStyleVariantList(fontDesc.getVariant(), fontDesc.getStyle(), true);
            return this.insertFontInList(fontList, fontProxy);
        }

        protected boolean insertFontInList(ArrayList fontList, FontProxy fontProxy) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
            boolean wasAdded = true;
            if (fontList.size() == 0) {
                fontList.add(fontProxy);
            }
            CSS20FontDescription fontDesc = (CSS20FontDescription)fontProxy.getFontDescription();
            int[] bounds = new int[]{0, fontList.size()};
            this.findWeightRange(fontDesc.getWeight(), fontList, bounds);
            int foundWeight = ((CSS20FontDescription)((FontProxy)fontList.get(bounds[0])).getFontDescription()).getWeight();
            if (fontDesc.getWeight() < foundWeight) {
                fontList.add(bounds[0], fontProxy);
            } else if (fontDesc.getWeight() > foundWeight) {
                fontList.add(bounds[1], fontProxy);
            } else {
                this.findStretchRange(fontDesc.getStretch(), fontList, bounds);
                int foundStretch = ((CSS20FontDescription)((FontProxy)fontList.get(bounds[0])).getFontDescription()).getStretch().getValue();
                if (fontDesc.getStretch().getValue() < foundStretch) {
                    fontList.add(bounds[0], fontProxy);
                } else if (fontDesc.getStretch().getValue() > foundStretch) {
                    fontList.add(bounds[1], fontProxy);
                } else if (CSS20FontDatabase.this.resolutionPriority == FontResolutionPriority.LAST) {
                    fontList.add(bounds[0], fontProxy);
                } else if (CSS20FontDatabase.this.resolutionPriority == FontResolutionPriority.FIRST) {
                    fontList.add(bounds[1], fontProxy);
                } else {
                    Font fontInList = ((FontProxy)fontList.get(bounds[0])).getFont();
                    Font preferred = IntelligentResolver.choosePreferredFont(fontInList, fontProxy.getFont(), CSS20FontDatabase.this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST);
                    if (preferred == fontInList) {
                        fontList.add(bounds[1], fontProxy);
                    } else {
                        fontList.add(bounds[0], fontProxy);
                    }
                }
            }
            return wasAdded;
        }

        protected int findWeightRange(int searchWeight, ArrayList fontList, int[] bounds) {
            int bandWeight = 0;
            int[] bandBounds = new int[]{bounds[0], bounds[0]};
            for (int i = bounds[0]; i < bounds[1]; ++i) {
                FontProxy currentFontProxy = (FontProxy)fontList.get(i);
                CSS20FontDescription currentFontDescription = (CSS20FontDescription)currentFontProxy.getFontDescription();
                int currentWeight = currentFontDescription.getWeight();
                if (currentWeight == bandWeight) {
                    bandBounds[1] = i;
                    continue;
                }
                if (currentWeight <= bandWeight) continue;
                if (currentWeight <= searchWeight) {
                    bandBounds[0] = i;
                    bandBounds[1] = i;
                    bandWeight = currentWeight;
                    continue;
                }
                if (bandWeight == 0) {
                    bandBounds[0] = i;
                    bandBounds[1] = i;
                    bandWeight = currentWeight;
                    continue;
                }
                if (searchWeight <= CSS20Attribute.CSSWeightValue.W500.getValue() || bandWeight >= searchWeight) break;
                bandBounds[0] = i;
                bandBounds[1] = i;
                bandWeight = currentWeight;
            }
            bounds[0] = bandBounds[0];
            bounds[1] = bandBounds[1] + 1;
            return bounds[0];
        }

        protected int findStretchRange(CSS20Attribute.CSSStretchValue stretch, ArrayList fontList, int[] bounds) {
            int bandStretch = 0;
            int[] bandBounds = new int[]{bounds[0], bounds[0]};
            int searchStretch = stretch.getValue();
            for (int i = bounds[0]; i < bounds[1]; ++i) {
                FontProxy currentFontProxy = (FontProxy)fontList.get(i);
                CSS20FontDescription currentFontDescription = (CSS20FontDescription)currentFontProxy.getFontDescription();
                int currentStretch = currentFontDescription.getStretch().getValue();
                if (currentStretch == bandStretch) {
                    bandBounds[1] = i;
                    continue;
                }
                if (currentStretch <= bandStretch) continue;
                if (currentStretch <= searchStretch) {
                    bandBounds[0] = i;
                    bandBounds[1] = i;
                    bandStretch = currentStretch;
                    continue;
                }
                if (bandStretch == 0) {
                    bandBounds[0] = i;
                    bandBounds[1] = i;
                    bandStretch = currentStretch;
                    continue;
                }
                if (searchStretch <= CSS20Attribute.CSSStretchValue.NORMAL.getValue() || bandStretch >= searchStretch) break;
                bandBounds[0] = i;
                bandBounds[1] = i;
                bandStretch = currentStretch;
            }
            bounds[0] = bandBounds[0];
            bounds[1] = bandBounds[1] + 1;
            return bounds[0];
        }

        protected int findOpticalSize(double pointSize, ArrayList fontList, int[] bounds) {
            for (int i = bounds[0]; i < bounds[1]; ++i) {
                FontProxy currentFontProxy = (FontProxy)fontList.get(i);
                CSS20FontDescription currentFontDescription = (CSS20FontDescription)currentFontProxy.getFontDescription();
                double lowPointSize = currentFontDescription.getLowPointSize();
                double highPointSize = currentFontDescription.getHighPointSize();
                if (!(pointSize >= lowPointSize) || !(pointSize < highPointSize)) continue;
                return i;
            }
            return bounds[0];
        }

        protected Font[] findFont(CSS20Attribute attributes) {
            ArrayList fontList = this.pickStyleVariantList(attributes.getVariant(), attributes.getStyle(), false);
            Font[] foundFonts = null;
            if (fontList != null) {
                int foundFontIndex = 0;
                int[] bounds = new int[]{0, fontList.size()};
                this.findWeightRange(attributes.getWeight(), fontList, bounds);
                this.findStretchRange(attributes.getStretch(), fontList, bounds);
                foundFontIndex = this.findOpticalSize(attributes.getOpticalSize(), fontList, bounds);
                foundFonts = new Font[bounds[1] - bounds[0]];
                for (int i = 0; i < foundFonts.length; ++i) {
                    foundFonts[i] = ((FontProxy)fontList.get(foundFontIndex)).getFont();
                    foundFontIndex = ++foundFontIndex == bounds[1] ? bounds[0] : foundFontIndex;
                }
            }
            return foundFonts;
        }

        protected void removeFont(FontProxy fontProxy) {
            CSS20FontDescription fontDesc = (CSS20FontDescription)fontProxy.getFontDescription();
            ArrayList fontList = this.pickStyleVariantList(fontDesc.getVariant(), fontDesc.getStyle(), true);
            Iterator iter = fontList.iterator();
            while (iter.hasNext()) {
                FontProxy currentFontProxy = (FontProxy)iter.next();
                if (fontProxy != currentFontProxy) continue;
                iter.remove();
                break;
            }
        }

        private ArrayList pickStyleVariantList(CSS20Attribute.CSSVariantValue variant, CSS20Attribute.CSSStyleValue style, boolean createIfNull) {
            int variantIndex = variant == CSS20Attribute.CSSVariantValue.NORMAL || CSS20FontDatabase.this.ignoreVariant ? 0 : 1;
            int styleIndex = style == CSS20Attribute.CSSStyleValue.NORMAL ? 0 : (style == CSS20Attribute.CSSStyleValue.OBLIQUE ? 1 : 2);
            if (createIfNull && this.fonts[variantIndex][styleIndex] == null) {
                this.fonts[variantIndex][styleIndex] = new ArrayList();
            }
            return this.fonts[variantIndex][styleIndex];
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CSSFontsWithSameName)) {
                return false;
            }
            CSSFontsWithSameName o = (CSSFontsWithSameName)obj;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (!(this.fonts[i][j] != null ? !this.fonts[i][j].equals(o.fonts[i][j]) : o.fonts[i][j] != null)) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.fonts[i][j] == null) continue;
                    hashCode ^= this.fonts[i][j].hashCode();
                }
            }
            return hashCode;
        }

        public String toString() {
            TreeMap<String, Integer> tempMap = new TreeMap<String, Integer>();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.fonts.length; ++i) {
                for (int j = 0; j < this.fonts[i].length; ++j) {
                    if (this.fonts[i][j] == null) continue;
                    Iterator it = this.fonts[i][j].iterator();
                    while (it.hasNext()) {
                        String name = it.next().toString();
                        int count = 0;
                        if (tempMap.containsKey(name)) {
                            count = (Integer)tempMap.get(name);
                        }
                        tempMap.put(name, new Integer(++count));
                    }
                }
            }
            for (String name : tempMap.keySet()) {
                int count = (Integer)tempMap.get(name);
                while (count-- > 0) {
                    sb.append(name);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
    }
}

