/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.postscript;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.fontmanagement.postscript.PSNameResolver;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.css20.PassThroughFamilyNameNormalizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public final class PSNameFontDatabase
implements PSNameResolver {
    static final long serialVersionUID = 1L;
    private HashMap psFonts;
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private final FamilyNameNormalizer normalizer;

    public PSNameFontDatabase() {
        this(new PassThroughFamilyNameNormalizer());
    }

    public PSNameFontDatabase(FamilyNameNormalizer normalizer) {
        this.psFonts = new HashMap();
        if (normalizer == null) {
            normalizer = new PassThroughFamilyNameNormalizer();
        }
        this.normalizer = normalizer;
    }

    public PSNameFontDatabase(PSNameFontDatabase original) {
        this.psFonts = (HashMap)original.psFonts.clone();
        this.normalizer = original.normalizer;
    }

    public void addFont(Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        PostscriptFontDescription[] fontDesc = font.getPostscriptFontDescription();
        for (int i = 0; i < fontDesc.length; ++i) {
            this.addFont(fontDesc[i], font);
        }
    }

    public void addFont(PostscriptFontDescription psDesc, Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        String name = this.normalizer.normalize(psDesc.getPSName());
        Font oldFont = (Font)this.psFonts.get(name);
        if (oldFont != null) {
            Font preferredFont;
            if (this.resolutionPriority == FontResolutionPriority.FIRST) {
                return;
            }
            if ((this.resolutionPriority == FontResolutionPriority.INTELLIGENT_LAST || this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST) && (preferredFont = IntelligentResolver.choosePreferredFont(oldFont, font, this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST)) == oldFont) {
                return;
            }
        }
        this.psFonts.put(name, font);
    }

    public boolean isEmpty() {
        return this.psFonts.isEmpty();
    }

    public Font findFont(PostscriptFontDescription psDesc) {
        return this.findFont(psDesc.getPSName());
    }

    public Font findFont(String psName) {
        return (Font)this.psFonts.get(this.normalizer.normalize(psName));
    }

    public FontResolutionPriority setResolutionPriority(FontResolutionPriority priority) {
        FontResolutionPriority oldPriority = this.resolutionPriority;
        this.resolutionPriority = priority;
        return oldPriority;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.psFonts.equals(((PSNameFontDatabase)obj).psFonts);
    }

    public int hashCode() {
        return this.psFonts.hashCode();
    }

    public String toString() {
        TreeSet tempSet = new TreeSet();
        Iterator it = this.psFonts.keySet().iterator();
        while (it.hasNext()) {
            tempSet.add(it.next());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("priority = ");
        sb.append(this.resolutionPriority.toString());
        sb.append("; PS names = ");
        String prefix = "";
        Iterator it2 = tempSet.iterator();
        while (it2.hasNext()) {
            sb.append(prefix);
            sb.append((String)it2.next());
            prefix = ", ";
        }
        return sb.toString();
    }
}

