/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.postscript.SeacPhase;
import com.adobe.fontengine.font.postscript.StandardEncoding;
import com.adobe.fontengine.font.type1.Type1Font;

public final class Type1CStringParser {
    private static final int CMD_RESERVED0 = 0;
    private static final int CMD_HSTEM = 1;
    private static final int CMD_RESERVED2 = 2;
    private static final int CMD_VSTEM = 3;
    private static final int CMD_VMOVETO = 4;
    private static final int CMD_RLINETO = 5;
    private static final int CMD_HLINETO = 6;
    private static final int CMD_VLINETO = 7;
    private static final int CMD_RRCURVETO = 8;
    private static final int CMD_CLOSEPATH = 9;
    private static final int CMD_CALLSUBR = 10;
    private static final int CMD_RETURN = 11;
    private static final int CMD_ESC = 12;
    private static final int CMD_HSBW = 13;
    private static final int CMD_ENDCHAR = 14;
    private static final int CMD_MOVETO = 15;
    private static final int CMD_BLEND = 16;
    private static final int CMD_RESERVED17 = 17;
    private static final int CMD_RESERVED18 = 18;
    private static final int CMD_RESERVED19 = 19;
    private static final int CMD_RESERVED20 = 20;
    private static final int CMD_RMOVETO = 21;
    private static final int CMD_HMOVETO = 22;
    private static final int CMD_RESERVED23 = 23;
    private static final int CMD_RESERVED24 = 24;
    private static final int CMD_RESERVED25 = 25;
    private static final int CMD_RESERVED26 = 26;
    private static final int CMD_RESERVED27 = 27;
    private static final int CMD_RESERVED28 = 28;
    private static final int CMD_RESERVED29 = 29;
    private static final int CMD_VHCURVETO = 30;
    private static final int CMD_HVCURVETO = 31;
    private static final int ESC_DOTSECTION = 0;
    private static final int ESC_VSTEM3 = 1;
    private static final int ESC_HSTEM3 = 2;
    private static final int ESC_AND = 3;
    private static final int ESC_OR = 4;
    private static final int ESC_NOT = 5;
    private static final int ESC_SEAC = 6;
    private static final int ESC_SBW = 7;
    private static final int ESC_STORE = 8;
    private static final int ESC_ABS = 9;
    private static final int ESC_ADD = 10;
    private static final int ESC_SUB = 11;
    private static final int ESC_DIV = 12;
    private static final int ESC_LOAD = 13;
    private static final int ESC_NEG = 14;
    private static final int ESC_EQ = 15;
    private static final int ESC_CALLOTHER = 16;
    private static final int ESC_POP = 17;
    private static final int ESC_DROP = 18;
    private static final int ESC_RESERVED19 = 19;
    private static final int ESC_PUT = 20;
    private static final int ESC_GET = 21;
    private static final int ESC_IFELSE = 22;
    private static final int ESC_RANDOM = 23;
    private static final int ESC_MUL = 24;
    private static final int ESC_DIV2 = 25;
    private static final int ESC_SQRT = 26;
    private static final int ESC_DUP = 27;
    private static final int ESC_EXCH = 28;
    private static final int ESC_INDEX = 29;
    private static final int ESC_ROLL = 30;
    private static final int ESC_RESERVED31 = 31;
    private static final int ESC_RESERVED32 = 32;
    private static final int ESC_SETCURRENTPOINT = 33;
    private static final int OTHER_FLEX = 0;
    private static final int OTHER_PREFLEX1 = 1;
    private static final int OTHER_PREFLEX2 = 2;
    private static final int OTHER_HINTSUBS = 3;
    private static final int OTHER_RESERVED4 = 4;
    private static final int OTHER_GLOBALCOLORME = 6;
    private static final int OTHER_RESERVED7 = 7;
    private static final int OTHER_RESERVED8 = 8;
    private static final int OTHER_RESERVED9 = 9;
    private static final int OTHER_RESERVED10 = 10;
    private static final int OTHER_RESERVED11 = 11;
    private static final int OTHER_GLBCLR1 = 12;
    private static final int OTHER_GLBCLR2 = 13;
    private static final int OTHER_BLEND1 = 14;
    private static final int OTHER_BLEND2 = 15;
    private static final int OTHER_BLEND3 = 16;
    private static final int OTHER_BLEND4 = 17;
    private static final int OTHER_BLEND6 = 18;
    private static final int OTHER_STOREWV = 19;
    private static final int OTHER_ADD = 20;
    private static final int OTHER_SUB = 21;
    private static final int OTHER_MUL = 22;
    private static final int OTHER_DIV = 23;
    private static final int OTHER_PUT = 24;
    private static final int OTHER_GET = 25;
    private static final int OTHER_PSPUT = 26;
    private static final int OTHER_IFELSE = 27;
    private static final int OTHER_RANDOM = 28;
    private static final int OTHER_DUP = 29;
    private static final int OTHER_EXCH = 30;
    private static final int MAX_STACK_SIZE = 24;
    private static final int MAX_STORAGE_SIZE = 32;
    private static final int MAX_FLEX = 17;
    private SeacPhase seacPhase;
    private double seac_adx;
    private double seac_ady;
    private double currentX;
    private double currentY;
    private double lsb_x;
    private double lsb_y;
    private int stackCount;
    private double[] stack = new double[24];
    private double[] storage = new double[32];
    private int flexCount;
    private double[] flexArgs = new double[17];
    private int counterCount;
    private double[] counters = new double[194];
    private boolean inFlex;
    private boolean pendingMove;
    private boolean endcharSeen;
    private boolean pendingHintSub;
    private boolean seenHintSub;
    private boolean movetoSeen;

    private void push(double arg) {
        this.stack[this.stackCount++] = arg;
    }

    private double pop() {
        return this.stack[--this.stackCount];
    }

    private double index(int i) {
        return this.stack[i];
    }

    private void clearStack() {
        this.stackCount = 0;
    }

    private void pushFlex(double arg) {
        this.flexArgs[this.flexCount++] = arg;
    }

    private void checkFlex(int cnt) throws InvalidGlyphException {
        if (this.flexCount + cnt > 17) {
            throw new InvalidGlyphException("too many flex args");
        }
    }

    private void checkUnderflow(int cnt) throws InvalidGlyphException {
        if (this.stackCount < cnt) {
            throw new InvalidGlyphException("Stack underflow in charstring");
        }
    }

    private void checkOverflow(int cnt) throws InvalidGlyphException {
        if (this.stackCount + cnt > 24) {
            throw new InvalidGlyphException("Stack overflow in charstring");
        }
    }

    private void doAnd() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        if (a != 0.0 && b != 0.0) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doOr() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        if (a != 0.0 || b != 0.0) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doNot() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double a = this.pop();
        if (a == 0.0) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doAbs() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double a = this.pop();
        if (a < 0.0) {
            this.push(-a);
        } else {
            this.push(a);
        }
    }

    private void doAdd() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        this.push(a + b);
    }

    private void doSub() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        this.push(b - a);
    }

    private void doNeg() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double a = this.pop();
        this.push(-a);
    }

    private void doEq() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        if (a == b) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doIfElse() throws InvalidGlyphException {
        this.checkUnderflow(4);
        double c1 = this.pop();
        double c2 = this.pop();
        double s1 = this.pop();
        double s2 = this.pop();
        this.push(c2 <= c1 ? s2 : s1);
    }

    private void doSqrt() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double a = this.pop();
        if (a < 0.0) {
            throw new InvalidGlyphException("Invalid sqrt argument");
        }
        this.push(Math.sqrt(a));
    }

    private void doPut() throws InvalidGlyphException {
        this.checkUnderflow(2);
        int index = (int)this.pop();
        if (index < 0 || index >= 32) {
            throw new InvalidGlyphException("Invalid index");
        }
        this.storage[index] = this.pop();
    }

    private void doGet() throws InvalidGlyphException {
        this.checkUnderflow(1);
        int index = (int)this.pop();
        if (index < 0 || index >= 32) {
            throw new InvalidGlyphException("Invalid index");
        }
        this.push(this.storage[index]);
    }

    private void doMul() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        this.push(a * b);
    }

    private void doDiv() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        this.push(b / a);
    }

    private void doDup() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double a = this.pop();
        this.checkOverflow(2);
        this.push(a);
        this.push(a);
    }

    private void doExch() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double a = this.pop();
        double b = this.pop();
        this.push(a);
        this.push(b);
    }

    private void reverse(int i, int j) {
        while (i < j) {
            double tmp = this.stack[i];
            this.stack[i++] = this.stack[j];
            this.stack[j--] = tmp;
        }
    }

    private double shiftStem(boolean verticalStem, double stem) {
        stem = this.seacPhase == SeacPhase.seacAccentPostMove || this.seacPhase == SeacPhase.seacAccentPreMove ? (stem += verticalStem ? this.seac_adx : this.seac_ady) : (stem += verticalStem ? this.lsb_x : this.lsb_y);
        return stem;
    }

    private void doStem(HintedOutlineConsumer consumer, boolean verticalStem, double stem1, double delta) {
        if (!this.seenHintSub && this.movetoSeen) {
            this.seenHintSub = true;
            this.pendingHintSub = true;
        }
        stem1 = this.shiftStem(verticalStem, stem1);
        consumer.stem(stem1, stem1 + delta, this.pendingHintSub, verticalStem, false);
        this.pendingHintSub = false;
    }

    private void doStem3(HintedOutlineConsumer consumer, boolean verticalStem) throws InvalidGlyphException {
        if (!this.seenHintSub && this.movetoSeen) {
            this.seenHintSub = true;
            this.pendingHintSub = true;
        }
        this.checkUnderflow(6);
        double s1 = this.index(0);
        double d1 = this.index(1);
        double s2 = this.index(2);
        double d2 = this.index(3);
        double s3 = this.index(4);
        double d3 = this.index(5);
        s1 = this.shiftStem(verticalStem, s1);
        s2 = this.shiftStem(verticalStem, s2);
        s3 = this.shiftStem(verticalStem, s3);
        consumer.stem3(s1, s1 + d1, s2, s2 + d2, s3, s3 + d3, this.pendingHintSub, verticalStem);
        this.pendingHintSub = false;
    }

    private void doMoveto(HintedOutlineConsumer consumer, double dx, double dy) {
        this.pendingMove = false;
        this.movetoSeen = true;
        if (this.seacPhase == SeacPhase.seacAccentPreMove) {
            this.currentX = this.seac_adx + dx;
            this.currentY = this.seac_ady + dy;
            this.seacPhase = SeacPhase.seacAccentPostMove;
        } else {
            this.currentX += dx;
            this.currentY += dy;
        }
        consumer.moveto(this.currentX, this.currentY);
    }

    private void doLineto(HintedOutlineConsumer consumer, double dx, double dy) {
        if (this.pendingMove) {
            this.doMoveto(consumer, 0.0, 0.0);
        }
        this.currentX += dx;
        this.currentY += dy;
        consumer.lineto(this.currentX, this.currentY);
    }

    private void doCurveto(HintedOutlineConsumer consumer, double a1, double a2, double a3, double a4, double a5, double a6) {
        if (this.pendingMove) {
            this.doMoveto(consumer, 0.0, 0.0);
        }
        double x1 = this.currentX + a1;
        double y1 = this.currentY + a2;
        double x2 = x1 + a3;
        double y2 = y1 + a4;
        this.currentX = x2 + a5;
        this.currentY = y2 + a6;
        consumer.curveto(x1, y1, x2, y2, this.currentX, this.currentY);
    }

    private void doFlex(HintedOutlineConsumer consumer) {
        if (this.pendingMove) {
            this.doMoveto(consumer, 0.0, 0.0);
        }
        double x1 = this.currentX + this.flexArgs[0] + this.flexArgs[2];
        double y1 = this.currentY + this.flexArgs[1] + this.flexArgs[3];
        double x2 = x1 + this.flexArgs[4];
        double y2 = y1 + this.flexArgs[5];
        double x3 = x2 + this.flexArgs[6];
        double y3 = y2 + this.flexArgs[7];
        double x4 = x3 + this.flexArgs[8];
        double y4 = y3 + this.flexArgs[9];
        double x5 = x4 + this.flexArgs[10];
        double y5 = y4 + this.flexArgs[11];
        double x6 = x5 + this.flexArgs[12];
        double y6 = y5 + this.flexArgs[13];
        this.currentX = x6;
        this.currentY = y6;
        consumer.flex(this.flexArgs[14], x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6);
        if (this.seacPhase == SeacPhase.seacNone || this.seacPhase == SeacPhase.seacBase) {
            this.currentX = this.flexArgs[15];
            this.currentY = this.flexArgs[16];
        }
    }

    private boolean doWidth(HintedOutlineConsumer consumer, double width) {
        if (width < -32000.0 || width > 32000.0) {
            width /= 65536.0;
        }
        return consumer.width(width);
    }

    private int addCounterGroup(HintedOutlineConsumer consumer, int index, boolean isVertical, boolean newGroup) {
        double edge0;
        double edge1 = 0.0;
        while (true) {
            edge0 = edge1 + this.counters[index--];
            double width = this.counters[index--];
            edge1 = edge0 + width;
            if (width < 0.0) break;
            consumer.stem(edge0, edge1, newGroup, isVertical, true);
            newGroup = false;
        }
        consumer.stem(edge1, edge0, newGroup, isVertical, true);
        return index;
    }

    private void addCounters(HintedOutlineConsumer consumer, boolean endOfCounters) {
        int numVertGroups;
        int i;
        for (i = this.stackCount - 1; i >= 0; --i) {
            this.counters[this.counterCount++] = this.stack[i];
        }
        if (!endOfCounters) {
            return;
        }
        int j = this.counterCount - 1;
        int numHorizGroups = (int)this.counters[j];
        int startOfHoriz = j - 1;
        for (i = 0; i < numHorizGroups; ++i) {
            do {
                if ((j -= 2) >= 1) continue;
                return;
            } while (this.counters[j] >= 0.0);
        }
        int startOfVert = --j;
        if ((numVertGroups = (int)this.counters[startOfVert--]) == 0 && numHorizGroups == 0) {
            consumer.noCounters();
        } else {
            while (numHorizGroups > 0 || numVertGroups > 0) {
                if (numHorizGroups-- > 0) {
                    startOfHoriz = this.addCounterGroup(consumer, startOfHoriz, false, true);
                    if (numVertGroups-- <= 0) continue;
                    startOfVert = this.addCounterGroup(consumer, startOfVert, true, false);
                    continue;
                }
                --numVertGroups;
                startOfVert = this.addCounterGroup(consumer, startOfVert, true, true);
            }
        }
    }

    private void internalParse(Type1Font type1Font, byte[] charString, HintedOutlineConsumer consumer) throws InvalidGlyphException, UnsupportedFontException {
        block78: for (int i = 0; i < charString.length; ++i) {
            int byte0 = charString[i] & 0xFF;
            block0 : switch (byte0) {
                case 0: 
                case 2: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    throw new InvalidGlyphException("illegal charstring operator");
                }
                case 1: {
                    this.checkUnderflow(2);
                    this.doStem(consumer, false, this.index(0), this.index(1));
                    break;
                }
                case 3: {
                    this.checkUnderflow(2);
                    this.doStem(consumer, true, this.index(0), this.index(1));
                    break;
                }
                case 4: {
                    this.checkUnderflow(1);
                    if (this.inFlex) {
                        this.checkFlex(2);
                        this.pushFlex(0.0);
                        this.pushFlex(this.index(0));
                        break;
                    }
                    this.doMoveto(consumer, 0.0, this.index(0));
                    break;
                }
                case 5: {
                    this.checkUnderflow(2);
                    this.doLineto(consumer, this.index(0), this.index(1));
                    break;
                }
                case 6: {
                    this.checkUnderflow(1);
                    this.doLineto(consumer, this.index(0), 0.0);
                    break;
                }
                case 7: {
                    this.checkUnderflow(1);
                    this.doLineto(consumer, 0.0, this.index(0));
                    break;
                }
                case 8: {
                    this.checkUnderflow(6);
                    this.doCurveto(consumer, this.index(0), this.index(1), this.index(2), this.index(3), this.index(4), this.index(5));
                    break;
                }
                case 9: {
                    this.pendingMove = true;
                    consumer.closepath();
                    break;
                }
                case 10: {
                    this.checkUnderflow(1);
                    int subrNumber = (int)this.pop();
                    if (subrNumber < 0 || subrNumber > type1Font.getNumSubrs()) {
                        throw new InvalidGlyphException("invalid subr number");
                    }
                    byte[] subr = type1Font.getSubr(subrNumber);
                    int currOffset = i;
                    this.internalParse(type1Font, subr, consumer);
                    if (this.endcharSeen) {
                        return;
                    }
                    i = currOffset;
                    continue block78;
                }
                case 11: {
                    return;
                }
                case 12: {
                    if (++i >= charString.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    byte0 = charString[i] & 0xFF;
                    switch (byte0) {
                        case 0: {
                            break block0;
                        }
                        case 3: {
                            this.doAnd();
                            continue block78;
                        }
                        case 4: {
                            this.doOr();
                            continue block78;
                        }
                        case 5: {
                            this.doNot();
                            continue block78;
                        }
                        case 8: {
                            throw new UnsupportedFontException("mm not supported");
                        }
                        case 9: {
                            this.doAbs();
                            continue block78;
                        }
                        case 10: {
                            this.doAdd();
                            continue block78;
                        }
                        case 11: {
                            this.doSub();
                            continue block78;
                        }
                        case 13: {
                            throw new UnsupportedFontException("mm not supported");
                        }
                        case 14: {
                            this.doNeg();
                            continue block78;
                        }
                        case 15: {
                            this.doEq();
                            continue block78;
                        }
                        case 18: {
                            this.checkUnderflow(1);
                            --this.stackCount;
                            continue block78;
                        }
                        case 20: {
                            this.doPut();
                            continue block78;
                        }
                        case 21: {
                            this.doGet();
                            continue block78;
                        }
                        case 22: {
                            this.doIfElse();
                            continue block78;
                        }
                        case 23: {
                            continue block78;
                        }
                        case 24: {
                            this.doMul();
                            continue block78;
                        }
                        case 26: {
                            this.doSqrt();
                            continue block78;
                        }
                        case 27: {
                            this.doDup();
                            continue block78;
                        }
                        case 28: {
                            this.doExch();
                            continue block78;
                        }
                        case 29: {
                            this.checkUnderflow(1);
                            int index = (int)this.pop();
                            if (index < 0) {
                                index = 0;
                            }
                            if (index >= this.stackCount) {
                                throw new InvalidGlyphException("invalid index");
                            }
                            this.push(this.stack[this.stackCount - 1 - index]);
                            continue block78;
                        }
                        case 30: {
                            this.checkUnderflow(2);
                            int j = (int)this.pop();
                            int n = (int)this.pop();
                            int top = this.stackCount - 1;
                            int bottom = this.stackCount - n;
                            if (n < 0 || bottom < 0) {
                                throw new InvalidGlyphException("invalid roll");
                            }
                            if (j < 0) {
                                j = n - -j % n;
                            }
                            this.reverse(top - (j %= n) + 1, top);
                            this.reverse(bottom, top - j);
                            this.reverse(bottom, top);
                            continue block78;
                        }
                        case 1: {
                            this.doStem3(consumer, true);
                            break block0;
                        }
                        case 2: {
                            this.doStem3(consumer, false);
                            break block0;
                        }
                        case 6: {
                            this.checkUnderflow(5);
                            String bChar = StandardEncoding.names[(int)this.index(3) & 0xFF];
                            String aChar = StandardEncoding.names[(int)this.index(4) & 0xFF];
                            this.seac_adx = this.lsb_x + this.index(1);
                            this.seac_ady = this.lsb_y + this.index(2);
                            this.seacPhase = SeacPhase.seacBase;
                            byte[] nextcharstring = type1Font.getCharstring(type1Font.glyphName2gid(bChar));
                            this.internalParse(type1Font, nextcharstring, consumer);
                            this.endcharSeen = false;
                            this.pendingHintSub = true;
                            this.seacPhase = SeacPhase.seacAccentPreMove;
                            nextcharstring = type1Font.getCharstring(type1Font.glyphName2gid(aChar));
                            this.internalParse(type1Font, nextcharstring, consumer);
                            return;
                        }
                        case 7: {
                            if (this.seacPhase != SeacPhase.seacNone) break block0;
                            this.checkUnderflow(4);
                            this.currentY = this.lsb_y = this.index(1);
                            this.currentX = this.lsb_x = this.index(0);
                            if (this.doWidth(consumer, this.index(2))) break block0;
                            return;
                        }
                        case 12: {
                            this.doDiv();
                            continue block78;
                        }
                        case 16: {
                            this.checkUnderflow(2);
                            int othersubr = (int)this.pop();
                            this.pop();
                            switch (othersubr) {
                                case 0: {
                                    this.checkUnderflow(3);
                                    if (this.flexCount != 14) {
                                        throw new InvalidGlyphException("missing flex arguments");
                                    }
                                    this.pushFlex(this.index(0));
                                    this.pushFlex(this.index(1));
                                    this.pushFlex(this.index(2));
                                    this.doFlex(consumer);
                                    break block0;
                                }
                                case 1: {
                                    this.flexCount = 0;
                                    this.inFlex = true;
                                    continue block78;
                                }
                                case 2: {
                                    continue block78;
                                }
                                case 3: {
                                    this.pendingHintSub = true;
                                    this.seenHintSub = true;
                                    continue block78;
                                }
                                case 6: {
                                    consumer.globalColorOn();
                                    continue block78;
                                }
                                case 12: {
                                    this.addCounters(consumer, false);
                                    break block0;
                                }
                                case 13: {
                                    this.addCounters(consumer, true);
                                    break block0;
                                }
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: {
                                    throw new UnsupportedFontException("mm not supported");
                                }
                                case 20: {
                                    this.doAdd();
                                    continue block78;
                                }
                                case 21: {
                                    this.doSub();
                                    continue block78;
                                }
                                case 22: {
                                    this.doMul();
                                    continue block78;
                                }
                                case 23: {
                                    this.doDiv();
                                    continue block78;
                                }
                                case 24: {
                                    this.doPut();
                                    continue block78;
                                }
                                case 25: {
                                    this.doGet();
                                    continue block78;
                                }
                                case 27: {
                                    this.doIfElse();
                                    continue block78;
                                }
                                case 28: {
                                    continue block78;
                                }
                                case 29: {
                                    this.doDup();
                                    continue block78;
                                }
                                case 30: {
                                    this.doExch();
                                    continue block78;
                                }
                                case 19: {
                                    throw new UnsupportedFontException("mm not supported");
                                }
                                default: {
                                    throw new InvalidGlyphException("Invalid OtherSubr");
                                }
                            }
                        }
                        case 17: {
                            continue block78;
                        }
                        case 25: {
                            this.doDiv();
                            continue block78;
                        }
                        case 33: {
                            if (this.inFlex) {
                                this.inFlex = false;
                                break block0;
                            }
                            this.checkUnderflow(2);
                            this.currentX = this.index(0);
                            this.currentY = this.index(1);
                            break block0;
                        }
                        default: {
                            throw new InvalidGlyphException("illegal operators in charstring");
                        }
                    }
                }
                case 13: {
                    if (this.seacPhase != SeacPhase.seacNone) break;
                    this.checkUnderflow(2);
                    this.currentX = this.lsb_x = this.index(0);
                    this.lsb_y = 0.0;
                    this.currentY = 0.0;
                    if (this.doWidth(consumer, this.index(1))) break;
                    return;
                }
                case 14: {
                    this.pendingMove = true;
                    this.endcharSeen = true;
                    if (this.seacPhase != SeacPhase.seacBase) {
                        consumer.endchar();
                    }
                    return;
                }
                case 15: {
                    this.checkUnderflow(2);
                    double secondArg = this.pop();
                    this.push(this.pop() - this.currentX);
                    this.push(secondArg - this.currentY);
                }
                case 21: {
                    this.checkUnderflow(2);
                    if (this.inFlex) {
                        this.checkFlex(2);
                        this.pushFlex(this.index(0));
                        this.pushFlex(this.index(1));
                        break;
                    }
                    this.doMoveto(consumer, this.index(0), this.index(1));
                    break;
                }
                case 22: {
                    this.checkUnderflow(1);
                    if (this.inFlex) {
                        this.checkFlex(2);
                        this.pushFlex(this.index(0));
                        this.pushFlex(0.0);
                        break;
                    }
                    this.doMoveto(consumer, this.index(0), 0.0);
                    break;
                }
                case 30: {
                    this.checkUnderflow(4);
                    this.doCurveto(consumer, 0.0, this.index(0), this.index(1), this.index(2), this.index(3), 0.0);
                    break;
                }
                case 31: {
                    this.checkUnderflow(4);
                    this.doCurveto(consumer, this.index(0), 0.0, this.index(1), this.index(2), 0.0, this.index(3));
                    break;
                }
                default: {
                    this.checkOverflow(1);
                    this.push(byte0 - 139);
                    continue block78;
                }
                case 247: 
                case 248: 
                case 249: 
                case 250: {
                    this.checkOverflow(1);
                    if (++i >= charString.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    int next = charString[i] & 0xFF;
                    this.push(108 + 256 * (byte0 - 247) + next);
                    continue block78;
                }
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    this.checkOverflow(1);
                    if (++i >= charString.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    int next = charString[i] & 0xFF;
                    this.push(-108 - 256 * (byte0 - 251) - next);
                    continue block78;
                }
                case 255: {
                    this.checkOverflow(1);
                    if (i + 4 >= charString.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    int value = charString[++i] & 0xFF;
                    value = value << 8 | charString[++i] & 0xFF;
                    value = value << 8 | charString[++i] & 0xFF;
                    value = value << 8 | charString[++i] & 0xFF;
                    this.push(value);
                    continue block78;
                }
            }
            this.clearStack();
        }
        consumer.endchar();
    }

    public void parse(HintedOutlineConsumer consumer, Type1Font type1Font, int glyphID) throws InvalidGlyphException, UnsupportedFontException {
        byte[] charstring = type1Font.getCharstring(glyphID);
        this.lsb_y = 0.0;
        this.lsb_x = 0.0;
        this.currentY = 0.0;
        this.currentX = 0.0;
        this.seacPhase = SeacPhase.seacNone;
        this.stackCount = 0;
        this.counterCount = 0;
        this.inFlex = false;
        this.pendingMove = true;
        this.endcharSeen = false;
        this.pendingHintSub = false;
        this.seenHintSub = false;
        this.movetoSeen = false;
        this.internalParse(type1Font, charstring, consumer);
    }
}

