/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.SubArrays;
import com.adobe.fontengine.font.type1.MetricFile;
import java.io.IOException;
import java.net.URL;
import java.util.TreeMap;

final class PFM
extends MetricFile {
    private static final int DEVICE_OFFSET = 101;
    private static final int KERNOFFSET_OFFSET = 131;
    private static final byte[] psTag = new byte[]{80, 111, 115, 116, 83, 99, 114, 105, 112, 116};
    private static final TreeMap glyphNameToWinAnsiCP = new TreeMap();
    private final String psName;
    private final String winName;
    private final int weight;
    private final boolean isItalic;
    private final KernData kernData;

    private PFM(String ps, String win, int wt, URL url, boolean isItalic, byte[] kernData) {
        super(url);
        glyphNameToWinAnsiCP.put("space", new Integer(32));
        glyphNameToWinAnsiCP.put("exclam", new Integer(33));
        glyphNameToWinAnsiCP.put("quotedbl", new Integer(34));
        glyphNameToWinAnsiCP.put("numbersign", new Integer(35));
        glyphNameToWinAnsiCP.put("dollar", new Integer(36));
        glyphNameToWinAnsiCP.put("percent", new Integer(37));
        glyphNameToWinAnsiCP.put("ampersand", new Integer(38));
        glyphNameToWinAnsiCP.put("quotesingle", new Integer(39));
        glyphNameToWinAnsiCP.put("parenleft", new Integer(40));
        glyphNameToWinAnsiCP.put("parenright", new Integer(41));
        glyphNameToWinAnsiCP.put("asterisk", new Integer(42));
        glyphNameToWinAnsiCP.put("plus", new Integer(43));
        glyphNameToWinAnsiCP.put("comma", new Integer(44));
        glyphNameToWinAnsiCP.put("hyphen", new Integer(45));
        glyphNameToWinAnsiCP.put("period", new Integer(46));
        glyphNameToWinAnsiCP.put("slash", new Integer(47));
        glyphNameToWinAnsiCP.put("zero", new Integer(48));
        glyphNameToWinAnsiCP.put("one", new Integer(49));
        glyphNameToWinAnsiCP.put("two", new Integer(50));
        glyphNameToWinAnsiCP.put("three", new Integer(51));
        glyphNameToWinAnsiCP.put("four", new Integer(52));
        glyphNameToWinAnsiCP.put("five", new Integer(53));
        glyphNameToWinAnsiCP.put("six", new Integer(54));
        glyphNameToWinAnsiCP.put("seven", new Integer(55));
        glyphNameToWinAnsiCP.put("eight", new Integer(56));
        glyphNameToWinAnsiCP.put("nine", new Integer(57));
        glyphNameToWinAnsiCP.put("colon", new Integer(58));
        glyphNameToWinAnsiCP.put("semicolon", new Integer(59));
        glyphNameToWinAnsiCP.put("less", new Integer(60));
        glyphNameToWinAnsiCP.put("equal", new Integer(61));
        glyphNameToWinAnsiCP.put("greater", new Integer(62));
        glyphNameToWinAnsiCP.put("question", new Integer(63));
        glyphNameToWinAnsiCP.put("at", new Integer(64));
        glyphNameToWinAnsiCP.put("A", new Integer(65));
        glyphNameToWinAnsiCP.put("B", new Integer(66));
        glyphNameToWinAnsiCP.put("C", new Integer(67));
        glyphNameToWinAnsiCP.put("D", new Integer(68));
        glyphNameToWinAnsiCP.put("E", new Integer(69));
        glyphNameToWinAnsiCP.put("F", new Integer(70));
        glyphNameToWinAnsiCP.put("G", new Integer(71));
        glyphNameToWinAnsiCP.put("H", new Integer(72));
        glyphNameToWinAnsiCP.put("I", new Integer(73));
        glyphNameToWinAnsiCP.put("J", new Integer(74));
        glyphNameToWinAnsiCP.put("K", new Integer(75));
        glyphNameToWinAnsiCP.put("L", new Integer(76));
        glyphNameToWinAnsiCP.put("M", new Integer(77));
        glyphNameToWinAnsiCP.put("N", new Integer(78));
        glyphNameToWinAnsiCP.put("O", new Integer(79));
        glyphNameToWinAnsiCP.put("P", new Integer(80));
        glyphNameToWinAnsiCP.put("Q", new Integer(81));
        glyphNameToWinAnsiCP.put("R", new Integer(82));
        glyphNameToWinAnsiCP.put("S", new Integer(83));
        glyphNameToWinAnsiCP.put("T", new Integer(84));
        glyphNameToWinAnsiCP.put("U", new Integer(85));
        glyphNameToWinAnsiCP.put("V", new Integer(86));
        glyphNameToWinAnsiCP.put("W", new Integer(87));
        glyphNameToWinAnsiCP.put("X", new Integer(88));
        glyphNameToWinAnsiCP.put("Y", new Integer(89));
        glyphNameToWinAnsiCP.put("Z", new Integer(90));
        glyphNameToWinAnsiCP.put("bracketleft", new Integer(91));
        glyphNameToWinAnsiCP.put("backslash", new Integer(92));
        glyphNameToWinAnsiCP.put("bracketright", new Integer(93));
        glyphNameToWinAnsiCP.put("asciicircum", new Integer(94));
        glyphNameToWinAnsiCP.put("underscore", new Integer(95));
        glyphNameToWinAnsiCP.put("grave", new Integer(96));
        glyphNameToWinAnsiCP.put("a", new Integer(97));
        glyphNameToWinAnsiCP.put("b", new Integer(98));
        glyphNameToWinAnsiCP.put("c", new Integer(99));
        glyphNameToWinAnsiCP.put("d", new Integer(100));
        glyphNameToWinAnsiCP.put("e", new Integer(101));
        glyphNameToWinAnsiCP.put("f", new Integer(102));
        glyphNameToWinAnsiCP.put("g", new Integer(103));
        glyphNameToWinAnsiCP.put("h", new Integer(104));
        glyphNameToWinAnsiCP.put("i", new Integer(105));
        glyphNameToWinAnsiCP.put("j", new Integer(106));
        glyphNameToWinAnsiCP.put("k", new Integer(107));
        glyphNameToWinAnsiCP.put("l", new Integer(108));
        glyphNameToWinAnsiCP.put("m", new Integer(109));
        glyphNameToWinAnsiCP.put("n", new Integer(110));
        glyphNameToWinAnsiCP.put("o", new Integer(111));
        glyphNameToWinAnsiCP.put("p", new Integer(112));
        glyphNameToWinAnsiCP.put("q", new Integer(113));
        glyphNameToWinAnsiCP.put("r", new Integer(114));
        glyphNameToWinAnsiCP.put("s", new Integer(115));
        glyphNameToWinAnsiCP.put("t", new Integer(116));
        glyphNameToWinAnsiCP.put("u", new Integer(117));
        glyphNameToWinAnsiCP.put("v", new Integer(118));
        glyphNameToWinAnsiCP.put("w", new Integer(119));
        glyphNameToWinAnsiCP.put("x", new Integer(120));
        glyphNameToWinAnsiCP.put("y", new Integer(121));
        glyphNameToWinAnsiCP.put("z", new Integer(122));
        glyphNameToWinAnsiCP.put("braceleft", new Integer(123));
        glyphNameToWinAnsiCP.put("bar", new Integer(124));
        glyphNameToWinAnsiCP.put("braceright", new Integer(125));
        glyphNameToWinAnsiCP.put("asciitilde", new Integer(126));
        glyphNameToWinAnsiCP.put("Euro", new Integer(128));
        glyphNameToWinAnsiCP.put("quotesinglbase", new Integer(130));
        glyphNameToWinAnsiCP.put("florin", new Integer(131));
        glyphNameToWinAnsiCP.put("quotedblbase", new Integer(132));
        glyphNameToWinAnsiCP.put("ellipsis", new Integer(133));
        glyphNameToWinAnsiCP.put("dagger", new Integer(134));
        glyphNameToWinAnsiCP.put("daggerdbl", new Integer(135));
        glyphNameToWinAnsiCP.put("circumflex", new Integer(136));
        glyphNameToWinAnsiCP.put("perthousand", new Integer(137));
        glyphNameToWinAnsiCP.put("Scaron", new Integer(138));
        glyphNameToWinAnsiCP.put("guilsinglleft", new Integer(139));
        glyphNameToWinAnsiCP.put("OE", new Integer(140));
        glyphNameToWinAnsiCP.put("Zcaron", new Integer(142));
        glyphNameToWinAnsiCP.put("quoteleft", new Integer(145));
        glyphNameToWinAnsiCP.put("quoteright", new Integer(146));
        glyphNameToWinAnsiCP.put("quotedblleft", new Integer(147));
        glyphNameToWinAnsiCP.put("quotedblright", new Integer(148));
        glyphNameToWinAnsiCP.put("bullet", new Integer(149));
        glyphNameToWinAnsiCP.put("endash", new Integer(150));
        glyphNameToWinAnsiCP.put("emdash", new Integer(151));
        glyphNameToWinAnsiCP.put("tilde", new Integer(152));
        glyphNameToWinAnsiCP.put("trademark", new Integer(153));
        glyphNameToWinAnsiCP.put("scaron", new Integer(154));
        glyphNameToWinAnsiCP.put("guilsinglright", new Integer(155));
        glyphNameToWinAnsiCP.put("oe", new Integer(156));
        glyphNameToWinAnsiCP.put("zcaron", new Integer(158));
        glyphNameToWinAnsiCP.put("Ydieresis", new Integer(159));
        glyphNameToWinAnsiCP.put("exclamdown", new Integer(161));
        glyphNameToWinAnsiCP.put("cent", new Integer(162));
        glyphNameToWinAnsiCP.put("sterling", new Integer(163));
        glyphNameToWinAnsiCP.put("currency", new Integer(164));
        glyphNameToWinAnsiCP.put("yen", new Integer(165));
        glyphNameToWinAnsiCP.put("brokenbar", new Integer(166));
        glyphNameToWinAnsiCP.put("section", new Integer(167));
        glyphNameToWinAnsiCP.put("dieresis", new Integer(168));
        glyphNameToWinAnsiCP.put("copyright", new Integer(169));
        glyphNameToWinAnsiCP.put("ordfeminine", new Integer(170));
        glyphNameToWinAnsiCP.put("guillemotleft", new Integer(171));
        glyphNameToWinAnsiCP.put("logicalnot", new Integer(172));
        glyphNameToWinAnsiCP.put("registered", new Integer(174));
        glyphNameToWinAnsiCP.put("macron", new Integer(175));
        glyphNameToWinAnsiCP.put("degree", new Integer(176));
        glyphNameToWinAnsiCP.put("plusminus", new Integer(177));
        glyphNameToWinAnsiCP.put("twosuperior", new Integer(178));
        glyphNameToWinAnsiCP.put("threesuperior", new Integer(179));
        glyphNameToWinAnsiCP.put("acute", new Integer(180));
        glyphNameToWinAnsiCP.put("mu", new Integer(181));
        glyphNameToWinAnsiCP.put("paragraph", new Integer(182));
        glyphNameToWinAnsiCP.put("periodcentered", new Integer(183));
        glyphNameToWinAnsiCP.put("cedilla", new Integer(184));
        glyphNameToWinAnsiCP.put("onesuperior", new Integer(185));
        glyphNameToWinAnsiCP.put("ordmasculine", new Integer(186));
        glyphNameToWinAnsiCP.put("guillemotright", new Integer(187));
        glyphNameToWinAnsiCP.put("onequarter", new Integer(188));
        glyphNameToWinAnsiCP.put("onehalf", new Integer(189));
        glyphNameToWinAnsiCP.put("threequarters", new Integer(190));
        glyphNameToWinAnsiCP.put("questiondown", new Integer(191));
        glyphNameToWinAnsiCP.put("Agrave", new Integer(192));
        glyphNameToWinAnsiCP.put("Aacute", new Integer(193));
        glyphNameToWinAnsiCP.put("Acircumflex", new Integer(194));
        glyphNameToWinAnsiCP.put("Atilde", new Integer(195));
        glyphNameToWinAnsiCP.put("Adieresis", new Integer(196));
        glyphNameToWinAnsiCP.put("Aring", new Integer(197));
        glyphNameToWinAnsiCP.put("AE", new Integer(198));
        glyphNameToWinAnsiCP.put("Ccedilla", new Integer(199));
        glyphNameToWinAnsiCP.put("Egrave", new Integer(200));
        glyphNameToWinAnsiCP.put("Eacute", new Integer(201));
        glyphNameToWinAnsiCP.put("Ecircumflex", new Integer(202));
        glyphNameToWinAnsiCP.put("Edieresis", new Integer(203));
        glyphNameToWinAnsiCP.put("Igrave", new Integer(204));
        glyphNameToWinAnsiCP.put("Iacute", new Integer(205));
        glyphNameToWinAnsiCP.put("Icircumflex", new Integer(206));
        glyphNameToWinAnsiCP.put("Idieresis", new Integer(207));
        glyphNameToWinAnsiCP.put("Eth", new Integer(208));
        glyphNameToWinAnsiCP.put("Ntilde", new Integer(209));
        glyphNameToWinAnsiCP.put("Ograve", new Integer(210));
        glyphNameToWinAnsiCP.put("Oacute", new Integer(211));
        glyphNameToWinAnsiCP.put("Ocircumflex", new Integer(212));
        glyphNameToWinAnsiCP.put("Otilde", new Integer(213));
        glyphNameToWinAnsiCP.put("Odieresis", new Integer(214));
        glyphNameToWinAnsiCP.put("multiply", new Integer(215));
        glyphNameToWinAnsiCP.put("Oslash", new Integer(216));
        glyphNameToWinAnsiCP.put("Ugrave", new Integer(217));
        glyphNameToWinAnsiCP.put("Uacute", new Integer(218));
        glyphNameToWinAnsiCP.put("Ucircumflex", new Integer(219));
        glyphNameToWinAnsiCP.put("Udieresis", new Integer(220));
        glyphNameToWinAnsiCP.put("Yacute", new Integer(221));
        glyphNameToWinAnsiCP.put("Thorn", new Integer(222));
        glyphNameToWinAnsiCP.put("germandbls", new Integer(223));
        glyphNameToWinAnsiCP.put("agrave", new Integer(224));
        glyphNameToWinAnsiCP.put("aacute", new Integer(225));
        glyphNameToWinAnsiCP.put("acircumflex", new Integer(226));
        glyphNameToWinAnsiCP.put("atilde", new Integer(227));
        glyphNameToWinAnsiCP.put("adieresis", new Integer(228));
        glyphNameToWinAnsiCP.put("aring", new Integer(229));
        glyphNameToWinAnsiCP.put("ae", new Integer(230));
        glyphNameToWinAnsiCP.put("ccedilla", new Integer(231));
        glyphNameToWinAnsiCP.put("egrave", new Integer(232));
        glyphNameToWinAnsiCP.put("eacute", new Integer(233));
        glyphNameToWinAnsiCP.put("ecircumflex", new Integer(234));
        glyphNameToWinAnsiCP.put("edieresis", new Integer(235));
        glyphNameToWinAnsiCP.put("igrave", new Integer(236));
        glyphNameToWinAnsiCP.put("iacute", new Integer(237));
        glyphNameToWinAnsiCP.put("icircumflex", new Integer(238));
        glyphNameToWinAnsiCP.put("idieresis", new Integer(239));
        glyphNameToWinAnsiCP.put("eth", new Integer(240));
        glyphNameToWinAnsiCP.put("ntilde", new Integer(241));
        glyphNameToWinAnsiCP.put("ograve", new Integer(242));
        glyphNameToWinAnsiCP.put("oacute", new Integer(243));
        glyphNameToWinAnsiCP.put("ocircumflex", new Integer(244));
        glyphNameToWinAnsiCP.put("otilde", new Integer(245));
        glyphNameToWinAnsiCP.put("odieresis", new Integer(246));
        glyphNameToWinAnsiCP.put("divide", new Integer(247));
        glyphNameToWinAnsiCP.put("oslash", new Integer(248));
        glyphNameToWinAnsiCP.put("ugrave", new Integer(249));
        glyphNameToWinAnsiCP.put("uacute", new Integer(250));
        glyphNameToWinAnsiCP.put("ucircumflex", new Integer(251));
        glyphNameToWinAnsiCP.put("udieresis", new Integer(252));
        glyphNameToWinAnsiCP.put("yacute", new Integer(253));
        glyphNameToWinAnsiCP.put("thorn", new Integer(254));
        glyphNameToWinAnsiCP.put("ydieresis", new Integer(255));
        this.psName = ps;
        this.winName = win;
        this.weight = wt;
        this.isItalic = isItalic;
        this.kernData = kernData != null ? new KernData(kernData) : null;
    }

    public double getKernValue(String leftGlyphName, String rightGlyphName) {
        if (this.kernData == null) {
            return 0.0;
        }
        Integer leftCP = (Integer)glyphNameToWinAnsiCP.get(leftGlyphName);
        if (leftCP == null) {
            return 0.0;
        }
        Integer rightCP = (Integer)glyphNameToWinAnsiCP.get(rightGlyphName);
        if (rightCP == null) {
            return 0.0;
        }
        return this.kernData.getKernValue(leftCP, rightCP);
    }

    public String getFamilyName() {
        return this.winName;
    }

    public String getFontName() {
        return this.psName;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public static PFM createPFM(FontInputStream str, URL url) throws IOException, InvalidFontException {
        byte[] kernBytes;
        String psName;
        String faceName;
        boolean isItalic;
        byte[] bytesFromFile = new byte[4];
        if (str.skipTo(80L) != 80L) {
            return null;
        }
        if (str.read(bytesFromFile, 0, 1) != 1) {
            return null;
        }
        boolean bl = isItalic = (bytesFromFile[0] & 1) != 0;
        if (str.skipTo(83L) != 2L) {
            return null;
        }
        if (str.read(bytesFromFile, 0, 2) != 2) {
            return null;
        }
        int weight = (bytesFromFile[1] & 0xFF) << 8;
        weight += bytesFromFile[0] & 0xFF;
        if (str.skipTo(101L) != 16L) {
            return null;
        }
        if (str.read(bytesFromFile) < 4) {
            return null;
        }
        long offset = bytesFromFile[3] & 0xFF;
        offset <<= 8;
        offset += (long)(bytesFromFile[2] & 0xFF);
        offset <<= 8;
        offset += (long)(bytesFromFile[1] & 0xFF);
        offset <<= 8;
        offset += (long)(bytesFromFile[0] & 0xFF);
        if (str.skipTo(131L) != 26L) {
            return null;
        }
        if (str.read(bytesFromFile) < 4) {
            return null;
        }
        int kernOffset = bytesFromFile[3] & 0xFF;
        kernOffset <<= 8;
        kernOffset += bytesFromFile[2] & 0xFF;
        kernOffset <<= 8;
        kernOffset += bytesFromFile[1] & 0xFF;
        kernOffset <<= 8;
        if (offset < (long)(kernOffset += bytesFromFile[0] & 0xFF)) {
            faceName = PFM.readFaceName(str, offset);
            if (faceName == null) {
                return null;
            }
            psName = PFM.readPSName(str);
            if (psName == null) {
                return null;
            }
            kernBytes = PFM.readKerning(str, kernOffset);
        } else {
            kernBytes = PFM.readKerning(str, kernOffset);
            faceName = PFM.readFaceName(str, offset);
            if (faceName == null) {
                return null;
            }
            psName = PFM.readPSName(str);
            if (psName == null) {
                return null;
            }
        }
        return new PFM(psName, faceName, weight, url, isItalic, kernBytes);
    }

    private static String readFaceName(FontInputStream str, long offset) throws InvalidFontException, IOException {
        str.skipTo(offset);
        byte[] token = new byte[psTag.length];
        if (str.read(token) != psTag.length) {
            return null;
        }
        if (SubArrays.arrayCompare(token, 0, psTag, 0, psTag.length)) {
            int readByte;
            byte[] buff = new byte[65];
            int buffLen = 0;
            str.read();
            while ((readByte = str.read()) != -1 && readByte != 0) {
                buff[buffLen++] = (byte)readByte;
            }
            if (buffLen == 0) {
                return null;
            }
            return new String(buff, 0, buffLen);
        }
        return null;
    }

    private static String readPSName(FontInputStream str) throws InvalidFontException, IOException {
        int readByte;
        int buffLen = 0;
        byte[] buff = new byte[65];
        while ((readByte = str.read()) != -1 && readByte != 0) {
            buff[buffLen++] = (byte)readByte;
        }
        if (buffLen == 0) {
            return null;
        }
        return new String(buff, 0, buffLen);
    }

    private static byte[] readKerning(FontInputStream str, long kernOffset) throws InvalidFontException, IOException {
        byte[] kernBytes;
        if (kernOffset == 0L) {
            return null;
        }
        str.skipTo(kernOffset);
        int numPairs = str.read() & 0xFF;
        if ((numPairs += (str.read() & 0xFF) << 8) > 0) {
            kernBytes = new byte[numPairs * 4];
            if (str.read(kernBytes) == -1) {
                kernBytes = null;
            }
        } else {
            return null;
        }
        return kernBytes;
    }

    private static class KernData {
        private final byte[] kernData;

        KernData(byte[] kernData) {
            this.kernData = kernData;
        }

        private int getNthLeftCodePoint(int n) {
            return this.kernData[n * 4] & 0xFF;
        }

        private int getNthRightCodePoint(int n) {
            return this.kernData[n * 4 + 1] & 0xFF;
        }

        private int getNthKernValue(int n) {
            return this.kernData[n * 4 + 3] << 8 | this.kernData[n * 4 + 2];
        }

        private int getNumKernPairs() {
            return this.kernData.length / 4;
        }

        int getKernValue(int leftCodePoint, int rightCodePoint) {
            int bottom = 0;
            int top = this.getNumKernPairs() - 1;
            while (bottom <= top) {
                int middle = bottom + top >> 1;
                int rcp = this.getNthRightCodePoint(middle);
                if (rightCodePoint < rcp) {
                    top = middle - 1;
                    continue;
                }
                if (rightCodePoint > rcp) {
                    bottom = middle + 1;
                    continue;
                }
                int lcp = this.getNthLeftCodePoint(middle);
                if (leftCodePoint < lcp) {
                    top = middle - 1;
                    continue;
                }
                if (leftCodePoint > lcp) {
                    bottom = middle + 1;
                    continue;
                }
                return this.getNthKernValue(middle);
            }
            return 0;
        }
    }
}

