/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;

public final class OTSubset
extends SubsetDefaultImpl {
    final OpenTypeFont font;
    final boolean targettingCFF;

    public OTSubset(OpenTypeFont font, boolean targettingCFF) throws UnsupportedFontException, InvalidFontException {
        super(font.getNumGlyphs(), true);
        this.font = font;
        this.targettingCFF = targettingCFF;
        if (!targettingCFF) {
            this.getSubsetGid(0);
            this.getSubsetGid(1);
            this.getSubsetGid(2);
            this.getSubsetGid(3);
        } else {
            this.getSubsetGid(0);
        }
    }

    protected void pullComponentGlyphs(int fullGid) throws UnsupportedFontException, InvalidFontException {
        if (this.font.glyf != null && !this.targettingCFF) {
            this.font.glyf.pullComponentGlyphs(this, fullGid);
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            buff.append(this.getFullGid(i) + " -> " + i + "; ");
        }
        return buff.toString();
    }
}

