/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.io.UnsupportedEncodingException;

class OTFSWFFont3Description
implements SWFFontDescription {
    private final OpenTypeFont theFont;
    private final boolean wasEmbedded;

    OTFSWFFont3Description(OpenTypeFont font, boolean wasEmbedded) throws InvalidFontException, UnsupportedFontException {
        this.wasEmbedded = wasEmbedded;
        this.theFont = font;
    }

    public boolean canDisplay(char c) throws UnsupportedFontException, InvalidFontException {
        try {
            return this.theFont.cmap.unicodeChar2glyph(c) != 0;
        }
        catch (NullPointerException e) {
            throw new InvalidFontException("Missing required table", e);
        }
    }

    public double getAscent() throws InvalidFontException {
        if (this.theFont.os2 != null) {
            return this.theFont.os2.getWinAscent();
        }
        if (this.theFont.hhea != null) {
            return this.theFont.hhea.getAscender();
        }
        return 0.0;
    }

    public double getDescent() throws InvalidFontException {
        if (this.theFont.os2 != null) {
            return this.theFont.os2.getWinDescent();
        }
        if (this.theFont.hhea != null) {
            return -this.theFont.hhea.getDescender();
        }
        return 0.0;
    }

    public double getLineGap() throws InvalidFontException {
        if (this.theFont.os2 != null) {
            return this.theFont.os2.getTypoLineGap();
        }
        if (this.theFont.hhea != null) {
            return this.theFont.hhea.getLineGap();
        }
        return 0.0;
    }

    public double getEmScale() throws InvalidFontException {
        if (this.theFont.head != null) {
            return this.theFont.head.getUnitsPerEm();
        }
        throw new InvalidFontException("Cannot determine em");
    }

    public String getFamily() throws InvalidFontException, UnsupportedFontException {
        return this.theFont.name.getFirstName(1);
    }

    public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        if (this.theFont.os2 != null) {
            int first = this.theFont.os2.getFirstChar();
            try {
                first = this.theFont.cmap.removeSymbolModifier(first);
            }
            catch (NullPointerException e) {
                throw new InvalidFontException("Missing required table", e);
            }
            return first;
        }
        return 0;
    }

    public int getLastChar() throws InvalidFontException, UnsupportedFontException {
        try {
            if (this.theFont.cmap.symbolSubtableOffset != -1) {
                return this.theFont.cmap.getHighestMappedCode(this.theFont.cmap.symbolSubtableOffset, true);
            }
            if (this.theFont.cmap.unicodeSubtableOffset != -1) {
                return this.theFont.cmap.getHighestMappedCode(this.theFont.cmap.unicodeSubtableOffset, true);
            }
        }
        catch (NullPointerException e) {
            throw new InvalidFontException("Missing required table", e);
        }
        return 65535;
    }

    public double getHorizontalAdvance(char c) throws InvalidFontException, UnsupportedFontException {
        try {
            return this.theFont.hmtx.getHorizontalAdvance(this.theFont.cmap.unicodeChar2glyph(c));
        }
        catch (NullPointerException e) {
            throw new InvalidFontException("Missing required table", e);
        }
    }

    public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
        return this.theFont.getNumGlyphs();
    }

    public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
        if (this.theFont.name == null) {
            return null;
        }
        return this.theFont.name.getFirstName(6);
    }

    public String getCopyright() throws InvalidFontException, UnsupportedFontException {
        if (this.theFont.name == null) {
            return null;
        }
        return this.theFont.name.getFirstName(0);
    }

    public String getTrademark() throws InvalidFontException, UnsupportedFontException {
        if (this.theFont.name == null) {
            return null;
        }
        return this.theFont.name.getFirstName(7);
    }

    public String getFullName() throws InvalidFontException, UnsupportedFontException {
        if (this.theFont.name == null) {
            return null;
        }
        try {
            return this.theFont.name.getName(1, 0, 0, 4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public boolean isBold() throws InvalidFontException, UnsupportedFontException {
        return this.theFont.os2 != null && (this.theFont.os2.getSelection() & 0x20) != 0;
    }

    public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
        return this.theFont.os2 != null && (this.theFont.os2.getSelection() & 1) != 0;
    }

    public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
        Permission perm = this.theFont.getEmbeddingPermission(this.wasEmbedded);
        if (perm == Permission.ILLEGAL_VALUE) {
            return Permission.EDITABLE;
        }
        return perm;
    }

    public void getOutline(char ccode, OutlineConsumer consumer) throws UnsupportedFontException, InvalidFontException {
        try {
            this.theFont.getGlyphOutline(this.theFont.cmap.unicodeChar2glyph(ccode), consumer);
        }
        catch (NullPointerException e) {
            throw new InvalidFontException("Missing required table", e);
        }
    }

    public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
        if (this.theFont.name == null) {
            return null;
        }
        return this.theFont.name.getFirstName(2);
    }
}

