/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.Arrays;

class GdefSubsetter
extends LayoutTableSubsetter
implements LayoutTable.CoverageConsumer {
    private Subset subset;
    private int numLigGlyphs;
    private int origLCLOffset;
    private int[] keepLigGlyph;

    GdefSubsetter(Gdef origTable) {
        super(origTable, OTByteArray.getOTByteArrayBuilderInstance(12));
    }

    OTByteArray.OTByteArrayBuilder subsetAndStream(Subset subset, int origNumGlyphs) throws InvalidFontException, UnsupportedFontException {
        int tableSize = 12;
        this.builder.setuint32(0, 65536);
        int origOffset = this.origTable.data.getOffset(0, 4);
        if (origOffset == 0) {
            this.builder.setuint16(4, 0);
        } else {
            this.builder.setuint16(4, tableSize);
            tableSize += this.writeClassDef(origOffset, tableSize, subset, origNumGlyphs);
        }
        this.builder.setuint16(6, 0);
        origOffset = this.origTable.data.getOffset(0, 8);
        if (origOffset == 0) {
            this.builder.setuint16(8, 0);
        } else {
            this.builder.setuint16(8, tableSize);
            tableSize += this.writeLigCaretList(origOffset, tableSize, subset);
        }
        origOffset = this.origTable.data.getOffset(0, 10);
        if (origOffset <= 10) {
            this.builder.setuint16(10, 0);
        } else {
            this.builder.setuint16(10, tableSize);
            this.writeClassDef(origOffset, tableSize, subset, origNumGlyphs);
        }
        return this.builder;
    }

    public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
        if (this.subset.getExistingSubsetGid(gid) != -1) {
            int origLigGlyphOffset = this.origTable.data.getOffset(this.origLCLOffset, 4 + 2 * coverageIndex);
            int caretCount = this.origTable.data.getuint16(origLigGlyphOffset);
            for (int i = 0; i < caretCount; ++i) {
                int caretValueOffset = this.origTable.data.getOffset(origLigGlyphOffset, 2 + 2 * i);
                int format = this.origTable.data.getuint16(caretValueOffset);
                if (format != 2) continue;
                return true;
            }
            this.keepLigGlyph[this.subset.getExistingSubsetGid((int)gid)] = coverageIndex;
            ++this.numLigGlyphs;
        }
        return true;
    }

    int writeLigCaretList(int origLCLOffset, int newLCLOffset, Subset subset) throws InvalidFontException, UnsupportedFontException {
        this.numLigGlyphs = 0;
        this.subset = subset;
        this.origLCLOffset = origLCLOffset;
        this.keepLigGlyph = new int[subset.getNumGlyphs()];
        Arrays.fill(this.keepLigGlyph, -1);
        int origCoverageOffset = this.origTable.data.getOffset(origLCLOffset, 0);
        this.origTable.iterateCoverage(origCoverageOffset, null, this);
        int lCLSize = 4 + 2 * this.numLigGlyphs;
        this.builder.ensureCapacity(newLCLOffset + lCLSize);
        this.builder.setuint16(newLCLOffset, lCLSize);
        lCLSize += this.writeCoverage(this.origTable.data.getOffset(origLCLOffset, 0), newLCLOffset + lCLSize);
        this.builder.setuint16(newLCLOffset + 2, this.numLigGlyphs);
        int j = 0;
        for (int i = 0; i < this.keepLigGlyph.length; ++i) {
            if (this.keepLigGlyph[i] == -1) continue;
            int origCoverageIndex = this.keepLigGlyph[i];
            this.builder.setuint16(newLCLOffset + 4 + 2 * j, lCLSize);
            lCLSize += this.writeLigGlyph(this.origTable.data.getOffset(origLCLOffset, 4 + 2 * origCoverageIndex), newLCLOffset + lCLSize);
            ++j;
        }
        return lCLSize;
    }

    int writeCoverage(int origCoverageOffset, int newCoverageOffset) throws InvalidFontException, UnsupportedFontException {
        LayoutTableSubsetter.CoverageGenerator generator = LayoutTableSubsetter.CoverageGenerator.newInstance(this.origTable, origCoverageOffset, this.subset);
        OTByteArray newCoverage = generator.generateCoverage().toOTByteArray();
        return this.writeByteArrayAtOffset(newCoverageOffset, newCoverage);
    }

    int writeLigGlyph(int origLGOffset, int newLGOffset) throws InvalidFontException {
        int caretCount = this.origTable.data.getuint16(origLGOffset);
        int lgSize = 2 + 2 * caretCount;
        this.builder.ensureCapacity(newLGOffset + lgSize);
        this.builder.setuint16(newLGOffset, caretCount);
        for (int i = 0; i < caretCount; ++i) {
            this.builder.setuint16(newLGOffset + 2 + 2 * i, lgSize);
            lgSize += this.writeCaretValue(this.origTable.data.getOffset(origLGOffset, 2 + 2 * i), newLGOffset + lgSize);
        }
        return lgSize;
    }

    int writeCaretValue(int origCaretOffset, int newCaretOffset) throws InvalidFontException {
        this.builder.ensureCapacity(newCaretOffset + 4);
        this.builder.setuint16(newCaretOffset, 1);
        this.builder.setint16(newCaretOffset + 2, this.origTable.data.getint16(origCaretOffset + 2));
        return 4;
    }

    int writeClassDef(int origClassDefOffset, int newClassDefOffset, Subset subset, int numGlyphs) throws InvalidFontException, UnsupportedFontException {
        LayoutTableSubsetter.ClassDefGenerator generator = LayoutTableSubsetter.ClassDefGenerator.newInstance(this.origTable, origClassDefOffset, subset, numGlyphs);
        OTByteArray array = generator.generateClass().toOTByteArray();
        return this.writeByteArrayAtOffset(newClassDefOffset, array);
    }
}

