/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FontFactory {
    public static OpenTypeFont[] load(FontInputStream in) throws IOException, InvalidFontException, UnsupportedFontException {
        return FontFactory.load(in, null, null);
    }

    public static OpenTypeFont[] load(FontInputStream in, String base14CSSName, String base14PSName) throws IOException, InvalidFontException, UnsupportedFontException {
        FontByteArray array = new FontByteArray(in, 12);
        OTByteArray header = new OTByteArray(array);
        BlockToLoad thingsToLoad = header.getint32(0) == Tag.misc_ttcf ? new TTCToLoad(header) : new FontToLoad(0L, header);
        thingsToLoad.load(in, thingsToLoad);
        byte[] digest = in.getDigest();
        ArrayList v = new ArrayList();
        thingsToLoad.buildFonts(v, digest, base14CSSName, base14PSName);
        OpenTypeFont[] res = new OpenTypeFont[v.size()];
        v.toArray(res);
        return res;
    }

    public static int getNumBytesNeededToIdentify() {
        return 4;
    }

    public static boolean isOpenType(byte[] startingBytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = result << 8 | startingBytes[i];
        }
        return result == Tag.misc_ttcf || result == Tag.misc_1_0 || result == Tag.misc_OTTO || result == Tag.misc_true;
    }

    private static class TableToLoad
    extends BlockToLoad {
        public int length;
        public Table table;
        public int tag;

        public TableToLoad(long offset, int length, int tag) {
            super(offset, length);
            this.length = length;
            this.tag = tag;
        }

        public OTByteArray getByteArray() {
            return this.table.data;
        }

        public void load(FontInputStream in, BlockToLoad firstTable) throws IOException, InvalidFontException, UnsupportedFontException {
            FontByteArray theArray = null;
            if (in.getCurrentOffset() <= this.offset) {
                in.skipTo(this.offset);
                theArray = new FontByteArray(in, this.length);
            } else {
                BlockToLoad blockToCopy = firstTable;
                OTByteArray.OTByteArrayBuilder builder = OTByteArray.getOTByteArrayBuilderInstance(this.length);
                int previousBufferCount = (int)(in.getCurrentOffset() - this.offset);
                if (this.length < previousBufferCount) {
                    previousBufferCount = this.length;
                }
                int offsetCopied = 0;
                while (blockToCopy.offset + (long)blockToCopy.length < this.offset) {
                    if (blockToCopy.next == this) {
                        if (Table.knownTable(this.tag)) {
                            throw new InvalidFontException("Cannot find overlapped data");
                        }
                        blockToCopy = null;
                        break;
                    }
                    blockToCopy = blockToCopy.next;
                }
                if (blockToCopy != null) {
                    while (offsetCopied < previousBufferCount && blockToCopy != null && blockToCopy.offset <= (long)offsetCopied + this.offset) {
                        OTByteArray copyFrom = blockToCopy.getByteArray();
                        if (copyFrom == null) {
                            throw new InvalidFontException("Overlapping data cannot be accessed.");
                        }
                        int start = (int)((long)offsetCopied + this.offset - blockToCopy.offset);
                        int fromLength = Math.min(previousBufferCount, blockToCopy.length - start);
                        builder.replace(offsetCopied, copyFrom, start, fromLength);
                        blockToCopy = blockToCopy.next;
                        offsetCopied += fromLength;
                    }
                    if (offsetCopied < previousBufferCount) {
                        if (Table.knownTable(this.tag)) {
                            throw new InvalidFontException("Data could not be copied");
                        }
                    } else {
                        if (this.length > offsetCopied) {
                            builder.append(in, this.length - offsetCopied, offsetCopied);
                        }
                        theArray = builder.toOTByteArray();
                    }
                }
            }
            if (theArray != null) {
                this.table = Table.factory(this.tag, theArray);
            }
            if (this.next != null) {
                this.next.load(in, firstTable);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof TableToLoad)) {
                return false;
            }
            TableToLoad ot = (TableToLoad)o;
            return this.length == ot.length && this.tag == ot.tag && this.offset == ot.offset;
        }

        public String toString() {
            return "" + this.length + "/" + this.tag + "/" + this.offset;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static class FontToLoad
    extends BlockToLoad {
        ArrayList myTablesToLoad = new ArrayList();
        OTByteArray fontHeader;
        private static final int headerLength = 12;

        public FontToLoad(long offset) {
            super(offset, 12);
        }

        public FontToLoad(long offset, OTByteArray header) {
            super(offset, header.getSize());
            this.fontHeader = header;
        }

        public OTByteArray getByteArray() {
            return this.fontHeader;
        }

        public void load(FontInputStream in, BlockToLoad firstBlock) throws IOException, InvalidFontException, UnsupportedFontException {
            if (this.fontHeader == null) {
                in.skipTo(this.offset);
                FontByteArray array = new FontByteArray(in, 12);
                this.fontHeader = new OTByteArray(array);
            } else {
                in.skipTo(this.offset + 12L);
            }
            int sfntVersion = this.fontHeader.getint32(0);
            if (Tag.misc_OTTO != sfntVersion && Tag.misc_1_0 != sfntVersion && Tag.misc_true != sfntVersion) {
                throw new InvalidFontException("FontData header does not have correct version (is: 0x" + Integer.toHexString(sfntVersion) + ")");
            }
            int numTables = this.fontHeader.getuint16(4);
            FontByteArray array = new FontByteArray(in, 16 * numTables);
            OTByteArray tableOffsets = new OTByteArray(array);
            for (int i = 0; i < numTables; ++i) {
                long start = tableOffsets.getuint32(16 * i + 8);
                int size = tableOffsets.getuint32asint(16 * i + 12, "OT tables larger than 2^31 bytes not supported");
                int tag = tableOffsets.getint32(i * 16);
                if (!Table.knownTable(tag) || size == 0 || !in.isValidOffset(start, size)) continue;
                TableToLoad ttl = new TableToLoad(start, size, tag);
                ttl = (TableToLoad)this.add(ttl);
                this.myTablesToLoad.add(ttl);
            }
            if (this.next != null) {
                this.next.load(in, firstBlock);
            }
        }

        public void buildFonts(List v, byte[] digest, String base14CSSName, String base14PSName) throws InvalidFontException, UnsupportedFontException {
            HashMap<Integer, Table> myTables = new HashMap<Integer, Table>();
            for (TableToLoad ttl : this.myTablesToLoad) {
                myTables.put(new Integer(ttl.tag), ttl.table);
            }
            OpenTypeFont f = new OpenTypeFont(myTables, digest, base14CSSName, base14PSName);
            v.add(f);
            if (this.next != null) {
                this.next.buildFonts(v, digest, base14CSSName, base14PSName);
            }
        }
    }

    private static class TTCToLoad
    extends BlockToLoad {
        private OTByteArray ttcHeader;

        public TTCToLoad(OTByteArray header) {
            super(0L, 0);
            this.ttcHeader = header;
        }

        public OTByteArray getByteArray() {
            return null;
        }

        public void load(FontInputStream in, BlockToLoad firstBlock) throws IOException, InvalidFontException, UnsupportedFontException {
            if (this.ttcHeader == null) {
                in.skipTo(this.offset);
                FontByteArray array = new FontByteArray(in, 12);
                this.ttcHeader = new OTByteArray(array);
            } else {
                in.skipTo(this.offset + 12L);
            }
            if ((long)Tag.misc_ttcf != this.ttcHeader.getuint32(0)) {
                throw new InvalidFontException("TTC header does not start with 'ttcf'");
            }
            int majorVersion = this.ttcHeader.getuint16(4);
            if (majorVersion != 1 && majorVersion != 2) {
                throw new UnsupportedFontException("TTC major version " + majorVersion + " is not supported");
            }
            int numFonts = this.ttcHeader.getuint32asint(8, "TTC fonts with 2^31 fonts or more not supported");
            FontByteArray array = new FontByteArray(in, 4 * numFonts);
            OTByteArray fontOffsets = new OTByteArray(array);
            for (int i = 0; i < numFonts; ++i) {
                this.add(new FontToLoad(fontOffsets.getuint32(4 * i)));
            }
            if (this.next != null) {
                this.next.load(in, this.next);
            }
        }
    }

    private static abstract class BlockToLoad {
        public BlockToLoad next;
        public long offset;
        public int length;

        public BlockToLoad(long offset, int length) {
            this.offset = offset;
            this.length = length;
            this.next = null;
        }

        public abstract void load(FontInputStream var1, BlockToLoad var2) throws IOException, InvalidFontException, UnsupportedFontException;

        protected abstract OTByteArray getByteArray();

        public BlockToLoad add(BlockToLoad b) throws InvalidFontException {
            if (this.next == null) {
                this.next = b;
                return b;
            }
            if (b.offset < this.next.offset || b.offset == this.next.offset && b.length < this.next.length) {
                b.next = this.next;
                this.next = b;
                return b;
            }
            if (!b.equals(this.next)) {
                return this.next.add(b);
            }
            return this.next;
        }

        public void buildFonts(List v, byte[] digest, String base14CSSName, String base14PSName) throws UnsupportedFontException, InvalidFontException {
            if (this.next != null) {
                this.next.buildFonts(v, digest, base14CSSName, base14PSName);
            }
        }
    }
}

