/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.OutlineConsumerAdapter;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFFont;

public class CFFScaler
implements Scaler {
    protected final CFFFont font;
    protected final ScanConverter scanConverter;
    protected Matrix emToPixel;
    protected ScalerDebugger debugger;

    public CFFScaler(CFFFont font, ScanConverter scanConverter) {
        this.font = font;
        this.scanConverter = scanConverter;
    }

    public void setScale(double pointSize, double ppemX, double ppemY, double dX, double dY) throws InvalidFontException, UnsupportedFontException {
        this.emToPixel = new Matrix(ppemX, 0.0, 0.0, ppemY, dX, dY);
    }

    public void getOutline(int gid, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
        this.font.getGlyphOutline(gid, outlineConsumer);
    }

    public void getBitmap(int gid, BitmapConsumer bitmapConsumer) throws UnsupportedFontException, InvalidFontException {
        OutlineConsumer2 consumer = this.scanConverter.getOutlineConsumer2();
        consumer.startOutline();
        OutlineConsumerAdapter adapter = new OutlineConsumerAdapter(consumer);
        adapter.setEmToPixelMatrix(this.emToPixel);
        adapter.startOutline();
        this.font.getGlyphOutline(gid, adapter);
        adapter.endOutline();
        this.scanConverter.getBitmap(bitmapConsumer);
    }

    public void setDebugger(ScalerDebugger debugger) {
        this.debugger = debugger;
        this.scanConverter.setDebugger(debugger);
    }
}

