/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class StemFinder
implements OutlineConsumer {
    private final boolean findVerticalStem;
    private final boolean hintsForFauxing;
    private List leftEdges = new LinkedList();
    private List rightEdges = new LinkedList();
    private List removedEdges = new ArrayList();
    private double currentX;
    private double currentY;
    private Matrix currentMatrix;
    private Matrix lastMatrixSet;
    private static final Matrix thousand = new Matrix(1000.0, 0.0, 0.0, 1000.0, 0.0, 0.0);

    public StemFinder(boolean findVerticalStem, boolean hintsForFauxing) {
        this.findVerticalStem = findVerticalStem;
        this.hintsForFauxing = hintsForFauxing;
    }

    private void addEdge(double ss, double os, double se, double oe, boolean positiveAngle, List edgeList) {
        edgeList.add(new Edge(ss, os, se, oe, positiveAngle));
    }

    public void reset() {
        this.leftEdges.clear();
        this.rightEdges.clear();
        this.removedEdges.clear();
    }

    public void setMatrix(Matrix newMatrix) {
        this.lastMatrixSet = newMatrix.multiply(thousand);
    }

    public void moveto(double x, double y) {
        this.currentX = x;
        this.currentY = y;
        this.currentMatrix = this.lastMatrixSet;
    }

    public void lineto(double x, double y) {
        this.addLine(this.currentX, this.currentY, x, y);
        this.currentX = x;
        this.currentY = y;
        this.currentMatrix = this.lastMatrixSet;
    }

    private void addLine(double x1, double y1, double x2, double y2) {
        x1 = this.currentMatrix.applyToXYGetX(x1, y1);
        y1 = this.currentMatrix.applyToXYGetY(x1, y1);
        x2 = this.lastMatrixSet.applyToXYGetX(x2, y2);
        y2 = this.lastMatrixSet.applyToXYGetY(x2, y2);
        if (this.findVerticalStem && y1 == y2 || !this.findVerticalStem && x1 == x2) {
            return;
        }
        if (this.findVerticalStem) {
            if (y1 < y2) {
                if (x1 < x2) {
                    this.addEdge(x1, y1, x2, y2, false, this.rightEdges);
                } else {
                    this.addEdge(x2, y1, x1, y2, true, this.rightEdges);
                }
            } else if (x1 < x2) {
                this.addEdge(x1, y2, x2, y1, true, this.leftEdges);
            } else {
                this.addEdge(x2, y2, x1, y1, false, this.leftEdges);
            }
        } else if (x1 < x2) {
            if (y1 < y2) {
                this.addEdge(y1, x1, y2, x2, false, this.rightEdges);
            } else {
                this.addEdge(y2, x1, y1, x2, true, this.leftEdges);
            }
        } else if (y1 < y2) {
            this.addEdge(y1, x2, y2, x1, true, this.rightEdges);
        } else {
            this.addEdge(y2, x2, y1, x1, false, this.leftEdges);
        }
    }

    public void curveto(double x1, double y1, double x2, double y2) {
        this.curveto(Math.round((this.currentX + 2.0 * x1) / 3.0), Math.round((this.currentY + 2.0 * y1) / 3.0), Math.round((2.0 * x1 + x2) / 3.0), Math.round((2.0 * y1 + y2) / 3.0), x2, y2);
    }

    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        this.addLine(this.currentX, this.currentY, x2, y2);
        this.addLine(x2, y2, x3, y3);
        this.addLine(x3, y3, x4, y4);
        this.currentX = x4;
        this.currentY = y4;
        this.currentMatrix = this.lastMatrixSet;
    }

    private void mergeLines(List edges) {
        for (int index = 0; index < edges.size(); ++index) {
            Edge e1 = (Edge)edges.get(index);
            ListIterator iter = edges.listIterator();
            while (iter.hasNext()) {
                int nextIndex = iter.nextIndex();
                Edge e2 = (Edge)iter.next();
                if (e1 == e2 || !e1.continuation(e2)) continue;
                if (nextIndex < index) {
                    --index;
                }
                iter.remove();
            }
        }
    }

    private void mergeLines() {
        this.mergeLines(this.leftEdges);
        this.mergeLines(this.rightEdges);
    }

    private void removeInnerCounters() {
    }

    private void removeAngledLines(List edges, double italicAngle, boolean addToRejectedList) {
        ListIterator iter = edges.listIterator();
        double allowedTan = this.findVerticalStem ? Math.tan(Math.toRadians(italicAngle)) : 0.15;
        while (iter.hasNext()) {
            boolean rightDirection;
            double actualTan;
            Edge e = (Edge)iter.next();
            if (this.findVerticalStem) {
                actualTan = -(e.endStemDir - e.startStemDir) / (e.endOppositeDir - e.startOppositeDir);
                rightDirection = italicAngle == 0.0 ? true : (italicAngle > 0.0 ? e.positiveAngle : !e.positiveAngle);
            } else {
                actualTan = (e.endOppositeDir - e.startOppositeDir) / (e.endStemDir - e.startStemDir);
                rightDirection = true;
            }
            if (rightDirection && !(actualTan < allowedTan - 0.22) && !(actualTan > allowedTan + 0.22)) continue;
            if (addToRejectedList) {
                this.removedEdges.add(e);
            }
            iter.remove();
        }
    }

    private void removeIrrelevantLines(double italicAngle) {
        this.removeAngledLines(this.leftEdges, italicAngle, false);
        this.removeAngledLines(this.rightEdges, italicAngle, true);
        if (this.hintsForFauxing) {
            this.removeInnerCounters();
        }
    }

    private boolean partiallyContained(Edge e, Edge left, Edge right, double top, double bottom) {
        double y2;
        double x2;
        double y1;
        double x1;
        boolean firstOnEdge = false;
        if (this.findVerticalStem) {
            x1 = e.startStemDir;
            y1 = e.positiveAngle ? e.endOppositeDir : e.startOppositeDir;
            x2 = e.endStemDir;
            y2 = e.positiveAngle ? e.startOppositeDir : e.endOppositeDir;
        } else {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        }
        double x = x1;
        double y = y1;
        for (int i = 0; i < 2; ++i) {
            if (!(y > top) && !(y < bottom)) {
                double leftX = left.getStemPosGivenOppPos(y);
                double rightX = right.getStemPosGivenOppPos(y);
                if (!(leftX > x) && !(rightX < x)) {
                    if (!(leftX != x && rightX != x && top != y && bottom != y || firstOnEdge)) {
                        firstOnEdge = true;
                    } else {
                        return true;
                    }
                }
            }
            x = x2;
            y = y2;
        }
        return false;
    }

    private boolean crossesHorizontalLine(Edge e, Edge left, Edge right, double y) {
        if (e.endOppositeDir < y || e.startOppositeDir > y) {
            return false;
        }
        double x = e.getStemPosGivenOppPos(y);
        return !(left.getStemPosGivenOppPos(y) >= x) && !(right.getStemPosGivenOppPos(y) <= x);
    }

    private boolean crossesEdge(Edge e, Edge cross, double top, double bottom, boolean isLeft) {
        if (e.m == cross.m) {
            return false;
        }
        double y = (e.c - cross.c) / (e.m - cross.m);
        if (y < bottom || y > top || y < bottom || y > top) {
            return false;
        }
        if (y == bottom || y == top) {
            return isLeft ? e.m > cross.m : e.m < cross.m;
        }
        return true;
    }

    private boolean intermediateRemovedEdge(Edge left, Edge right, double top, double bottom) {
        for (Edge e : this.removedEdges) {
            if (!(e.endOppositeDir > bottom) || !(e.startOppositeDir < top) || !(e.startStemDir < right.endStemDir) || !(e.endStemDir > left.startStemDir) || !this.partiallyContained(e, left, right, top, bottom) && !this.crossesHorizontalLine(e, left, right, top) && !this.crossesHorizontalLine(e, left, right, bottom) && !this.crossesEdge(e, left, top, bottom, true) && !this.crossesEdge(e, right, top, bottom, false)) continue;
            return true;
        }
        return false;
    }

    private double averageWidth(double advanceWidth, double italicAngle, boolean filterValues) {
        double average = 0.0;
        int numEntries = 0;
        Iterator leftIter = this.leftEdges.iterator();
        double percentOfWidth = 0.8 * advanceWidth;
        while (leftIter.hasNext()) {
            Edge left = (Edge)leftIter.next();
            ArrayList<Point> extentList = new ArrayList<Point>();
            extentList.add(new Point(left.startOppositeDir, left.endOppositeDir));
            ListIterator<Point> extentIter = extentList.listIterator();
            block1: while (extentIter.hasNext()) {
                Iterator rightIter = this.rightEdges.iterator();
                Point p = (Point)extentIter.next();
                while (rightIter.hasNext()) {
                    double bottom;
                    Edge right = (Edge)rightIter.next();
                    if (right.endStemDir < left.endStemDir || !(right.endOppositeDir > p.x) || !(right.startOppositeDir < p.y)) continue;
                    double top = Math.min(p.y, right.endOppositeDir);
                    if (!(this.intermediateRemovedEdge(left, right, top, bottom = Math.max(p.x, right.startOppositeDir)) || filterValues && Edge.isShortOverlap(top, bottom))) {
                        double ave;
                        double thisWidth = right.getStemPosGivenOppPos(top) - left.getStemPosGivenOppPos(top);
                        boolean skip = false;
                        boolean reset = false;
                        if (top - bottom < 130.0) {
                            skip = true;
                        } else if (numEntries > 0) {
                            ave = average / (double)numEntries;
                            if (ave - thisWidth > 60.0) {
                                skip = true;
                            } else if (thisWidth - ave > 60.0 && top - bottom > 100.0) {
                                reset = true;
                            }
                        }
                        if (thisWidth > 0.0 && (!filterValues || !skip && thisWidth < percentOfWidth && thisWidth < 450.0)) {
                            if (reset && filterValues) {
                                average = 0.0;
                                numEntries = 0;
                            }
                            average += thisWidth;
                            ++numEntries;
                        }
                        thisWidth = right.getStemPosGivenOppPos(bottom) - left.getStemPosGivenOppPos(bottom);
                        skip = top - bottom < 130.0;
                        reset = false;
                        if (numEntries > 0) {
                            ave = average / (double)numEntries;
                            if (ave - thisWidth > 60.0) {
                                skip = true;
                            } else if (thisWidth - ave > 60.0 && top - bottom > 100.0) {
                                reset = true;
                            }
                        }
                        if (thisWidth > 0.0 && (!filterValues || !skip && thisWidth < percentOfWidth && thisWidth < 450.0)) {
                            if (reset && filterValues) {
                                average = 0.0;
                                numEntries = 0;
                            }
                            average += thisWidth;
                            ++numEntries;
                        }
                    }
                    if (top == p.y) {
                        if (bottom == p.x) continue block1;
                        p.y = bottom;
                        continue;
                    }
                    if (bottom == p.x) {
                        p.x = top;
                        continue;
                    }
                    double tmpbottom = p.x;
                    p.x = right.endOppositeDir;
                    p = new Point(tmpbottom, right.startOppositeDir);
                    extentIter.add(p);
                    extentIter.previous();
                }
            }
        }
        if (numEntries == 0) {
            return 0.0;
        }
        return average / (double)numEntries;
    }

    public double getComputedStem(double advanceWidth, double italicAngle) {
        this.mergeLines();
        this.removeIrrelevantLines(italicAngle);
        Collections.sort(this.leftEdges, EdgeComparator.comparator);
        Collections.sort(this.rightEdges, EdgeComparator.comparator);
        double retVal = this.averageWidth(advanceWidth, italicAngle, true);
        if (retVal == 0.0) {
            retVal = this.averageWidth(advanceWidth, italicAngle, false);
        }
        return retVal;
    }

    public void endchar() {
    }

    private static class Edge {
        private static final int SHORT_STEM = 130;
        private static final int SHORT_OVERLAP = 50;
        static final double ANGLE_VARIANCE_ALLOWED = 0.22;
        static final double MAX_WIDTH_PERCENTAGE = 0.8;
        static final double MAX_STEM = 450.0;
        static final int MAX_STEM_VARIANCE = 60;
        static final int MIN_LENGTH_FOR_STEM_OVERRIDE = 100;
        double startStemDir;
        double startOppositeDir;
        double endStemDir;
        double endOppositeDir;
        final double m;
        final double c;
        final boolean positiveAngle;

        Edge(double startStemDir, double startOppositeDir, double endStemDir, double endOppositeDir, boolean positiveAngle) {
            this.startStemDir = startStemDir;
            this.startOppositeDir = startOppositeDir;
            this.endStemDir = endStemDir;
            this.endOppositeDir = endOppositeDir;
            this.m = (startStemDir - endStemDir) / (startOppositeDir - endOppositeDir);
            this.c = startStemDir - startOppositeDir * ((startStemDir - endStemDir) / (startOppositeDir - endOppositeDir));
            this.positiveAngle = positiveAngle;
        }

        private static boolean almostEqual(double e1, double e2) {
            return Math.abs(e1 - e2) < 1.0E-4;
        }

        private boolean endpointsMeet(Edge e) {
            return Edge.almostEqual(this.startOppositeDir, e.endOppositeDir) || Edge.almostEqual(this.endOppositeDir, e.startOppositeDir);
        }

        private boolean sameFormula(Edge e) {
            return Edge.almostEqual(this.m, e.m) && Edge.almostEqual(this.c, e.c);
        }

        double getStemPosGivenOppPos(double opposite) {
            return this.m * opposite + this.c;
        }

        boolean continuation(Edge e) {
            if (this.sameFormula(e) && this.endpointsMeet(e)) {
                if (e.endOppositeDir > this.endOppositeDir) {
                    this.endOppositeDir = e.endOppositeDir;
                }
                if (e.startOppositeDir < this.startOppositeDir) {
                    this.startOppositeDir = e.startOppositeDir;
                }
                if (e.endStemDir > this.endStemDir) {
                    this.endStemDir = e.endStemDir;
                }
                if (e.startStemDir < this.startStemDir) {
                    this.startStemDir = e.startStemDir;
                }
                return true;
            }
            return false;
        }

        static boolean isShortOverlap(double endOppositeDir, double startOppositeDir) {
            return endOppositeDir - startOppositeDir < 50.0;
        }

        static boolean isShort(double endOppositeDir, double startOppositeDir) {
            return endOppositeDir - startOppositeDir < 130.0;
        }
    }

    private static class EdgeComparator
    implements Comparator {
        static final EdgeComparator comparator = new EdgeComparator();

        private EdgeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Edge e1 = (Edge)o1;
            Edge e2 = (Edge)o2;
            if (e1.endStemDir < e2.endStemDir || e1.endStemDir == e2.endStemDir && e1.endOppositeDir < e2.endOppositeDir) {
                return -1;
            }
            if (e1.endOppositeDir > e2.endOppositeDir || e1.endStemDir > e2.endStemDir) {
                return 1;
            }
            return 0;
        }
    }
}

