/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.IteratingOutlineConsumer;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import java.util.Iterator;

class ComparingOutlineConsumer
implements OutlineConsumer {
    Iterator compareTo;
    boolean compares = true;
    boolean hasOutlines = false;

    ComparingOutlineConsumer(IteratingOutlineConsumer compareTo) {
        this.compareTo = compareTo.iterator();
    }

    boolean equals() {
        return this.compares;
    }

    private boolean close(double first, double second) {
        return Math.abs(first - second) < 0.001;
    }

    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        this.hasOutlines = true;
        if (!this.compares) {
            return;
        }
        if (!this.compareTo.hasNext()) {
            this.compares = false;
            return;
        }
        IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)this.compareTo.next();
        if (next.type != IteratingOutlineConsumer.ElementType.cube) {
            this.compares = false;
            return;
        }
        if (this.close(x2, next.x1) && this.close(y2, next.y1) && this.close(x3, next.x2) && this.close(y3, next.y2) && this.close(x4, next.x3) && this.close(y4, next.y3)) {
            return;
        }
        this.compares = false;
    }

    public void curveto(double x2, double y2, double x3, double y3) {
        this.hasOutlines = true;
        if (!this.compares) {
            return;
        }
        if (!this.compareTo.hasNext()) {
            this.compares = false;
            return;
        }
        IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)this.compareTo.next();
        if (next.type != IteratingOutlineConsumer.ElementType.quad) {
            this.compares = false;
            return;
        }
        if (this.close(x2, next.x1) && this.close(y2, next.y1) && this.close(x3, next.x2) && this.close(y3, next.y2)) {
            return;
        }
        this.compares = false;
    }

    public void endchar() {
        while (this.compareTo.hasNext()) {
            IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)this.compareTo.next();
            if (next.type == IteratingOutlineConsumer.ElementType.move) continue;
            this.compares = false;
            return;
        }
    }

    private void compare1point(IteratingOutlineConsumer.ElementType type, double x, double y) {
        if (!this.compares) {
            return;
        }
        if (!this.compareTo.hasNext()) {
            this.compares = false;
            return;
        }
        IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)this.compareTo.next();
        if (next.type != type) {
            this.compares = false;
            return;
        }
        if (this.close(x, next.x1) && this.close(y, next.y1)) {
            return;
        }
        this.compares = false;
    }

    public void lineto(double x, double y) {
        this.hasOutlines = true;
        this.compare1point(IteratingOutlineConsumer.ElementType.line, x, y);
    }

    public void moveto(double x, double y) {
        this.compare1point(IteratingOutlineConsumer.ElementType.move, x, y);
    }

    public void setMatrix(Matrix newMatrix) {
    }
}

