/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.OutlineConsumer2BaseImpl;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class CScan
implements ScanConverter {
    private boolean useOffset;
    private boolean horizontalProximityFill;
    private double[] slopesArray;
    private CrossBuilder crossBuilder;
    private Map scanLines;
    private int firstScanline;
    private int lastScanline;
    private Set crossesAtXMinima;
    private Set crossesAtXMaxima;
    private Set contours;
    private static final double[] slopesArrayInit = new double[]{0.0, -0.0625, -0.29289, -0.366, -0.434, -0.5};
    private static final List emptyScanline = new LinkedList();
    private ScalerDebugger outlineDebugger;

    private static int indexOfSlope(double inverseSlope) {
        if (inverseSlope < 0.0) {
            inverseSlope = -inverseSlope;
        }
        if (inverseSlope > Math.tan(Math.toRadians(52.5))) {
            if (inverseSlope > Math.tan(Math.toRadians(82.5))) {
                return 5;
            }
            if (inverseSlope > Math.tan(Math.toRadians(67.5))) {
                return 4;
            }
            return 3;
        }
        if (inverseSlope < Math.tan(Math.toRadians(7.5))) {
            return 1;
        }
        return 2;
    }

    public CScan(boolean useOffset, double idealWidth, boolean horizontalProximityFill) {
        this.useOffset = useOffset;
        this.horizontalProximityFill = horizontalProximityFill;
        this.crossBuilder = new CrossBuilder();
        this.crossBuilder.setFlatness(1.0);
        this.slopesArray = null;
        if (useOffset) {
            this.slopesArray = new double[slopesArrayInit.length];
            System.arraycopy(slopesArrayInit, 0, this.slopesArray, 0, slopesArrayInit.length);
            if (idealWidth > 1.0) {
                double g = 2.0 * idealWidth - 1.0;
                for (int i = 1; i < this.slopesArray.length; ++i) {
                    this.slopesArray[i] = Math.max(this.slopesArray[i] * g, -1.0);
                }
            }
        }
    }

    public void setScanType(int scanType) {
    }

    public OutlineConsumer2 getOutlineConsumer2() {
        return this.crossBuilder;
    }

    public void getBitmap(BitmapConsumer bitmapConsumer) {
        this.buildInitialRuns();
        this.editWhiteSpace();
        this.returnBits(bitmapConsumer);
    }

    private void buildInitialRuns() {
        for (int y = this.firstScanline; y <= this.lastScanline; ++y) {
            List crosses = this.getScanline(y);
            Iterator it = crosses.iterator();
            while (it.hasNext()) {
                double rightRun;
                double leftRun;
                double lastX = Double.NEGATIVE_INFINITY;
                IntersectionCross c1 = (IntersectionCross)it.next();
                IntersectionCross c2 = (IntersectionCross)it.next();
                if (this.useOffset) {
                    double delta1 = this.slopesArray[c1.slopeIndex];
                    double delta2 = this.slopesArray[c2.slopeIndex];
                    c1.x -= delta1;
                    c2.x += delta2;
                    if (c1.x >= c2.x) {
                        c1.x = (c1.x + delta1 + c2.x - delta2) / 2.0;
                        c2.x = c1.x + 1.0;
                    }
                }
                if (c1.x <= lastX) {
                    c1.x = lastX + lastX / 1000.0;
                    c2.x = c1.x + c1.x / 1000.0;
                }
                if ((leftRun = (double)Math.round(c1.x)) != (rightRun = (double)Math.round(c2.x))) {
                    c1.xPixel = leftRun;
                    c2.xPixel = rightRun;
                } else if (this.horizontalProximityFill) {
                    c1.xPixel = Math.floor((c1.x + c2.x) / 2.0);
                    c2.xPixel = c1.xPixel + 1.0;
                } else {
                    c1.xPixel = leftRun;
                    c2.xPixel = rightRun;
                }
                lastX = Math.max(lastX, c2.x);
            }
        }
    }

    private void editWhiteSpace() {
    }

    private void returnBits(BitmapConsumer bitmapConsumer) {
        for (int y = this.firstScanline; y <= this.lastScanline; ++y) {
            List crosses = this.getScanline(y);
            Iterator it = crosses.iterator();
            while (it.hasNext()) {
                IntersectionCross c1 = (IntersectionCross)it.next();
                if (!it.hasNext()) {
                    System.err.println("unpaired cross at y=" + y);
                    continue;
                }
                IntersectionCross c2 = (IntersectionCross)it.next();
                double left = c1.xPixel;
                double right = c2.xPixel;
                if (!(left < right)) continue;
                bitmapConsumer.addRun(left, right, y);
            }
        }
    }

    private void paintCrosses(boolean iCrossesOnly) {
        for (Contour contour : this.contours) {
            Iterator it2 = contour.iterator();
            while (it2.hasNext()) {
                Cross c = (Cross)it2.next();
                if (iCrossesOnly && !(c instanceof IntersectionCross)) continue;
                this.outlineDebugger.cscanCross(c.x, c.y);
            }
        }
    }

    private List getScanline(int y) {
        List scanline = (LinkedList)this.scanLines.get(new Integer(y));
        if (scanline == null) {
            scanline = emptyScanline;
        }
        return scanline;
    }

    public void setDebugger(ScalerDebugger outlineDebugger) {
        this.outlineDebugger = outlineDebugger;
    }

    private class Contour {
        private static final int FORWARD = 1;
        private static final int BACKWARD = -1;
        private List crosses = new ArrayList();

        private Contour() {
        }

        public void add(Cross c) {
            this.crosses.add(c);
        }

        public IntersectionCross intersectionCrossBefore(Cross c1) {
            return this.adjacentIntersectionCross(c1, -1);
        }

        public IntersectionCross intersectionCrossAfter(Cross c1) {
            return this.adjacentIntersectionCross(c1, 1);
        }

        public Cross adjacentCross(Cross c1, int direction) {
            int i = this.crosses.indexOf(c1);
            if ((i = (i + direction) % this.crosses.size()) < 0) {
                i += this.crosses.size();
            }
            return (Cross)this.crosses.get(i);
        }

        public IntersectionCross adjacentIntersectionCross(Cross c1, int direction) {
            Cross c2;
            int i = this.crosses.indexOf(c1);
            do {
                if ((i = (i + direction) % this.crosses.size()) >= 0) continue;
                i += this.crosses.size();
            } while (!((c2 = (Cross)this.crosses.get(i)) instanceof IntersectionCross) && c2 != c1);
            if (c2 instanceof IntersectionCross) {
                return (IntersectionCross)c2;
            }
            return null;
        }

        public Iterator iterator() {
            return this.crosses.iterator();
        }

        public IntersectionEdgeIterator iterateIntersectionEdges() {
            return new IntersectionEdgeIterator();
        }

        public EdgeIterator iterateEdges(Cross c1, Cross c2) {
            return new EdgeIterator(c1, c2);
        }

        public EdgeIterator iterateEdges() {
            return new EdgeIterator();
        }

        public class EdgeIterator {
            int cursor = 0;
            int limit;
            boolean forceHas;
            Cross first;
            Cross second;

            public EdgeIterator(Cross c1, Cross c2) {
                this.cursor = Contour.this.crosses.indexOf(c1);
                this.limit = Contour.this.crosses.indexOf(c2);
                this.forceHas = false;
            }

            public EdgeIterator() {
                this.cursor = 0;
                this.limit = 0;
                this.forceHas = true;
            }

            public boolean hasNext() {
                return this.forceHas || this.cursor != this.limit;
            }

            public void next() {
                this.forceHas = false;
                this.first = (Cross)Contour.this.crosses.get(this.cursor);
                this.cursor = (this.cursor + 1) % Contour.this.crosses.size();
                this.second = (Cross)Contour.this.crosses.get(this.cursor);
            }

            public Cross c1() {
                return this.first;
            }

            public Cross c2() {
                return this.second;
            }
        }

        public class IntersectionEdgeIterator {
            int cursor = 0;
            IntersectionCross first;
            IntersectionCross second;

            public IntersectionEdgeIterator() {
                while (this.cursor < Contour.this.crosses.size() && !(Contour.this.crosses.get(this.cursor) instanceof IntersectionCross)) {
                    ++this.cursor;
                }
            }

            public boolean hasNext() {
                return this.cursor < Contour.this.crosses.size();
            }

            public void next() {
                this.first = (IntersectionCross)Contour.this.crosses.get(this.cursor);
                int o = (this.cursor + 1) % Contour.this.crosses.size();
                while (!(Contour.this.crosses.get(o) instanceof IntersectionCross)) {
                    o = (o + 1) % Contour.this.crosses.size();
                }
                this.second = (IntersectionCross)Contour.this.crosses.get(o);
                ++this.cursor;
                while (this.cursor < Contour.this.crosses.size() && !(Contour.this.crosses.get(this.cursor) instanceof IntersectionCross)) {
                    ++this.cursor;
                }
            }

            public IntersectionCross c1() {
                return this.first;
            }

            public IntersectionCross c2() {
                return this.second;
            }
        }
    }

    private class CrossBuilder
    extends OutlineConsumer2BaseImpl {
        private double THRESHOLD = 127.0;
        private double epsilon;
        private static final int NO_DIR = 0;
        private static final int RIGHT_DIR = 1;
        private static final int LEFT_DIR = -1;
        private static final int VERT_DIR = 2;
        private static final int UP_DIR = 1;
        private static final int DOWN_DIR = -1;
        private static final int HORIZ_DIR = 2;
        private int vertDir;
        private int horizDir;
        private Contour contour;
        private double firstSegmentX1;
        private double firstSegmentY1;
        private double firstSegmentX2;
        private double firstSegmentY2;

        private CrossBuilder() {
        }

        public void setFlatness(double flatness) {
            this.epsilon = Math.max(1.220703125E-4, 1.5 * flatness / 4.0);
        }

        public void startOutline() {
            CScan.this.scanLines = new HashMap();
            CScan.this.firstScanline = Integer.MAX_VALUE;
            CScan.this.lastScanline = Integer.MIN_VALUE;
            CScan.this.crossesAtXMinima = new HashSet();
            CScan.this.crossesAtXMaxima = new HashSet();
            CScan.this.contours = new HashSet();
        }

        public void startContour() {
            this.contour = new Contour();
            this.vertDir = 0;
            this.horizDir = 0;
        }

        public void line(double x1, double y1, double x2, double y2) {
            block9: {
                block8: {
                    if (Math.abs(y1 - Math.floor(y1) - 0.5) < 1.0E-5) {
                        y1 += y1 / 1000.0;
                    }
                    if (Math.abs(y2 - Math.floor(y2) - 0.5) < 1.0E-5) {
                        y2 += y2 / 1000.0;
                    }
                    if (this.horizDir == 0) {
                        this.firstSegmentX1 = x1;
                        this.firstSegmentY1 = y1;
                        this.firstSegmentX2 = x2;
                        this.firstSegmentY2 = y2;
                        this.setDirections(x1, y1, x2, y2);
                    } else {
                        this.addInflectionCrossIfNeeded(x1, y1, x2, y2);
                    }
                    if (!(y1 < y2)) break block8;
                    double inversedSlope = (x2 - x1) / (y2 - y1);
                    double yMid = Math.floor(y1 + 0.5) + 0.5;
                    double xMid = x1 + (yMid - y1) * inversedSlope;
                    while (yMid <= y2) {
                        IntersectionCross c = new IntersectionCross(xMid, yMid);
                        if (CScan.this.useOffset) {
                            c.slopeIndex = CScan.indexOfSlope(inversedSlope);
                        }
                        this.addIntersectionCross(c);
                        yMid += 1.0;
                        xMid += inversedSlope;
                    }
                    break block9;
                }
                if (!(y2 < y1)) break block9;
                double inversedSlope = (x2 - x1) / (y2 - y1);
                double yMid = Math.floor(y1 - 0.5) + 0.5;
                double xMid = x1 + (yMid - y1) * inversedSlope;
                while (y2 <= yMid) {
                    IntersectionCross c = new IntersectionCross(xMid, yMid);
                    if (CScan.this.useOffset) {
                        c.slopeIndex = CScan.indexOfSlope(inversedSlope);
                    }
                    this.addIntersectionCross(c);
                    yMid -= 1.0;
                    xMid -= inversedSlope;
                }
            }
        }

        public void quadraticCurve(double x1, double y1, double x2, double y2, double x3, double y3) {
            if ((x1 <= x2 && x2 <= x3 || x3 <= x2 && x2 <= x1) && Math.abs(x3 - x1) < this.THRESHOLD && Math.abs(x3 - x1 - 2.0 * (x2 - x1)) <= this.epsilon && (y1 <= y2 && y2 <= y3 || y3 <= y2 && y2 <= y1) && Math.abs(y3 - y1) < this.THRESHOLD && Math.abs(y3 - y1 - 2.0 * (y2 - y1)) <= this.epsilon) {
                this.line(x1, y1, x3, y3);
            } else {
                double x12 = (x2 + x1) / 2.0;
                double y12 = (y2 + y1) / 2.0;
                double x23 = (x3 + x2) / 2.0;
                double y23 = (y3 + y2) / 2.0;
                double x1223 = (x12 + x23) / 2.0;
                double y1223 = (y12 + y23) / 2.0;
                this.quadraticCurve(x1, y1, x12, y12, x1223, y1223);
                this.quadraticCurve(x1223, y1223, x23, y23, x3, y3);
            }
        }

        public void cubicCurve(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
            if ((x1 <= x2 && x2 <= x3 && x3 <= x4 || x4 <= x3 && x3 <= x2 && x2 <= x1) && Math.abs(x4 - x1) < this.THRESHOLD && Math.abs(x4 - x1 - 3.0 * (x2 - x1)) <= this.epsilon && Math.abs(x4 - x1 - 3.0 * (x4 - x3)) <= this.epsilon && (y1 <= y2 && y2 <= y3 && y3 <= y4 || y4 <= y3 && y3 <= y2 && y2 <= y1) && Math.abs(y4 - y1) < this.THRESHOLD && Math.abs(y4 - y1 - 3.0 * (y2 - y1)) <= this.epsilon && Math.abs(y4 - y1 - 3.0 * (y4 - y3)) <= this.epsilon) {
                this.line(x1, y1, x4, y4);
            } else {
                double x12 = (x2 + x1) / 2.0;
                double y12 = (y2 + y1) / 2.0;
                double x23 = (x3 + x2) / 2.0;
                double y23 = (y3 + y2) / 2.0;
                double x34 = (x4 + x3) / 2.0;
                double y34 = (y4 + y3) / 2.0;
                double x1223 = (x23 + x12) / 2.0;
                double y1223 = (y23 + y12) / 2.0;
                double x2334 = (x34 + x23) / 2.0;
                double y2334 = (y34 + y23) / 2.0;
                double xx = (x1223 + x2334) / 2.0;
                double yy = (y1223 + y2334) / 2.0;
                this.cubicCurve(x1, y1, x12, y12, x1223, y1223, xx, yy);
                this.cubicCurve(xx, yy, x2334, y2334, x34, y34, x4, y4);
            }
        }

        public void endContour() {
            this.addInflectionCrossIfNeeded(this.firstSegmentX1, this.firstSegmentY1, this.firstSegmentX2, this.firstSegmentY2);
            CScan.this.contours.add(this.contour);
            this.contour = null;
        }

        public void endOutline() {
        }

        private void setDirections(double x1, double y1, double x2, double y2) {
            this.horizDir = x1 < x2 ? 1 : (x1 == x2 ? 2 : -1);
            this.vertDir = y1 < y2 ? 1 : (y1 == y2 ? 2 : -1);
        }

        private void addInflectionCrossIfNeeded(double x1, double y1, double x2, double y2) {
            boolean allPoints = false;
            ExtraCross c = null;
            if (allPoints) {
                c = new ExtraCross(x1, y1);
            }
            if (x1 < x2 && this.horizDir != 1) {
                if (this.horizDir != 0) {
                    if (c == null) {
                        c = new ExtraCross(x1, y1);
                    }
                    CScan.this.crossesAtXMinima.add(c);
                }
                this.horizDir = 1;
            } else if (x1 == x2 && this.horizDir != 2) {
                if (this.horizDir != 0) {
                    if (c == null) {
                        c = new ExtraCross(x1, y1);
                    }
                    if (this.horizDir == -1) {
                        CScan.this.crossesAtXMinima.add(c);
                    } else {
                        CScan.this.crossesAtXMaxima.add(c);
                    }
                }
                this.horizDir = 2;
            } else if (x1 > x2 && this.horizDir != -1) {
                if (this.horizDir != 0) {
                    if (c == null) {
                        c = new ExtraCross(x1, y1);
                    }
                    CScan.this.crossesAtXMaxima.add(c);
                }
                this.horizDir = -1;
            }
            if (y1 < y2) {
                if (this.vertDir != 1) {
                    if (c == null) {
                        c = new ExtraCross(x1, y1);
                    }
                    this.vertDir = 1;
                }
            } else if (y1 == y2) {
                if (this.vertDir != 2) {
                    if (c == null) {
                        c = new ExtraCross(x1, y1);
                    }
                    this.vertDir = 2;
                }
            } else if (this.vertDir != -1) {
                if (c == null) {
                    c = new ExtraCross(x1, y1);
                }
                this.vertDir = -1;
            }
            if (c != null) {
                this.addCrossToCountour(c);
            }
        }

        private void addIntersectionCross(IntersectionCross c) {
            ListIterator<IntersectionCross> it;
            int y = (int)Math.floor(c.y);
            CScan.this.firstScanline = Math.min(CScan.this.firstScanline, y);
            CScan.this.lastScanline = Math.max(CScan.this.lastScanline, y);
            Integer Y = new Integer(y);
            LinkedList<IntersectionCross> l = (LinkedList<IntersectionCross>)CScan.this.scanLines.get(Y);
            if (l == null) {
                l = new LinkedList<IntersectionCross>();
                CScan.this.scanLines.put(Y, l);
            }
            if (!(it = l.listIterator()).hasNext()) {
                l.add(0, c);
            } else {
                boolean added = false;
                while (it.hasNext()) {
                    IntersectionCross cross = (IntersectionCross)it.next();
                    if (cross.compareTo(c) < 0) continue;
                    if (it.hasPrevious()) {
                        it.previous();
                        it.add(c);
                    } else {
                        l.add(0, c);
                    }
                    added = true;
                    break;
                }
                if (!added) {
                    l.add(c);
                }
            }
            this.addCrossToCountour(c);
        }

        private void addCrossToCountour(Cross c) {
            c.contour = this.contour;
            this.contour.add(c);
        }
    }

    private class ExtraCross
    extends Cross {
        public ExtraCross(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private class IntersectionCross
    extends Cross
    implements Comparable {
        double xPixel;
        int slopeIndex;

        public IntersectionCross(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public boolean isLeftInRun() {
            List scanLine = CScan.this.getScanline((int)Math.floor(this.y));
            Iterator it = scanLine.iterator();
            while (it.hasNext()) {
                IntersectionCross c = (IntersectionCross)it.next();
                if (c == this) {
                    return true;
                }
                c = (IntersectionCross)it.next();
                if (c != this) continue;
                return false;
            }
            throw new RuntimeException("unpaired crosses in run at y=" + this.y);
        }

        public IntersectionCross leftInRun() {
            List scanLine = CScan.this.getScanline((int)Math.floor(this.y));
            IntersectionCross previous = null;
            for (IntersectionCross c : scanLine) {
                if (c == this) {
                    return previous;
                }
                previous = c;
            }
            return null;
        }

        public IntersectionCross rightInRun() {
            List scanLine = CScan.this.getScanline((int)Math.floor(this.y));
            Iterator it = scanLine.iterator();
            while (it.hasNext()) {
                IntersectionCross c = (IntersectionCross)it.next();
                if (c != this) continue;
                if (it.hasNext()) {
                    return (IntersectionCross)it.next();
                }
                return null;
            }
            return null;
        }

        public int compareTo(Object arg0) {
            IntersectionCross e = (IntersectionCross)arg0;
            if (e.x < this.x) {
                return 1;
            }
            if (e.x == this.x) {
                return 0;
            }
            return -1;
        }
    }

    private abstract class Cross {
        double x;
        double y;
        Contour contour;

        private Cross() {
        }

        public String toString() {
            return "{" + (double)Math.round(this.x * 100.0) / 100.0 + ", " + (double)Math.round(this.y * 100.0) / 100.0 + "}";
        }
    }
}

