/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.ChildNode;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DOMConfigurationImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.DocumentTypeImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.NodeListImpl;
import org.apache.axiom.om.impl.dom.OMChildrenLocalNameIterator;
import org.apache.axiom.om.impl.dom.OMChildrenNamespaceIterator;
import org.apache.axiom.om.impl.dom.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.dom.OMContainerHelper;
import org.apache.axiom.om.impl.dom.OMDescendantsIterator;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.impl.jaxp.OMSource;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParentNode
extends ChildNode
implements OMContainerEx {
    protected ChildNode firstChild;
    protected ChildNode lastChild;

    protected ParentNode(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
    }

    protected ParentNode(OMFactory factory) {
        super(factory);
    }

    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public void addChild(OMNode omNode) {
        if (omNode.getOMFactory() instanceof OMDOMFactory) {
            Node domNode = (Node)omNode;
            if (this.ownerDocument() != null && !domNode.getOwnerDocument().equals(this.ownerDocument())) {
                this.appendChild(this.ownerDocument().importNode(domNode, true));
            } else {
                this.appendChild(domNode);
            }
        } else {
            this.addChild(this.importNode(omNode));
        }
    }

    public void buildNext() {
        if (this.builder != null) {
            this.builder.next();
        }
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getDescendants(boolean includeSelf) {
        return new OMDescendantsIterator((OMContainer)this, includeSelf);
    }

    public Iterator getChildrenWithName(QName elementQName) throws OMException {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    public Iterator getChildrenWithLocalName(String localName) {
        return new OMChildrenLocalNameIterator(this.getFirstOMChild(), localName);
    }

    public Iterator getChildrenWithNamespaceURI(String uri) {
        return new OMChildrenNamespaceIterator(this.getFirstOMChild(), uri);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator children = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        while (children.hasNext()) {
            OMNode node = (OMNode)children.next();
            if (!(node instanceof OMElement)) continue;
            return (OMElement)node;
        }
        return null;
    }

    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return (OMNode)this.firstChild;
    }

    public OMNode getFirstOMChildIfAvailable() {
        return (OMNode)this.firstChild;
    }

    public void setFirstChild(OMNode omNode) {
        if (this.firstChild != null) {
            ((OMNodeEx)omNode).setParent((OMContainer)this);
        }
        this.firstChild = (ChildNode)omNode;
    }

    public void setLastChild(OMNode omNode) {
        this.lastChild = (ChildNode)omNode;
    }

    public NodeList getChildNodes() {
        if (!this.done) {
            this.build();
        }
        return new NodeListImpl(){

            protected Iterator getIterator() {
                return ParentNode.this.getChildren();
            }
        };
    }

    public Node getFirstChild() {
        return (Node)this.getFirstOMChild();
    }

    public Node getLastChild() {
        if (!this.done) {
            this.build();
        }
        return this.lastChild;
    }

    public boolean hasChildNodes() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild != null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        ChildNode newDomChild = (ChildNode)newChild;
        ChildNode refDomChild = (ChildNode)refChild;
        if (this == newChild || !this.isAncestor(newChild)) {
            throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
        }
        if (newDomChild.parentNode() != null && newDomChild.ownerDocument() == this.ownerDocument()) {
            newDomChild.parentNode().removeChild(newDomChild);
        }
        if (!(this instanceof Document) && this.ownerDocument() != newDomChild.getOwnerDocument()) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 4, null));
        }
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 7, null));
        }
        if (this instanceof Document) {
            if (newDomChild instanceof ElementImpl) {
                if (((DocumentImpl)this).getOMDocumentElement(false) != null) {
                    throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
                }
                if (newDomChild.parentNode() == null) {
                    newDomChild.setParent((OMContainer)this);
                }
            } else if (!(newDomChild instanceof CommentImpl || newDomChild instanceof ProcessingInstructionImpl || newDomChild instanceof DocumentFragmentImpl || newDomChild instanceof DocumentTypeImpl)) {
                throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
            }
        }
        if (refChild == null) {
            if (this.lastChild == null && this.firstChild == null) {
                this.lastChild = newDomChild;
                this.firstChild = newDomChild;
                this.firstChild.isFirstChild(true);
                newDomChild.setParent((OMContainer)this);
            } else {
                this.lastChild.nextSibling = newDomChild;
                newDomChild.previousSibling = this.lastChild;
                this.lastChild = newDomChild;
                this.lastChild.nextSibling = null;
            }
            if (newDomChild.parentNode() == null) {
                newDomChild.setParent((OMContainer)this);
            }
        } else {
            Iterator children = this.getChildren();
            boolean found = false;
            while (children.hasNext()) {
                ChildNode tempNode = (ChildNode)children.next();
                if (!tempNode.equals(refChild)) continue;
                if (this.firstChild == tempNode) {
                    if (newChild instanceof DocumentFragmentImpl) {
                        DocumentFragmentImpl docFrag = (DocumentFragmentImpl)newChild;
                        ChildNode child = docFrag.firstChild;
                        while (child != null) {
                            child.setParent((OMContainer)this);
                            child = child.nextSibling;
                        }
                        this.firstChild = docFrag.firstChild;
                        refDomChild.previousSibling = docFrag.lastChild.nextSibling = refDomChild;
                        docFrag.firstChild = null;
                        docFrag.lastChild = null;
                    } else {
                        this.firstChild = newDomChild;
                        newDomChild.nextSibling = refDomChild;
                        refDomChild.previousSibling = newDomChild;
                        this.firstChild.isFirstChild(true);
                        refDomChild.isFirstChild(false);
                        newDomChild.previousSibling = null;
                    }
                } else {
                    ChildNode previousNode = refDomChild.previousSibling;
                    if (newChild instanceof DocumentFragmentImpl) {
                        DocumentFragmentImpl docFrag = (DocumentFragmentImpl)newChild;
                        ChildNode child = docFrag.firstChild;
                        while (child != null) {
                            child.setParent((OMContainer)this);
                            child = child.nextSibling;
                        }
                        previousNode.nextSibling = docFrag.firstChild;
                        docFrag.firstChild.previousSibling = previousNode;
                        docFrag.lastChild.nextSibling = refDomChild;
                        refDomChild.previousSibling = docFrag.lastChild;
                        docFrag.firstChild = null;
                        docFrag.lastChild = null;
                    } else {
                        previousNode.nextSibling = newDomChild;
                        newDomChild.previousSibling = previousNode;
                        newDomChild.nextSibling = refDomChild;
                        refDomChild.previousSibling = newDomChild;
                    }
                }
                found = true;
                break;
            }
            if (!found) {
                throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null));
            }
            if (newDomChild.parentNode() == null) {
                newDomChild.setParent((OMContainer)this);
            }
        }
        if (!newDomChild.isComplete() && !(newDomChild instanceof OMSourcedElement)) {
            this.setComplete(false);
        }
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        ChildNode newDomChild = (ChildNode)newChild;
        ChildNode oldDomChild = (ChildNode)oldChild;
        if (newChild == null) {
            return this.removeChild(oldChild);
        }
        if (this == newChild || !this.isAncestor(newChild)) {
            throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
        }
        if (newDomChild != null && this.ownerDocument() != null && !this.ownerDocument().equals(newDomChild.ownerDocument()) || this.ownerDocument() == null && !this.equals(this.ownerDocument())) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 4, null));
        }
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 7, null));
        }
        Iterator children = this.getChildren();
        boolean found = false;
        while (!found && children.hasNext()) {
            ChildNode tempNode = (ChildNode)children.next();
            if (!tempNode.equals(oldChild)) continue;
            if (newChild instanceof DocumentFragmentImpl) {
                DocumentFragmentImpl docFrag = (DocumentFragmentImpl)newDomChild;
                ChildNode child = (ChildNode)docFrag.getFirstChild();
                this.replaceChild(child, oldChild);
                while (child != null) {
                    child.setParent((OMContainer)this);
                    child = child.nextSibling;
                }
                this.lastChild = (ChildNode)docFrag.getLastChild();
            } else {
                if (this.firstChild == oldDomChild) {
                    if (this.firstChild.nextSibling != null) {
                        this.firstChild.nextSibling.previousSibling = newDomChild;
                        newDomChild.nextSibling = this.firstChild.nextSibling;
                    }
                    this.firstChild.setParent(null);
                    this.firstChild.nextSibling = null;
                    this.firstChild = newDomChild;
                } else {
                    newDomChild.nextSibling = oldDomChild.nextSibling;
                    newDomChild.previousSibling = oldDomChild.previousSibling;
                    oldDomChild.previousSibling.nextSibling = newDomChild;
                    if (oldDomChild.nextSibling != null) {
                        oldDomChild.nextSibling.previousSibling = newDomChild;
                    } else {
                        this.lastChild = newDomChild;
                    }
                }
                newDomChild.setParent((OMContainer)this);
            }
            found = true;
            oldDomChild.nextSibling = null;
            oldDomChild.previousSibling = null;
            oldDomChild.setParent(null);
        }
        if (!found) {
            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null));
        }
        return oldChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 7, null));
        }
        if (oldChild.getParentNode() == this) {
            ((ChildNode)oldChild).detach();
            return oldChild;
        }
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null));
    }

    private boolean isAncestor(Node newNode) {
        return true;
    }

    public Node cloneNode(boolean deep) {
        ParentNode newnode = (ParentNode)super.cloneNode(deep);
        newnode.setParent(null);
        newnode.firstChild = null;
        newnode.lastChild = null;
        if (deep) {
            ChildNode child = this.firstChild;
            while (child != null) {
                newnode.appendChild(child.cloneNode(true));
                child = child.nextSibling;
            }
        }
        return newnode;
    }

    protected OMNode importNode(OMNode child) {
        int type = child.getType();
        switch (type) {
            case 1: {
                OMElement childElement = (OMElement)child;
                OMElement newElement = new StAXOMBuilder(this.factory, childElement.getXMLStreamReader()).getDocumentElement();
                newElement.build();
                return (OMNode)this.ownerDocument().importNode((Element)newElement, true);
            }
            case 4: {
                OMText newText;
                OMText importedText = (OMText)child;
                if (importedText.isBinary()) {
                    boolean isOptimize = importedText.isOptimized();
                    newText = this.factory.createOMText(importedText.getDataHandler(), isOptimize);
                } else {
                    newText = importedText.isCharacters() ? new TextImpl((DocumentImpl)this.getOwnerDocument(), importedText.getTextCharacters(), this.factory) : new TextImpl((DocumentImpl)this.getOwnerDocument(), importedText.getText(), this.factory);
                }
                return newText;
            }
            case 3: {
                OMProcessingInstruction importedPI = (OMProcessingInstruction)child;
                OMProcessingInstruction newPI = this.factory.createOMProcessingInstruction((OMContainer)this, importedPI.getTarget(), importedPI.getValue());
                return newPI;
            }
            case 5: {
                OMComment importedComment = (OMComment)child;
                OMComment newComment = this.factory.createOMComment((OMContainer)this, importedComment.getValue());
                DocumentImpl doc = this instanceof DocumentImpl ? (DocumentImpl)this : (DocumentImpl)this.getOwnerDocument();
                newComment = new CommentImpl(doc, importedComment.getValue(), this.factory);
                return newComment;
            }
            case 11: {
                OMDocType importedDocType = (OMDocType)child;
                OMDocType newDocType = this.factory.createOMDocType((OMContainer)this, importedDocType.getValue());
                return newDocType;
            }
        }
        throw new UnsupportedOperationException("Not Implemented Yet for the given node type");
    }

    public String getTextContent() throws DOMException {
        Node child = this.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return ParentNode.hasTextContent(child) ? ((NodeImpl)child).getTextContent() : "";
            }
            StringBuffer buf = new StringBuffer();
            this.getTextContent(buf);
            return buf.toString();
        }
        return "";
    }

    void getTextContent(StringBuffer buf) throws DOMException {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!ParentNode.hasTextContent(child)) continue;
            ((NodeImpl)child).getTextContent(buf);
        }
    }

    private static boolean hasTextContent(Node child) {
        return child.getNodeType() != 8 && child.getNodeType() != 7;
    }

    public void setTextContent(String textContent) throws DOMException {
        Node child;
        while ((child = this.getFirstChild()) != null) {
            this.removeChild(child);
        }
        if (textContent != null && textContent.length() != 0) {
            this.addChild((OMNode)this.factory.createOMText(textContent));
        }
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    public XMLStreamReader getXMLStreamReader(boolean cache) {
        return OMContainerHelper.getXMLStreamReader((OMContainer)this, cache);
    }

    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        return OMContainerHelper.getXMLStreamReader((OMContainer)this, cache, configuration);
    }

    public SAXSource getSAXSource(boolean cache) {
        return new OMSource((OMContainer)this);
    }

    void notifyChildComplete() {
        if (!this.done && this.builder == null) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                if (node.isComplete()) continue;
                return;
            }
            this.setComplete(true);
        }
    }

    void normalize(DOMConfigurationImpl config) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            ((NodeImpl)child).normalize(config);
        }
    }
}

