/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.sqlserverbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import macromedia.jdbc.extensions.ExtDataSource;
import macromedia.jdbc.sqlserverbase.BaseConnection;
import macromedia.jdbc.sqlserverbase.BaseConnectionProperties;
import macromedia.jdbc.sqlserverbase.BaseDriver;
import macromedia.jdbc.sqlserverbase.BaseDriverPropertyInfos;
import macromedia.jdbc.sqlserverbase.BaseExceptions;
import macromedia.jdbc.sqlserverbase.BaseURLParser;
import macromedia.jdbc.sqlserverbase.hb;
import macromedia.jdbc.sqlserverbase.s;
import macromedia.jdbcx.sqlserverbase.BaseLog;
import macromedia.jdbcx.sqlserverbase.BasePooledConnection;
import macromedia.jdbcx.sqlserverbase.b;
import macromedia.sqlserverutil.ae;
import macromedia.sqlserverutil.as;
import macromedia.sqlserverutil.bz;

public class BaseDataSource
implements ExtDataSource,
Serializable,
Referenceable,
ConnectionPoolDataSource,
DataSource {
    private static final long serialVersionUID = 1L;
    protected transient BaseExceptions exceptions;
    public transient ae debug;
    private transient PrintWriter printWriter;
    protected transient Object spyLogger;
    private transient boolean internalConnectionCallDoNotLog = false;
    Integer queryTimeout = null;
    protected String databaseName;
    String dataSourceName = "";
    String description;
    private char[] encryptedPassword;
    String portNumber;
    String roleName;
    String serverName;
    String importStatementPool;
    private char[] encryptedUser;
    String extendedOptions;
    Integer loginTimeout = null;
    Boolean batchPerformanceWorkaround = null;
    Boolean registerStatementPoolMonitorMBean = null;
    String spyAttributes;
    Integer maxPooledStatements = null;
    Integer initialPoolSize = null;
    Integer minPoolSize = null;
    Integer maxPoolSize = null;
    Integer maxIdleTime = null;
    Integer propertyCycle = null;
    Integer insensitiveResultSetBufferSize = null;
    String alternateServers;
    Integer connectionRetryCount = null;
    Integer connectionRetryDelay = null;
    Boolean loadBalancing = null;
    Boolean javaDoubleToString = null;
    Boolean enableBulkLoad = null;
    Integer bulkLoadBatchSize = null;
    String hostNameInCertificate = null;
    Boolean isTLSTunnel = null;
    String keyPassword = null;
    String keystore = null;
    String keystorePassword = null;
    String truststore = null;
    String truststorePassword = null;
    Boolean useSystemProxyOptions = null;
    Boolean validateIsClosed = null;
    Boolean validateServerCertificate = null;
    String proxyHost = null;
    Integer proxyPort = null;
    String proxyUser = null;
    String proxyPassword = null;
    Integer jdbcBehavior = null;
    Integer resultsetMetaDataOptions = null;
    String initializationString;
    String loadLibraryPath;
    String clientAppName;
    String clientHostName;
    String clientUser;
    String clientAcctInfo;
    String clientProgramID;
    Integer workarounds = null;
    Integer convertNull = null;
    Integer catalogOptions = null;
    boolean ignoreCatalogIncludesSynonymsSetting = false;
    String failoverMode = "connect";
    String failoverGranularity = "nonAtomic";
    Boolean failoverPreconnect = null;
    protected Properties connectionPropertiesFile = null;
    String cryptoProtocolVersion;
    String servicePrincipalName;
    String loginConfigName;
    Object gssCredentials;
    String randomGenerator = "SECURERANDOM";
    String secureRandomAlgorithm;

    public BaseDataSource() {
        this.getUserDefaultConnectionPropertiesFile();
        if (this.connectionPropertiesFile != null && !this.connectionPropertiesFile.isEmpty()) {
            String string;
            try {
                string = (String)this.connectionPropertiesFile.get("BULKLOADBATCHSIZE");
                if (string != null && string.length() > 0) {
                    this.setBulkLoadBatchSize(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = (String)this.connectionPropertiesFile.get("ALTERNATESERVERS");
            if (string != null && string.length() > 0) {
                this.setAlternateServers(string);
                string = null;
            }
            try {
                string = (String)this.connectionPropertiesFile.get("BATCHPERFORMANCEWORKAROUND");
                if (string != null && string.length() > 0) {
                    this.setBatchPerformanceWorkaround(bz.a(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("REGISTERSTATEMENTPOOLMONITORMBEAN");
                if (string != null && string.length() > 0) {
                    this.setRegisterStatementPoolMonitorMBean(bz.a(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("MAXPOOLEDSTATEMENTS");
                if (string != null && string.length() > 0) {
                    this.setMaxPooledStatements(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = (String)this.connectionPropertiesFile.get("IMPORTSTATEMENTPOOL");
            if (string != null && string.length() > 0) {
                this.setImportStatementPool(string);
                string = null;
            }
            try {
                string = (String)this.connectionPropertiesFile.get("INSENSITIVERESULTSETBUFFERSIZE");
                if (string != null && string.length() > 0) {
                    this.setInsensitiveResultSetBufferSize(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get(BaseConnection.bD);
                if (string != null && string.length() > 0) {
                    this.setConnectionRetryCount(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("CONNECTIONRETRYDELAY");
                if (string != null && string.length() > 0) {
                    this.setConnectionRetryDelay(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("LOADBALANCING");
                if (string != null && string.length() > 0) {
                    this.setLoadBalancing(bz.a(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("RESULTSETMETADATAOPTIONS");
                if (string != null && string.length() > 0) {
                    this.setResultsetMetaDataOptions(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("JAVADOUBLETOSTRING");
                if (string != null && string.length() > 0) {
                    this.setJavaDoubleToString(bz.a(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = (String)this.connectionPropertiesFile.get("INITIALIZATIONSTRING");
            if (string != null && string.length() > 0) {
                this.setInitializationString(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("LOADLIBRARYPATH")) != null && string.length() > 0) {
                this.setLoadLibraryPath(string);
                string = null;
            }
            try {
                string = (String)this.connectionPropertiesFile.get("WORKAROUNDS");
                if (string != null && string.length() > 0) {
                    this.setWorkarounds(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("CONVERTNULL");
                if (string != null && string.length() > 0) {
                    this.setConvertNull(bz.a(string) ? 1 : 0);
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("QUERYTIMEOUT");
                if (string != null && string.length() > 0) {
                    this.setQueryTimeout(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("CATALOGOPTIONS");
                if (string != null && string.length() > 0) {
                    this.setCatalogOptions(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = (String)this.connectionPropertiesFile.get("FAILOVERMODE");
            if (string != null && string.length() > 0) {
                this.setFailoverMode(string);
                string = null;
            }
            try {
                string = (String)this.connectionPropertiesFile.get("FAILOVERPRECONNECT");
                if (string != null && string.length() > 0) {
                    this.setFailoverPreconnect(bz.a(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = (String)this.connectionPropertiesFile.get("FAILOVERGRANULARITY");
            if (string != null && string.length() > 0) {
                this.setFailoverGranularity(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("APPLICATIONNAME")) != null && string.length() > 0) {
                this.setApplicationName(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("CLIENTUSER")) != null && string.length() > 0) {
                this.setClientUser(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("CLIENTHOSTNAME")) != null && string.length() > 0) {
                this.setClientHostName(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("ACCOUNTINGINFO")) != null && string.length() > 0) {
                this.setAccountingInfo(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("PROGRAMID")) != null && string.length() > 0) {
                this.setProgramID(string);
                string = null;
            }
            try {
                string = (String)this.connectionPropertiesFile.get("JDBCBEHAVIOR");
                if (string != null && string.length() > 0) {
                    this.setJDBCBehavior(Integer.parseInt(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)this.connectionPropertiesFile.get("ENABLEBULKLOAD");
                if (string != null && string.length() > 0) {
                    this.setEnableBulkLoad(bz.a(string));
                    string = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = (String)this.connectionPropertiesFile.get("CRYPTOPROTOCOLVERSION");
            if (string != null && string.length() > 0) {
                this.setCryptoProtocolVersion(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("RANDOMGENERATOR")) != null && string.length() > 0) {
                this.setRandomGenerator(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("SECURERANDOMALGORITHM")) != null && string.length() > 0) {
                this.setSecureRandomAlgorithm(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("HOSTNAMEINCERTIFICATE")) != null && string.length() > 0) {
                this.setHostNameInCertificate(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("ISTLSTUNNEL")) != null && string.length() > 0) {
                this.setIsTLSTunnel(bz.a(string));
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("KEYPASSWORD")) != null && string.length() > 0) {
                this.setKeyPassword(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("KEYSTORE")) != null && string.length() > 0) {
                this.setKeystore(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("KEYSTOREPASSWORD")) != null && string.length() > 0) {
                this.setKeystorePassword(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("TRUSTSTORE")) != null && string.length() > 0) {
                this.setTruststore(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("TRUSTSTOREPASSWORD")) != null && string.length() > 0) {
                this.setTruststorePassword(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("PROXYHOST")) != null && string.length() > 0) {
                this.setProxyHost(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("PROXYPORT")) != null && string.length() > 0) {
                this.setProxyPort(Integer.parseInt(string));
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("PROXYUSER")) != null && string.length() > 0) {
                this.setProxyUser(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("PROXYPASSWORD")) != null && string.length() > 0) {
                this.setProxyPassword(string);
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("USESYSTEMPROXYOPTIONS")) != null && string.length() > 0) {
                this.setUseSystemProxyOptions(bz.a(string));
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("VALIDATEISCLOSED")) != null && string.length() > 0) {
                this.setValidateIsClosed(bz.a(string));
                string = null;
            }
            if ((string = (String)this.connectionPropertiesFile.get("VALIDATESERVERCERTIFICATE")) != null && string.length() > 0) {
                this.setValidateServerCertificate(bz.a(string));
                string = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUserDefaultConnectionPropertiesFile() {
        this.connectionPropertiesFile = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/macromedia/sqlserverutil/userDefaults.properties");
        try {
            if (inputStream != null) {
                this.connectionPropertiesFile.load(inputStream);
            }
            Enumeration<Object> enumeration = this.connectionPropertiesFile.keys();
            for (int i2 = 0; i2 < this.connectionPropertiesFile.size(); ++i2) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.connectionPropertiesFile.get(string);
                this.connectionPropertiesFile.remove(string);
                this.connectionPropertiesFile.setProperty(string.toUpperCase(), string2);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public int getCatalogOptions() {
        if (this.catalogOptions != null) {
            return this.catalogOptions;
        }
        return 2;
    }

    public void setCatalogOptions(int n2) {
        this.catalogOptions = new Integer(n2);
        this.ignoreCatalogIncludesSynonymsSetting = true;
    }

    @Deprecated
    public boolean getCatalogIncludesSynonyms() {
        if (this.catalogOptions == null) {
            return false;
        }
        return (this.catalogOptions & 2) > 0;
    }

    @Deprecated
    public void setCatalogIncludesSynonyms(boolean bl2) {
        if (!this.ignoreCatalogIncludesSynonymsSetting) {
            this.catalogOptions = new Integer(bl2 ? 2 : 0);
        }
    }

    public final String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final String getPassword() {
        if (this.encryptedPassword == null) {
            return null;
        }
        return new String(BaseConnectionProperties.b(this.encryptedPassword, this.getRandomGenerator(), this.getSecureRandomAlgorithm()));
    }

    public final void setPassword(String string) {
        this.encryptedPassword = (char[])(string != null ? BaseConnectionProperties.a(string.toCharArray(), this.getRandomGenerator(), this.getSecureRandomAlgorithm()) : null);
    }

    public int getPortNumber() {
        if (this.portNumber == null) {
            return 0;
        }
        return Integer.parseInt(this.portNumber);
    }

    public final void setPortNumber(int n2) {
        this.portNumber = new Integer(n2).toString();
    }

    public final String getRoleName() {
        return this.roleName;
    }

    public final void setRoleName(String string) {
        this.roleName = string;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final String getImportStatementPool() {
        return this.importStatementPool;
    }

    public final void setImportStatementPool(String string) {
        this.importStatementPool = string;
    }

    public final String getExtendedOptions() {
        return this.extendedOptions;
    }

    public final void setExtendedOptions(String string) {
        this.extendedOptions = string;
    }

    public final String getUser() {
        if (this.encryptedUser == null) {
            return null;
        }
        return new String(BaseConnectionProperties.b(this.encryptedUser, this.getRandomGenerator(), this.getSecureRandomAlgorithm()));
    }

    public final void setUser(String string) {
        this.encryptedUser = (char[])(string != null ? BaseConnectionProperties.a(string.toCharArray(), this.getRandomGenerator(), this.getSecureRandomAlgorithm()) : null);
    }

    public final boolean getRegisterStatementPoolMonitorMBean() {
        if (this.registerStatementPoolMonitorMBean != null) {
            return this.registerStatementPoolMonitorMBean;
        }
        return false;
    }

    public final void setRegisterStatementPoolMonitorMBean(boolean bl2) {
        this.registerStatementPoolMonitorMBean = new Boolean(bl2);
    }

    public final boolean getBatchPerformanceWorkaround() {
        if (this.batchPerformanceWorkaround != null) {
            return this.batchPerformanceWorkaround;
        }
        return false;
    }

    public final void setBatchPerformanceWorkaround(boolean bl2) {
        if (s.t()) {
            this.batchPerformanceWorkaround = new Boolean(bl2);
        }
    }

    public void setQueryTimeout(int n2) {
        this.queryTimeout = new Integer(n2);
    }

    public int getQueryTimeout() {
        if (this.queryTimeout != null) {
            return this.queryTimeout;
        }
        return 0;
    }

    @Override
    public final int getLoginTimeout() {
        if (this.loginTimeout != null) {
            return this.loginTimeout;
        }
        return 0;
    }

    @Override
    public final void setLoginTimeout(int n2) {
        this.loginTimeout = new Integer(n2);
    }

    public final String getSpyAttributes() {
        return this.spyAttributes;
    }

    public final void setSpyAttributes(String string) {
        this.spyAttributes = string;
        if (this.spyAttributes != null) {
            if (this.spyAttributes.charAt(0) == '(') {
                this.spyAttributes = this.spyAttributes.substring(1);
            }
            if (this.spyAttributes.charAt(this.spyAttributes.length() - 1) == ')') {
                this.spyAttributes = this.spyAttributes.substring(0, this.spyAttributes.length() - 1);
            }
        }
    }

    public void setMaxStatements(int n2) {
        this.maxPooledStatements = new Integer(n2);
    }

    public void setMaxPooledStatements(int n2) {
        this.maxPooledStatements = new Integer(n2);
    }

    public int getMaxStatements() {
        if (this.maxPooledStatements != null) {
            return this.maxPooledStatements;
        }
        return 0;
    }

    public int getMaxPooledStatements() {
        if (this.maxPooledStatements != null) {
            return this.maxPooledStatements;
        }
        return 0;
    }

    public void setInitialPoolSize(int n2) {
        this.initialPoolSize = new Integer(n2);
    }

    public int getInitialPoolSize() {
        if (this.initialPoolSize != null) {
            return this.initialPoolSize;
        }
        return 0;
    }

    public void setMinPoolSize(int n2) {
        this.minPoolSize = new Integer(n2);
    }

    public int getMinPoolSize() {
        if (this.minPoolSize != null) {
            return this.minPoolSize;
        }
        return 0;
    }

    public void setMaxPoolSize(int n2) {
        this.maxPoolSize = new Integer(n2);
    }

    public int getMaxPoolSize() {
        if (this.maxPoolSize != null) {
            return this.maxPoolSize;
        }
        return 0;
    }

    public void setMaxIdleTime(int n2) {
        this.maxIdleTime = new Integer(n2);
    }

    public int getMaxIdleTime() {
        if (this.maxIdleTime != null) {
            return this.maxIdleTime;
        }
        return 0;
    }

    public void setPropertyCycle(int n2) {
        this.propertyCycle = new Integer(n2);
    }

    public int getPropertyCycle() {
        if (this.propertyCycle != null) {
            return this.propertyCycle;
        }
        return 0;
    }

    public void setInsensitiveResultSetBufferSize(int n2) {
        this.insensitiveResultSetBufferSize = new Integer(n2);
    }

    public int getInsensitiveResultSetBufferSize() {
        if (this.insensitiveResultSetBufferSize != null) {
            return this.insensitiveResultSetBufferSize;
        }
        return 2048;
    }

    public final String getAlternateServers() {
        return this.alternateServers;
    }

    public final void setAlternateServers(String string) {
        this.alternateServers = string;
    }

    public final void setConnectionRetryCount(int n2) {
        this.connectionRetryCount = new Integer(n2);
    }

    public final int getConnectionRetryCount() {
        if (this.connectionRetryCount != null) {
            return this.connectionRetryCount;
        }
        return 5;
    }

    public final void setConnectionRetryDelay(int n2) {
        this.connectionRetryDelay = new Integer(n2);
    }

    public final int getConnectionRetryDelay() {
        if (this.connectionRetryDelay != null) {
            return this.connectionRetryDelay;
        }
        return 1;
    }

    public final void setLoadBalancing(boolean bl2) {
        this.loadBalancing = new Boolean(bl2);
    }

    public final boolean getLoadBalancing() {
        if (this.loadBalancing != null) {
            return this.loadBalancing;
        }
        return false;
    }

    public final void setJavaDoubleToString(boolean bl2) {
        this.javaDoubleToString = new Boolean(bl2);
    }

    public final boolean getJavaDoubleToString() {
        if (this.javaDoubleToString != null) {
            return this.javaDoubleToString;
        }
        return false;
    }

    public final void setEnableBulkLoad(boolean bl2) {
        this.enableBulkLoad = bl2;
    }

    public final boolean getEnableBulkLoad() {
        if (this.enableBulkLoad != null) {
            return this.enableBulkLoad;
        }
        return false;
    }

    public int getBulkLoadBatchSize() {
        if (this.bulkLoadBatchSize != null) {
            return this.bulkLoadBatchSize;
        }
        return 0;
    }

    public final void setBulkLoadBatchSize(int n2) {
        if (n2 > 0) {
            this.bulkLoadBatchSize = n2;
        }
    }

    public final void setJDBCBehavior(int n2) {
        double d2 = as.ac();
        if (d2 >= 1.6) {
            this.jdbcBehavior = n2;
        }
    }

    public final int getJDBCBehavior() {
        if (this.jdbcBehavior != null) {
            return this.jdbcBehavior;
        }
        return 1;
    }

    public final void setResultsetMetaDataOptions(int n2) {
        this.resultsetMetaDataOptions = n2;
    }

    public final int getResultsetMetaDataOptions() {
        if (this.resultsetMetaDataOptions != null) {
            return this.resultsetMetaDataOptions;
        }
        return 0;
    }

    public final String getInitializationString() {
        return this.initializationString;
    }

    public final void setInitializationString(String string) {
        this.initializationString = string;
    }

    public final String getLoadLibraryPath() {
        return this.loadLibraryPath;
    }

    public final void setLoadLibraryPath(String string) {
        this.loadLibraryPath = string;
    }

    public final void setClientAppName(String string) {
        this.clientAppName = string;
    }

    public final void setApplicationName(String string) {
        this.clientAppName = string;
    }

    public final String getClientAppName() {
        return this.clientAppName;
    }

    public final String getApplicationName() {
        return this.clientAppName;
    }

    public final void setClientHostName(String string) {
        this.clientHostName = string;
    }

    public final String getClientHostName() {
        return this.clientHostName;
    }

    public final void setClientUser(String string) {
        this.clientUser = string;
    }

    public final String getClientUser() {
        return this.clientUser;
    }

    public final void setClientAcctInfo(String string) {
        this.clientAcctInfo = string;
    }

    public final void setAccountingInfo(String string) {
        this.clientAcctInfo = string;
    }

    public final String getClientAcctInfo() {
        return this.clientAcctInfo;
    }

    public final String getAccountingInfo() {
        return this.clientAcctInfo;
    }

    public final void setClientProgramID(String string) {
        this.clientProgramID = string;
    }

    public final void setProgramID(String string) {
        this.clientProgramID = string;
    }

    public final String getClientProgramID() {
        return this.clientProgramID;
    }

    public final String getProgramID() {
        return this.clientProgramID;
    }

    public final int getWorkarounds() {
        if (this.workarounds != null) {
            return this.workarounds;
        }
        return 0;
    }

    public final void setWorkarounds(int n2) {
        this.workarounds = new Integer(n2);
    }

    public int getConvertNull() {
        if (this.convertNull != null) {
            return this.convertNull;
        }
        return 1;
    }

    public void setConvertNull(boolean bl2) {
        this.convertNull = bl2 ? 1 : 0;
    }

    public void setConvertNull(int n2) {
        this.convertNull = n2;
    }

    public final String getFailoverMode() {
        return this.failoverMode;
    }

    public final void setFailoverMode(String string) {
        this.failoverMode = string;
    }

    public final String getFailoverGranularity() {
        return this.failoverGranularity;
    }

    public final void setFailoverGranularity(String string) {
        this.failoverGranularity = string;
    }

    public final boolean getFailoverPreconnect() {
        if (this.failoverPreconnect != null) {
            return this.failoverPreconnect;
        }
        return false;
    }

    public final void setFailoverPreconnect(boolean bl2) {
        this.failoverPreconnect = new Boolean(bl2);
    }

    public final String getCryptoProtocolVersion() {
        return this.cryptoProtocolVersion;
    }

    public final void setCryptoProtocolVersion(String string) {
        this.cryptoProtocolVersion = string;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public void setServicePrincipalName(String string) {
        this.servicePrincipalName = string;
    }

    public String getLoginConfigName() {
        return this.loginConfigName;
    }

    public void setLoginConfigName(String string) {
        this.loginConfigName = string;
    }

    public Object getGSSCredentials() {
        return this.gssCredentials;
    }

    public void setGSSCredentials(Object object) {
        this.gssCredentials = object;
    }

    public void setHostNameInCertificate(String string) {
        this.hostNameInCertificate = string;
    }

    public String getHostNameInCertificate() {
        return this.hostNameInCertificate;
    }

    public void setIsTLSTunnel(boolean bl2) {
        this.isTLSTunnel = bl2;
    }

    public boolean getIsTLSTunnel() {
        return this.isTLSTunnel;
    }

    public void setKeyPassword(String string) {
        this.keyPassword = string;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystorePassword(String string) {
        this.keystorePassword = string;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setTruststore(String string) {
        this.truststore = string;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststorePassword(String string) {
        this.truststorePassword = string;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(int n2) {
        this.proxyPort = n2;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUser(String string) {
        this.proxyUser = string;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setUseSystemProxyOptions(boolean bl2) {
        this.useSystemProxyOptions = bl2;
    }

    public boolean getUseSystemProxyOptions() {
        return this.useSystemProxyOptions;
    }

    public void setValidateIsClosed(boolean bl2) {
        this.validateIsClosed = bl2;
    }

    public boolean getValidateIsClosed() {
        return this.validateIsClosed;
    }

    public void setValidateServerCertificate(boolean bl2) {
        this.validateServerCertificate = bl2;
    }

    public boolean getValidateServerCertificate() {
        return this.validateServerCertificate;
    }

    protected BaseConnection getBaseConnection() throws SQLException {
        BaseExceptions baseExceptions = this.setupExceptionHandling();
        BaseConnection baseConnection = b.b(this);
        BaseDriverPropertyInfos baseDriverPropertyInfos = baseConnection.T();
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseDriverPropertyInfos, baseConnection, baseExceptions);
        this.debug = BaseDriver.a(baseConnectionProperties);
        baseConnectionProperties.a(baseDriverPropertyInfos, baseExceptions);
        baseConnection.a(baseConnectionProperties, baseExceptions, this.debug);
        return baseConnection;
    }

    protected BaseConnection getBaseConnection(String string, String string2) throws SQLException {
        BaseExceptions baseExceptions = this.setupExceptionHandling();
        BaseConnection baseConnection = b.b(this);
        BaseDriverPropertyInfos baseDriverPropertyInfos = baseConnection.T();
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseDriverPropertyInfos, baseConnection, baseExceptions);
        if (string != null) {
            baseConnectionProperties.b(string.toCharArray());
        }
        if (string2 != null) {
            baseConnectionProperties.setPassword(string2.toCharArray());
        }
        this.debug = BaseDriver.a(baseConnectionProperties);
        baseConnectionProperties.a(baseDriverPropertyInfos, baseExceptions);
        baseConnection.a(baseConnectionProperties, baseExceptions, this.debug);
        return baseConnection;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        BaseConnection baseConnection;
        this.initializeLogging();
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection()");
        }
        try {
            baseConnection = this.getBaseConnection();
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    @Override
    public final Connection getConnection(String string, String string2) throws SQLException {
        BaseConnection baseConnection;
        this.initializeLogging();
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            baseConnection = this.getBaseConnection(string, string2);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    protected void initializeLogging() {
        if (this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
    }

    public final String getAuthenticatedUser() throws SQLException {
        String string = null;
        if (this.encryptedUser != null) {
            string = new String(BaseConnectionProperties.b(this.encryptedUser, this.getRandomGenerator(), this.getSecureRandomAlgorithm()));
        }
        return this.getAuthenticatedUser(string);
    }

    public String getAuthenticatedUser(String string) throws SQLException {
        return "";
    }

    @Override
    public final PooledConnection getPooledConnection() throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        this.initializeLogging();
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection()");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection();
            basePooledConnection = basePooledConnection2 = s.aA.b((BaseConnection)object);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    @Override
    public final PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        this.initializeLogging();
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection(string, string2);
            basePooledConnection = basePooledConnection2 = s.aA.b((BaseConnection)object);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    @Override
    public final PrintWriter getLogWriter() throws SQLException {
        this.setupExceptionHandling();
        return this.printWriter;
    }

    @Override
    public final void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.setupExceptionHandling();
        this.printWriter = printWriter;
        this.spyLogger = printWriter == null ? null : BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
    }

    @Override
    public final Reference getReference() throws NamingException {
        String string = b.a(this);
        String string2 = "macromedia.jdbcx." + string.toLowerCase() + "." + string + "DataSource";
        Reference reference = new Reference(string2, string2 + "Factory", null);
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName != null) {
            reference.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.encryptedPassword != null) {
            reference.add(new StringRefAddr("password", this.getPassword()));
        }
        if (this.portNumber != null) {
            reference.add(new StringRefAddr("portNumber", this.portNumber));
        }
        if (this.roleName != null) {
            reference.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.importStatementPool != null) {
            reference.add(new StringRefAddr("importStatementPool", this.importStatementPool));
        }
        if (this.encryptedUser != null) {
            reference.add(new StringRefAddr("user", this.getUser()));
        }
        if (this.loginTimeout != null) {
            reference.add(new StringRefAddr("loginTimeout", this.loginTimeout.toString()));
        }
        if (this.spyAttributes != null) {
            reference.add(new StringRefAddr("spyAttributes", this.spyAttributes));
        }
        if (this.alternateServers != null) {
            reference.add(new StringRefAddr("alternateServers", this.alternateServers));
        }
        if (this.resultsetMetaDataOptions != null) {
            reference.add(new StringRefAddr("resultsetMetaDataOptions", this.resultsetMetaDataOptions.toString()));
        }
        if (this.initializationString != null) {
            reference.add(new StringRefAddr("initializationString", this.initializationString));
        }
        if (this.loadLibraryPath != null) {
            reference.add(new StringRefAddr("loadLibraryPath", this.loadLibraryPath));
        }
        if (this.clientAppName != null) {
            reference.add(new StringRefAddr("applicationName", this.clientAppName));
        }
        if (this.clientHostName != null) {
            reference.add(new StringRefAddr("clientHostName", this.clientHostName));
        }
        if (this.clientUser != null) {
            reference.add(new StringRefAddr("clientUser", this.clientUser));
        }
        if (this.clientAcctInfo != null) {
            reference.add(new StringRefAddr("accountingInfo", this.clientAcctInfo));
        }
        if (this.clientProgramID != null) {
            reference.add(new StringRefAddr("programID", this.clientProgramID));
        }
        if (this.workarounds != null) {
            reference.add(new StringRefAddr("workarounds", this.workarounds.toString()));
        }
        if (this.connectionRetryCount != null) {
            reference.add(new StringRefAddr("connectionRetryCount", this.connectionRetryCount.toString()));
        }
        if (this.connectionRetryDelay != null) {
            reference.add(new StringRefAddr("connectionRetryDelay", this.connectionRetryDelay.toString()));
        }
        if (this.queryTimeout != null) {
            reference.add(new StringRefAddr("queryTimeout", this.queryTimeout.toString()));
        }
        if (this.loadBalancing != null) {
            reference.add(new StringRefAddr("loadBalancing", this.loadBalancing.toString()));
        }
        if (this.javaDoubleToString != null) {
            reference.add(new StringRefAddr("JavaDoubleToString", this.javaDoubleToString.toString()));
        }
        if (this.enableBulkLoad != null) {
            reference.add(new StringRefAddr("enableBulkLoad", this.enableBulkLoad.toString()));
        }
        if (this.bulkLoadBatchSize != null) {
            reference.add(new StringRefAddr("bulkLoadBatchSize", this.bulkLoadBatchSize.toString()));
        }
        if (this.jdbcBehavior != null) {
            reference.add(new StringRefAddr("JDBCBehavior", this.jdbcBehavior.toString()));
        }
        if (this.maxPooledStatements != null) {
            reference.add(new StringRefAddr("maxPooledStatements", this.maxPooledStatements.toString()));
        }
        if (this.initialPoolSize != null) {
            reference.add(new StringRefAddr("initialPoolSize", this.initialPoolSize.toString()));
        }
        if (this.minPoolSize != null) {
            reference.add(new StringRefAddr("minPoolSize", this.minPoolSize.toString()));
        }
        if (this.maxPoolSize != null) {
            reference.add(new StringRefAddr("maxPoolSize", this.maxPoolSize.toString()));
        }
        if (this.maxIdleTime != null) {
            reference.add(new StringRefAddr("maxIdleTime", this.maxIdleTime.toString()));
        }
        if (this.propertyCycle != null) {
            reference.add(new StringRefAddr("propertyCycle", this.propertyCycle.toString()));
        }
        if (this.insensitiveResultSetBufferSize != null) {
            reference.add(new StringRefAddr("insensitiveResultSetBufferSize", this.insensitiveResultSetBufferSize.toString()));
        }
        if (this.convertNull != null) {
            reference.add(new StringRefAddr("convertNull", this.convertNull.toString()));
        }
        if (this.extendedOptions != null) {
            reference.add(new StringRefAddr("extendedOptions", this.extendedOptions));
        }
        if (this.catalogOptions != null) {
            reference.add(new StringRefAddr("catalogOptions", this.catalogOptions.toString()));
            reference.add(new StringRefAddr("CatalogIncludesSynonyms", "false"));
        }
        BaseConnection baseConnection = b.b(this);
        if (this.batchPerformanceWorkaround != null) {
            reference.add(new StringRefAddr("batchPerformanceWorkaround", this.batchPerformanceWorkaround.toString()));
        }
        if (this.registerStatementPoolMonitorMBean != null) {
            reference.add(new StringRefAddr("registerStatementPoolMonitorMBean", this.registerStatementPoolMonitorMBean.toString()));
        }
        if (this.failoverMode != null) {
            reference.add(new StringRefAddr("failoverMode", this.failoverMode));
        }
        if (this.failoverGranularity != null) {
            reference.add(new StringRefAddr("failoverGranularity", this.failoverGranularity));
        }
        if (this.failoverPreconnect != null) {
            reference.add(new StringRefAddr("failoverPreconnect", this.failoverPreconnect.toString()));
        }
        if (this.cryptoProtocolVersion != null) {
            reference.add(new StringRefAddr("cryptoProtocolVersion", this.cryptoProtocolVersion));
        }
        if (this.servicePrincipalName != null) {
            reference.add(new StringRefAddr("servicePrincipalName", this.servicePrincipalName));
        }
        if (this.loginConfigName != null && !this.loginConfigName.equalsIgnoreCase("JDBC_DRIVER_01")) {
            reference.add(new StringRefAddr("loginConfigName", this.loginConfigName));
        }
        if (this.randomGenerator != null) {
            reference.add(new StringRefAddr("randomGenerator", this.randomGenerator));
        }
        if (this.secureRandomAlgorithm != null) {
            reference.add(new StringRefAddr("secureRandomAlgorithm", this.secureRandomAlgorithm));
        }
        if (this.hostNameInCertificate != null) {
            reference.add(new StringRefAddr("hostNameInCertificate", this.hostNameInCertificate));
        }
        if (this.isTLSTunnel != null) {
            reference.add(new StringRefAddr("isTLSTunnel", this.isTLSTunnel.toString()));
        }
        if (this.keyPassword != null) {
            reference.add(new StringRefAddr("keyPassword", this.keyPassword));
        }
        if (this.keystore != null) {
            reference.add(new StringRefAddr("keystore", this.keystore));
        }
        if (this.keystorePassword != null) {
            reference.add(new StringRefAddr("keystorePassword", this.keystorePassword));
        }
        if (this.truststore != null) {
            reference.add(new StringRefAddr("truststore", this.truststore));
        }
        if (this.truststorePassword != null) {
            reference.add(new StringRefAddr("truststorePassword", this.truststorePassword));
        }
        if (this.proxyHost != null) {
            reference.add(new StringRefAddr("proxyHost", this.proxyHost.toString()));
        }
        if (this.proxyPort != null) {
            reference.add(new StringRefAddr("proxyPort", this.proxyPort.toString()));
        }
        if (this.proxyUser != null) {
            reference.add(new StringRefAddr("proxyUser", this.proxyUser.toString()));
        }
        if (this.proxyPassword != null) {
            reference.add(new StringRefAddr("proxyPassword", this.proxyPassword.toString()));
        }
        if (this.useSystemProxyOptions != null) {
            reference.add(new StringRefAddr("useSystemProxyOptions", this.useSystemProxyOptions.toString()));
        }
        if (this.validateIsClosed != null) {
            reference.add(new StringRefAddr("validateIsClosed", this.validateIsClosed.toString()));
        }
        if (this.validateServerCertificate != null) {
            reference.add(new StringRefAddr("validateServerCertificate", this.validateServerCertificate.toString()));
        }
        this.implAddProperties(reference);
        return reference;
    }

    protected static final void upsertReference(Reference reference, String string, String string2) {
        int n2 = reference.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RefAddr refAddr = reference.get(i2);
            if (!refAddr.getType().equalsIgnoreCase(string)) continue;
            if (string2 == refAddr.getContent()) {
                return;
            }
            if (string2 == null || !string2.equals(refAddr.getContent())) {
                reference.remove(i2);
                reference.add(i2, new StringRefAddr(string, string2));
            }
            return;
        }
        reference.add(new StringRefAddr(string, string2));
    }

    protected void implAddProperties(Reference reference) {
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        return null;
    }

    protected synchronized BaseExceptions setupExceptionHandling() throws SQLException {
        if (this.exceptions == null) {
            this.exceptions = s.aA.b(b.a(this));
            return this.exceptions;
        }
        return s.aA.a(this.exceptions.cA(), this.exceptions.cB());
    }

    protected BaseConnectionProperties getConnectionProperties(BaseDriverPropertyInfos baseDriverPropertyInfos, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        String string;
        BaseConnectionProperties baseConnectionProperties = new BaseConnectionProperties();
        String string2 = b.a(this);
        String string3 = "jdbc:macromedia_direct:" + string2 + ":";
        if (this.serverName == null) {
            if (this.portNumber != null) {
                throw baseExceptions.aw(6101);
            }
        } else {
            string3 = string3 + "//" + this.serverName;
            if (this.portNumber != null) {
                string3 = string3 + ":" + this.portNumber;
            }
        }
        if (this.encryptedUser != null) {
            string3 = string3 + ";user=" + this.getUser();
        }
        if (this.encryptedPassword != null) {
            string3 = string3 + ";password=" + this.getPassword();
        }
        if (this.databaseName != null) {
            string3 = string3 + ";databaseName=" + this.databaseName;
        }
        if (this.loginTimeout != null) {
            string3 = string3 + ";loginTimeout=" + this.loginTimeout.toString();
        }
        if (this.maxPooledStatements != null) {
            string3 = string3 + ";maxPooledStatements=" + this.maxPooledStatements.toString();
        }
        if (this.importStatementPool != null) {
            string3 = string3 + ";importStatementPool=" + this.importStatementPool;
        }
        if (this.alternateServers != null) {
            string3 = string3 + ";alternateServers=" + this.alternateServers;
        }
        if (this.batchPerformanceWorkaround != null) {
            string3 = string3 + ";batchPerformanceWorkaround=" + this.batchPerformanceWorkaround.toString();
        }
        if (this.registerStatementPoolMonitorMBean != null) {
            string3 = string3 + ";registerStatementPoolMonitorMBean=" + this.registerStatementPoolMonitorMBean.toString();
        }
        if (this.insensitiveResultSetBufferSize != null) {
            string3 = string3 + ";insensitiveResultSetBufferSize=" + this.insensitiveResultSetBufferSize.toString();
        }
        if (this.connectionRetryCount != null) {
            string3 = string3 + ";connectionRetryCount=" + this.connectionRetryCount.toString();
        }
        if (this.connectionRetryDelay != null) {
            string3 = string3 + ";connectionRetryDelay=" + this.connectionRetryDelay.toString();
        }
        if (this.loadBalancing != null) {
            string3 = string3 + ";loadBalancing=" + this.loadBalancing.toString();
        }
        if (this.javaDoubleToString != null) {
            string3 = string3 + ";JavaDoubleToString=" + this.javaDoubleToString.toString();
        }
        if (this.enableBulkLoad != null) {
            string3 = string3 + ";enableBulkLoad=" + this.enableBulkLoad.toString();
        }
        if (this.bulkLoadBatchSize != null) {
            string3 = string3 + ";bulkLoadBatchSize=" + this.bulkLoadBatchSize.toString();
        }
        if (this.jdbcBehavior != null) {
            string3 = string3 + ";JDBCBehavior=" + this.jdbcBehavior.toString();
        }
        if (this.resultsetMetaDataOptions != null) {
            string3 = string3 + ";resultsetMetaDataOptions=" + this.resultsetMetaDataOptions.toString();
        }
        if (this.convertNull != null) {
            string3 = string3 + ";convertNull=" + this.convertNull.toString();
        }
        if (this.queryTimeout != null) {
            string3 = string3 + ";queryTimeout=" + this.queryTimeout.toString();
        }
        if (this.initializationString != null) {
            string3 = string3 + ";initializationString=(" + this.initializationString + ")";
        }
        if (this.loadLibraryPath != null) {
            string3 = string3 + ";loadLibraryPath=" + this.loadLibraryPath;
        }
        if (this.clientAppName != null) {
            string3 = string3 + ";applicationName=" + this.clientAppName;
        }
        if (this.clientHostName != null) {
            string3 = string3 + ";clientHostName=" + this.clientHostName;
        }
        if (this.clientUser != null) {
            string3 = string3 + ";clientUser=" + this.clientUser;
        }
        if (this.clientAcctInfo != null) {
            string3 = string3 + ";accountingInfo=" + this.clientAcctInfo;
        }
        if (this.clientProgramID != null) {
            string3 = string3 + ";programID=" + this.clientProgramID;
        }
        if (this.workarounds != null) {
            string3 = string3 + ";workarounds=" + this.workarounds.toString();
        }
        if (this.extendedOptions != null) {
            string3 = string3 + ";" + this.extendedOptions;
        }
        if (this.catalogOptions != null) {
            string3 = string3 + ";catalogOptions=" + this.catalogOptions;
        }
        if (this.failoverMode != null) {
            string3 = string3 + ";failoverMode=" + this.failoverMode;
        }
        if (this.failoverGranularity != null) {
            string3 = string3 + ";failoverGranularity=" + this.failoverGranularity;
        }
        if (this.failoverPreconnect != null) {
            string3 = string3 + ";failoverPreconnect=" + this.failoverPreconnect.toString();
        }
        if (this.cryptoProtocolVersion != null) {
            string3 = string3 + ";cryptoProtocolVersion=" + this.cryptoProtocolVersion;
        }
        if (this.servicePrincipalName != null) {
            string3 = string3 + ";servicePrincipalName=" + this.servicePrincipalName;
        }
        if (this.loginConfigName != null && !this.loginConfigName.equalsIgnoreCase("JDBC_DRIVER_01")) {
            string3 = string3 + ";loginConfigName=" + this.loginConfigName;
        }
        if (this.gssCredentials != null) {
            baseConnectionProperties.put((Object)"GSSCREDENTIAL", this.getGSSCredentials());
        }
        if (this.randomGenerator != null) {
            string3 = string3 + ";randomGenerator=" + this.randomGenerator;
        }
        if (this.secureRandomAlgorithm != null) {
            string3 = string3 + ";secureRandomAlgorithm=" + this.secureRandomAlgorithm;
        }
        if (this.hostNameInCertificate != null) {
            string3 = string3 + ";hostNameInCertificate=" + this.hostNameInCertificate;
        }
        if (this.isTLSTunnel != null) {
            string3 = string3 + ";isTLSTunnel=" + this.isTLSTunnel;
        }
        if (this.keyPassword != null) {
            string3 = string3 + ";keyPassword=" + this.keyPassword;
        }
        if (this.keystore != null) {
            string3 = string3 + ";keystore=" + this.keystore;
        }
        if (this.keystorePassword != null) {
            string3 = string3 + ";keystorePassword=" + this.keystorePassword;
        }
        if (this.truststore != null) {
            string3 = string3 + ";truststore=" + this.truststore;
        }
        if (this.truststorePassword != null) {
            string3 = string3 + ";truststorePassword=" + this.truststorePassword;
        }
        if (this.proxyHost != null) {
            string3 = string3 + ";proxyHost=" + this.proxyHost;
        }
        if (this.proxyPort != null) {
            string3 = string3 + ";proxyPort=" + this.proxyPort;
        }
        if (this.proxyUser != null) {
            string3 = string3 + ";proxyUser=" + this.proxyUser;
        }
        if (this.proxyPassword != null) {
            string3 = string3 + ";proxyPassword=" + this.proxyPassword;
        }
        if (this.useSystemProxyOptions != null) {
            string3 = string3 + ";useSystemProxyOptions=" + this.useSystemProxyOptions;
        }
        if (this.validateIsClosed != null) {
            string3 = string3 + ";validateIsClosed=" + this.validateIsClosed;
        }
        if (this.validateServerCertificate != null) {
            string3 = string3 + ";validateServerCertificate=" + this.validateServerCertificate;
        }
        if ((string = this.implGetPropertyNameValuePairs()) != null) {
            string3 = string3 + ";" + string;
        }
        BaseURLParser baseURLParser = s.e(string2);
        baseURLParser.a(string2, string3, baseConnectionProperties);
        baseConnection.bM.modifyUserSpecifiedConnectProperties(baseConnectionProperties, baseConnection, baseExceptions);
        baseConnectionProperties.a(baseDriverPropertyInfos);
        return baseConnectionProperties;
    }

    private String getBooleanString(boolean bl2) {
        return bl2 ? "true" : "false";
    }

    public String getRandomGenerator() {
        return this.randomGenerator;
    }

    public void setRandomGenerator(String string) {
        this.randomGenerator = string;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String string) {
        this.secureRandomAlgorithm = string;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return hb.a(clazz, this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t2 = hb.b(clazz, this);
        if (t2 == null) {
            throw new SQLException("Cannot unwrap object to class " + clazz.getCanonicalName(), "HY000");
        }
        return t2;
    }
}

