/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.slf4j_1_7_5;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import macromedia.externals.org.slf4j_1_7_5.ILoggerFactory;
import macromedia.externals.org.slf4j_1_7_5.Logger;
import macromedia.externals.org.slf4j_1_7_5.helpers.NOPLoggerFactory;
import macromedia.externals.org.slf4j_1_7_5.helpers.SubstituteLoggerFactory;
import macromedia.externals.org.slf4j_1_7_5.helpers.Util;
import macromedia.externals.org.slf4j_1_7_5.impl.StaticLoggerBinder;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LoggerFactory {
    static final String CODES_PREFIX = "http://www.slf4j.org/codes.html";
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String MULTIPLE_BINDINGS_URL = "http://www.slf4j.org/codes.html#multiple_bindings";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
    static final String VERSION_MISMATCH = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "http://www.slf4j.org/codes.html#substituteLogger";
    static final String UNSUCCESSFUL_INIT_URL = "http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String UNSUCCESSFUL_INIT_MSG = "org.slf4j.LoggerFactory could not be successfully initialized. See also http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final int UNINITIALIZED = 0;
    static final int ONGOING_INITIALIZATION = 1;
    static final int FAILED_INITIALIZATION = 2;
    static final int SUCCESSFUL_INITIALIZATION = 3;
    static final int NOP_FALLBACK_INITIALIZATION = 4;
    static int INITIALIZATION_STATE = 0;
    static SubstituteLoggerFactory TEMP_FACTORY = new SubstituteLoggerFactory();
    static NOPLoggerFactory NOP_FALLBACK_FACTORY = new NOPLoggerFactory();
    private static final String[] API_COMPATIBILITY_LIST = new String[]{"1.6", "1.7"};
    private static String STATIC_LOGGER_BINDER_PATH = "macromedia/externals/org/slf4j_1_7_5/impl/StaticLoggerBinder.class";

    private LoggerFactory() {
    }

    static void reset() {
        INITIALIZATION_STATE = 0;
        TEMP_FACTORY = new SubstituteLoggerFactory();
    }

    private static final void performInitialization() {
        LoggerFactory.bind();
        if (INITIALIZATION_STATE == 3) {
            LoggerFactory.versionSanityCheck();
        }
    }

    private static boolean messageContainsOrgSlf4jImplStaticLoggerBinder(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("macromedia/externals/org/slf4j_1_7_5/impl/StaticLoggerBinder") != -1) {
            return true;
        }
        return string.indexOf("macromedia.externals.org.slf4j_1_7_5.impl.StaticLoggerBinder") != -1;
    }

    private static final void bind() {
        try {
            Set set = LoggerFactory.findPossibleStaticLoggerBinderPathSet();
            LoggerFactory.reportMultipleBindingAmbiguity((Set)set);
            StaticLoggerBinder.getSingleton();
            INITIALIZATION_STATE = 3;
            LoggerFactory.reportActualBinding((Set)set);
            LoggerFactory.emitSubstituteLoggerWarning();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = noClassDefFoundError.getMessage();
            if (LoggerFactory.messageContainsOrgSlf4jImplStaticLoggerBinder((String)string)) {
                INITIALIZATION_STATE = 4;
                Util.report((String)"Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.report((String)"Defaulting to no-operation (NOP) logger implementation");
                Util.report((String)"See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            LoggerFactory.failedBinding((Throwable)noClassDefFoundError);
            throw noClassDefFoundError;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            String string = noSuchMethodError.getMessage();
            if (string != null && string.indexOf("macromedia.externals.org.slf4j_1_7_5.impl.StaticLoggerBinder.getSingleton()") != -1) {
                INITIALIZATION_STATE = 2;
                Util.report((String)"slf4j-api 1.6.x (or later) is incompatible with this binding.");
                Util.report((String)"Your binding is version 1.5.5 or earlier.");
                Util.report((String)"Upgrade your binding to version 1.6.x.");
            }
            throw noSuchMethodError;
        }
        catch (Exception exception) {
            LoggerFactory.failedBinding((Throwable)exception);
            throw new IllegalStateException("Unexpected initialization failure", exception);
        }
    }

    static void failedBinding(Throwable throwable) {
        INITIALIZATION_STATE = 2;
        Util.report((String)"Failed to instantiate SLF4J LoggerFactory", (Throwable)throwable);
    }

    private static final void emitSubstituteLoggerWarning() {
        List list = TEMP_FACTORY.getLoggerNameList();
        if (list.size() == 0) {
            return;
        }
        Util.report((String)"The following loggers will not work because they were created");
        Util.report((String)"during the default configuration phase of the underlying logging system.");
        Util.report((String)"See also http://www.slf4j.org/codes.html#substituteLogger");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            Util.report((String)string);
        }
    }

    private static final void versionSanityCheck() {
        try {
            String string = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean bl2 = false;
            for (int i2 = 0; i2 < API_COMPATIBILITY_LIST.length; ++i2) {
                if (!string.startsWith(API_COMPATIBILITY_LIST[i2])) continue;
                bl2 = true;
            }
            if (!bl2) {
                Util.report((String)("The requested version " + string + " by your slf4j binding is not compatible with " + Arrays.asList(API_COMPATIBILITY_LIST).toString()));
                Util.report((String)"See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
        }
        catch (Throwable throwable) {
            Util.report((String)"Unexpected problem occured during version sanity check", (Throwable)throwable);
        }
    }

    private static Set findPossibleStaticLoggerBinderPathSet() {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        try {
            ClassLoader classLoader = LoggerFactory.class.getClassLoader();
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER_PATH) : classLoader.getResources(STATIC_LOGGER_BINDER_PATH);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                linkedHashSet.add(uRL);
            }
        }
        catch (IOException iOException) {
            Util.report((String)"Error getting resources from path", (Throwable)iOException);
        }
        return linkedHashSet;
    }

    private static boolean isAmbiguousStaticLoggerBinderPathSet(Set set) {
        return set.size() > 1;
    }

    private static void reportMultipleBindingAmbiguity(Set set) {
        if (LoggerFactory.isAmbiguousStaticLoggerBinderPathSet((Set)set)) {
            Util.report((String)"Class path contains multiple SLF4J bindings.");
            for (URL uRL : set) {
                Util.report((String)("Found binding in [" + uRL + "]"));
            }
            Util.report((String)"See http://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    private static void reportActualBinding(Set set) {
        if (LoggerFactory.isAmbiguousStaticLoggerBinderPathSet((Set)set)) {
            Util.report((String)("Actual binding is of type [" + StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr() + "]"));
        }
    }

    public static Logger getLogger(String string) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger((String)clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        if (INITIALIZATION_STATE == 0) {
            INITIALIZATION_STATE = 1;
            LoggerFactory.performInitialization();
        }
        switch (INITIALIZATION_STATE) {
            case 3: {
                return StaticLoggerBinder.getSingleton().getLoggerFactory();
            }
            case 4: {
                return NOP_FALLBACK_FACTORY;
            }
            case 2: {
                throw new IllegalStateException("org.slf4j.LoggerFactory could not be successfully initialized. See also http://www.slf4j.org/codes.html#unsuccessfulInit");
            }
            case 1: {
                return TEMP_FACTORY;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }
}

