/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.x509;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Selector;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.ExtendedPKIXParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509CertStoreSelector;

public class ExtendedPKIXBuilderParameters
extends ExtendedPKIXParameters {
    private int maxPathLength = 5;
    private Set excludedCerts = Collections.EMPTY_SET;

    public Set getExcludedCerts() {
        return Collections.unmodifiableSet(this.excludedCerts);
    }

    public void setExcludedCerts(Set set) {
        if (set == null) {
            set = Collections.EMPTY_SET;
        } else {
            this.excludedCerts = new HashSet(set);
        }
    }

    public ExtendedPKIXBuilderParameters(Set set, Selector selector) throws InvalidAlgorithmParameterException {
        super(set);
        this.setTargetConstraints(selector);
    }

    public void setMaxPathLength(int n2) {
        if (n2 < -1) {
            throw new InvalidParameterException("The maximum path length parameter can not be less than -1.");
        }
        this.maxPathLength = n2;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    protected void setParams(PKIXParameters pKIXParameters) {
        Object object;
        super.setParams(pKIXParameters);
        if (pKIXParameters instanceof ExtendedPKIXBuilderParameters) {
            object = (ExtendedPKIXBuilderParameters)pKIXParameters;
            this.maxPathLength = ((ExtendedPKIXBuilderParameters)object).maxPathLength;
            this.excludedCerts = new HashSet(((ExtendedPKIXBuilderParameters)object).excludedCerts);
        }
        if (pKIXParameters instanceof PKIXBuilderParameters) {
            object = (PKIXBuilderParameters)pKIXParameters;
            this.maxPathLength = ((PKIXBuilderParameters)object).getMaxPathLength();
        }
    }

    public Object clone() {
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters = null;
        try {
            extendedPKIXBuilderParameters = new ExtendedPKIXBuilderParameters(this.getTrustAnchors(), this.getTargetConstraints());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        extendedPKIXBuilderParameters.setParams((PKIXParameters)this);
        return extendedPKIXBuilderParameters;
    }

    public static ExtendedPKIXParameters getInstance(PKIXParameters pKIXParameters) {
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters;
        try {
            extendedPKIXBuilderParameters = new ExtendedPKIXBuilderParameters(pKIXParameters.getTrustAnchors(), (Selector)X509CertStoreSelector.getInstance((X509CertSelector)((X509CertSelector)pKIXParameters.getTargetCertConstraints())));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        extendedPKIXBuilderParameters.setParams(pKIXParameters);
        return extendedPKIXBuilderParameters;
    }
}

