/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.x509;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Enumerated;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extension;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.IssuingDistributionPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.PolicyInformation;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXCertStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.x509.CertificateFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.exception.ExtCertPathValidatorException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.AnnotatedException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.PKIXPolicyNode;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Selector;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Store;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.StoreException;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.PKIXCRLUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509AttributeCertStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509AttributeCertificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509CertStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509Store;

/*
 * Exception performing whole class analysis ignored.
 */
class CertPathValidatorUtilities {
    protected static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    protected static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    protected static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    protected static final String KEY_USAGE = Extension.keyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    protected static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = Extension.cRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    CertPathValidatorUtilities() {
    }

    protected static X500Principal getEncodedIssuerPrincipal(Object object) {
        if (object instanceof X509Certificate) {
            return ((X509Certificate)object).getIssuerX500Principal();
        }
        return (X500Principal)((X509AttributeCertificate)object).getIssuer().getPrincipals()[0];
    }

    protected static Date getValidDate(PKIXParameters pKIXParameters) {
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    protected static X500Principal getSubjectPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal();
    }

    protected static boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    protected static ASN1Primitive getExtensionValue(X509Extension x509Extension, String string) throws AnnotatedException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return CertPathValidatorUtilities.getObject((String)string, (byte[])byArray);
    }

    private static ASN1Primitive getObject(String string, byte[] byArray) throws AnnotatedException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
            return aSN1InputStream.readObject();
        }
        catch (Exception exception) {
            throw new AnnotatedException("exception processing extension " + string, (Throwable)exception);
        }
    }

    protected static X500Principal getIssuerPrincipal(X509CRL x509CRL) {
        return x509CRL.getIssuerX500Principal();
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (Exception exception) {
            throw new ExtCertPathValidatorException("Subject public key cannot be decoded.", (Throwable)exception);
        }
    }

    protected static final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject((ASN1Encodable)enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new ExtCertPathValidatorException("Policy qualifier info cannot be decoded.", (Throwable)iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    protected static PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            for (int i2 = 0; i2 < listArray.length; ++i2) {
                listArray[i2] = new ArrayList();
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        CertPathValidatorUtilities.removePolicyNodeRecurse((List[])listArray, (PKIXPolicyNode)pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private static void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode pKIXPolicyNode) {
        listArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                CertPathValidatorUtilities.removePolicyNodeRecurse((List[])listArray, (PKIXPolicyNode)pKIXPolicyNode2);
            }
        }
    }

    protected static boolean processCertD1i(int n2, List[] listArray, ASN1ObjectIdentifier aSN1ObjectIdentifier, Set set) {
        List list = listArray[n2 - 1];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!set2.contains(aSN1ObjectIdentifier.getId())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(aSN1ObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n2, hashSet, (PolicyNode)pKIXPolicyNode, set, aSN1ObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n2].add(pKIXPolicyNode2);
            return true;
        }
        return false;
    }

    protected static void processCertD1ii(int n2, List[] listArray, ASN1ObjectIdentifier aSN1ObjectIdentifier, Set set) {
        List list = listArray[n2 - 1];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i2);
            if (!"2.5.29.32.0".equals(pKIXPolicyNode.getValidPolicy())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(aSN1ObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n2, hashSet, (PolicyNode)pKIXPolicyNode, set, aSN1ObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n2].add(pKIXPolicyNode2);
            return;
        }
    }

    protected static void prepareNextCertB1(int n2, List[] listArray, String string, Map map, X509Certificate x509Certificate) throws AnnotatedException, CertPathValidatorException {
        boolean bl2 = false;
        for (PKIXPolicyNode pKIXPolicyNode : listArray[n2]) {
            if (!pKIXPolicyNode.getValidPolicy().equals(string)) continue;
            bl2 = true;
            pKIXPolicyNode.setExpectedPolicies((Set)map.get(string));
            break;
        }
        if (!bl2) {
            for (PKIXPolicyNode pKIXPolicyNode : listArray[n2]) {
                PKIXPolicyNode pKIXPolicyNode2;
                if (!"2.5.29.32.0".equals(pKIXPolicyNode.getValidPolicy())) continue;
                Set set = null;
                ASN1Sequence aSN1Sequence = null;
                try {
                    aSN1Sequence = DERSequence.getInstance((Object)CertPathValidatorUtilities.getExtensionValue((X509Extension)x509Certificate, (String)CERTIFICATE_POLICIES));
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Certificate policies cannot be decoded.", (Throwable)exception);
                }
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    PolicyInformation policyInformation = null;
                    try {
                        policyInformation = PolicyInformation.getInstance(enumeration.nextElement());
                    }
                    catch (Exception exception) {
                        throw new AnnotatedException("Policy information cannot be decoded.", (Throwable)exception);
                    }
                    if (!"2.5.29.32.0".equals(policyInformation.getPolicyIdentifier().getId())) continue;
                    try {
                        set = CertPathValidatorUtilities.getQualifierSet((ASN1Sequence)policyInformation.getPolicyQualifiers());
                        break;
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        throw new ExtCertPathValidatorException("Policy qualifier info set could not be built.", (Throwable)certPathValidatorException);
                    }
                }
                boolean bl3 = false;
                if (x509Certificate.getCriticalExtensionOIDs() != null) {
                    bl3 = x509Certificate.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                }
                if (!"2.5.29.32.0".equals((pKIXPolicyNode2 = (PKIXPolicyNode)pKIXPolicyNode.getParent()).getValidPolicy())) break;
                PKIXPolicyNode pKIXPolicyNode3 = new PKIXPolicyNode(new ArrayList(), n2, (Set)map.get(string), (PolicyNode)pKIXPolicyNode2, set, string, bl3);
                pKIXPolicyNode2.addChild(pKIXPolicyNode3);
                listArray[n2].add(pKIXPolicyNode3);
                break;
            }
        }
    }

    protected static PKIXPolicyNode prepareNextCertB2(int n2, List[] listArray, String string, PKIXPolicyNode pKIXPolicyNode) {
        Iterator iterator = listArray[n2].iterator();
        while (iterator.hasNext()) {
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
            if (!pKIXPolicyNode2.getValidPolicy().equals(string)) continue;
            PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
            pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
            iterator.remove();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                PKIXPolicyNode pKIXPolicyNode4;
                List list = listArray[i2];
                for (int i3 = 0; i3 < list.size() && ((pKIXPolicyNode4 = (PKIXPolicyNode)list.get(i3)).hasChildren() || (pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode((PKIXPolicyNode)pKIXPolicyNode, (List[])listArray, (PKIXPolicyNode)pKIXPolicyNode4)) != null); ++i3) {
                }
            }
        }
        return pKIXPolicyNode;
    }

    protected static boolean isAnyPolicy(Set set) {
        return set == null || set.contains("2.5.29.32.0") || set.isEmpty();
    }

    protected static Collection findCertificates(X509CertStoreSelector x509CertStoreSelector, List list) throws AnnotatedException {
        HashSet<? extends Certificate> hashSet = new HashSet<Certificate>();
        Iterator iterator = list.iterator();
        CertificateFactory certificateFactory = new CertificateFactory();
        while (iterator.hasNext()) {
            Object object;
            Object e2 = iterator.next();
            if (e2 instanceof Store) {
                object = (Store)e2;
                try {
                    for (Object e3 : object.getMatches((Selector)x509CertStoreSelector)) {
                        if (e3 instanceof Encodable) {
                            hashSet.add(certificateFactory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(((Encodable)e3).getEncoded())));
                            continue;
                        }
                        if (e3 instanceof Certificate) {
                            hashSet.add((Certificate)e3);
                            continue;
                        }
                        throw new AnnotatedException("Unknown object found in certificate store.");
                    }
                    continue;
                }
                catch (StoreException storeException) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", (Throwable)storeException);
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("Problem while extracting certificates from X.509 store.", (Throwable)iOException);
                }
                catch (CertificateException certificateException) {
                    throw new AnnotatedException("Problem while extracting certificates from X.509 store.", (Throwable)certificateException);
                }
            }
            object = (CertStore)e2;
            try {
                hashSet.addAll(((CertStore)object).getCertificates((CertSelector)x509CertStoreSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", (Throwable)certStoreException);
            }
        }
        return hashSet;
    }

    protected static Collection findCertificates(PKIXCertStoreSelector pKIXCertStoreSelector, List list) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        for (Object e2 : list) {
            Object object;
            if (e2 instanceof Store) {
                object = (Store)e2;
                try {
                    hashSet.addAll(object.getMatches((Selector)pKIXCertStoreSelector));
                    continue;
                }
                catch (StoreException storeException) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", (Throwable)storeException);
                }
            }
            object = (CertStore)e2;
            try {
                hashSet.addAll(PKIXCertStoreSelector.getCertificates((PKIXCertStoreSelector)pKIXCertStoreSelector, (CertStore)object));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", (Throwable)certStoreException);
            }
        }
        return hashSet;
    }

    protected static Collection findCertificates(X509AttributeCertStoreSelector x509AttributeCertStoreSelector, List list) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        for (Object e2 : list) {
            if (!(e2 instanceof X509Store)) continue;
            X509Store x509Store = (X509Store)e2;
            try {
                hashSet.addAll(x509Store.getMatches((Selector)x509AttributeCertStoreSelector));
            }
            catch (StoreException storeException) {
                throw new AnnotatedException("Problem while picking certificates from X.509 store.", (Throwable)storeException);
            }
        }
        return hashSet;
    }

    private static BigInteger getSerialNumber(Object object) {
        if (object instanceof X509Certificate) {
            return ((X509Certificate)object).getSerialNumber();
        }
        return ((X509AttributeCertificate)object).getSerialNumber();
    }

    protected static void getCertStatus(Date date, X509CRL x509CRL, Object object, CertStatus certStatus) throws AnnotatedException {
        X500Principal x500Principal;
        boolean bl2;
        X509CRLEntry x509CRLEntry = null;
        try {
            bl2 = CertPathValidatorUtilities.isIndirectCRL((X509CRL)x509CRL);
        }
        catch (CRLException cRLException) {
            throw new AnnotatedException("Failed check for indirect CRL.", (Throwable)cRLException);
        }
        if (bl2) {
            x509CRLEntry = x509CRL.getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber((Object)object));
            if (x509CRLEntry == null) {
                return;
            }
            x500Principal = x509CRLEntry.getCertificateIssuer();
            if (x500Principal == null) {
                x500Principal = CertPathValidatorUtilities.getIssuerPrincipal((X509CRL)x509CRL);
            }
            if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal((Object)object).equals(x500Principal)) {
                return;
            }
        } else {
            if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal((Object)object).equals(CertPathValidatorUtilities.getIssuerPrincipal((X509CRL)x509CRL))) {
                return;
            }
            x509CRLEntry = x509CRL.getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber((Object)object));
            if (x509CRLEntry == null) {
                return;
            }
        }
        x500Principal = null;
        if (x509CRLEntry.hasExtensions()) {
            try {
                x500Principal = ASN1Enumerated.getInstance((Object)CertPathValidatorUtilities.getExtensionValue((X509Extension)x509CRLEntry, (String)macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Extension.reasonCode.getId()));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Reason code CRL entry extension could not be decoded.", (Throwable)exception);
            }
        }
        if (date.getTime() >= x509CRLEntry.getRevocationDate().getTime() || x500Principal == null || x500Principal.getValue().intValue() == 0 || x500Principal.getValue().intValue() == 1 || x500Principal.getValue().intValue() == 2 || x500Principal.getValue().intValue() == 8) {
            if (x500Principal != null) {
                certStatus.setCertStatus(x500Principal.getValue().intValue());
            } else {
                certStatus.setCertStatus(0);
            }
            certStatus.setRevocationDate(x509CRLEntry.getRevocationDate());
        }
    }

    protected static PublicKey getNextWorkingKey(List list, int n2) throws CertPathValidatorException {
        Certificate certificate = (Certificate)list.get(n2);
        PublicKey publicKey = certificate.getPublicKey();
        if (!(publicKey instanceof DSAPublicKey)) {
            return publicKey;
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        if (dSAPublicKey.getParams() != null) {
            return dSAPublicKey;
        }
        for (int i2 = n2 + 1; i2 < list.size(); ++i2) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i2);
            publicKey = x509Certificate.getPublicKey();
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)publicKey;
            if (dSAPublicKey2.getParams() == null) continue;
            DSAParams dSAParams = dSAPublicKey2.getParams();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA", "BC");
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    protected static void verifyX509Certificate(X509Certificate x509Certificate, PublicKey publicKey, String string) throws GeneralSecurityException {
        if (string == null) {
            x509Certificate.verify(publicKey);
        } else {
            x509Certificate.verify(publicKey, string);
        }
    }

    static boolean isIndirectCRL(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId());
            return byArray != null && IssuingDistributionPoint.getInstance((Object)ASN1OctetString.getInstance((Object)byArray).getOctets()).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint: " + exception);
        }
    }
}

