/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.BigIntPolynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.IntegerPolynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.TernaryPolynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.util.ArrayEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.util.Util;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class SparseTernaryPolynomial
implements TernaryPolynomial {
    private static final int BITS_PER_INDEX = 11;
    private int N;
    private int[] ones;
    private int[] negOnes;

    SparseTernaryPolynomial(int n2, int[] nArray, int[] nArray2) {
        this.N = n2;
        this.ones = nArray;
        this.negOnes = nArray2;
    }

    public SparseTernaryPolynomial(IntegerPolynomial integerPolynomial) {
        this(integerPolynomial.coeffs);
    }

    public SparseTernaryPolynomial(int[] nArray) {
        this.N = nArray.length;
        this.ones = new int[this.N];
        this.negOnes = new int[this.N];
        int n2 = 0;
        int n3 = 0;
        block5: for (int i2 = 0; i2 < this.N; ++i2) {
            int n4 = nArray[i2];
            switch (n4) {
                case 1: {
                    this.ones[n2++] = i2;
                    continue block5;
                }
                case -1: {
                    this.negOnes[n3++] = i2;
                    continue block5;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value: " + n4 + ", must be one of {-1, 0, 1}");
                }
            }
        }
        this.ones = Arrays.copyOf((int[])this.ones, (int)n2);
        this.negOnes = Arrays.copyOf((int[])this.negOnes, (int)n3);
    }

    public static SparseTernaryPolynomial fromBinary(InputStream inputStream, int n2, int n3, int n4) throws IOException {
        int n5 = 2048;
        int n6 = 32 - Integer.numberOfLeadingZeros(n5 - 1);
        int n7 = (n3 * n6 + 7) / 8;
        byte[] byArray = Util.readFullLength((InputStream)inputStream, (int)n7);
        int[] nArray = ArrayEncoder.decodeModQ((byte[])byArray, (int)n3, (int)n5);
        int n8 = (n4 * n6 + 7) / 8;
        byte[] byArray2 = Util.readFullLength((InputStream)inputStream, (int)n8);
        int[] nArray2 = ArrayEncoder.decodeModQ((byte[])byArray2, (int)n4, (int)n5);
        return new SparseTernaryPolynomial(n2, nArray, nArray2);
    }

    public static SparseTernaryPolynomial generateRandom(int n2, int n3, int n4, SecureRandom secureRandom) {
        int[] nArray = Util.generateRandomTernary((int)n2, (int)n3, (int)n4, (SecureRandom)secureRandom);
        return new SparseTernaryPolynomial(nArray);
    }

    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = integerPolynomial.coeffs;
        if (nArray.length != this.N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        int[] nArray2 = new int[this.N];
        for (n5 = 0; n5 != this.ones.length; ++n5) {
            n4 = this.ones[n5];
            n3 = this.N - 1 - n4;
            for (n2 = this.N - 1; n2 >= 0; --n2) {
                int n6 = n2;
                nArray2[n6] = nArray2[n6] + nArray[n3];
                if (--n3 >= 0) continue;
                n3 = this.N - 1;
            }
        }
        for (n5 = 0; n5 != this.negOnes.length; ++n5) {
            n4 = this.negOnes[n5];
            n3 = this.N - 1 - n4;
            for (n2 = this.N - 1; n2 >= 0; --n2) {
                int n7 = n2;
                nArray2[n7] = nArray2[n7] - nArray[n3];
                if (--n3 >= 0) continue;
                n3 = this.N - 1;
            }
        }
        return new IntegerPolynomial(nArray2);
    }

    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial, int n2) {
        IntegerPolynomial integerPolynomial2 = this.mult(integerPolynomial);
        integerPolynomial2.mod(n2);
        return integerPolynomial2;
    }

    public BigIntPolynomial mult(BigIntPolynomial bigIntPolynomial) {
        int n2;
        int n3;
        int n4;
        int n5;
        BigInteger[] bigIntegerArray = bigIntPolynomial.coeffs;
        if (bigIntegerArray.length != this.N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[this.N];
        for (n5 = 0; n5 < this.N; ++n5) {
            bigIntegerArray2[n5] = BigInteger.ZERO;
        }
        for (n5 = 0; n5 != this.ones.length; ++n5) {
            n4 = this.ones[n5];
            n3 = this.N - 1 - n4;
            for (n2 = this.N - 1; n2 >= 0; --n2) {
                bigIntegerArray2[n2] = bigIntegerArray2[n2].add(bigIntegerArray[n3]);
                if (--n3 >= 0) continue;
                n3 = this.N - 1;
            }
        }
        for (n5 = 0; n5 != this.negOnes.length; ++n5) {
            n4 = this.negOnes[n5];
            n3 = this.N - 1 - n4;
            for (n2 = this.N - 1; n2 >= 0; --n2) {
                bigIntegerArray2[n2] = bigIntegerArray2[n2].subtract(bigIntegerArray[n3]);
                if (--n3 >= 0) continue;
                n3 = this.N - 1;
            }
        }
        return new BigIntPolynomial(bigIntegerArray2);
    }

    public int[] getOnes() {
        return this.ones;
    }

    public int[] getNegOnes() {
        return this.negOnes;
    }

    public byte[] toBinary() {
        int n2 = 2048;
        byte[] byArray = ArrayEncoder.encodeModQ((int[])this.ones, (int)n2);
        byte[] byArray2 = ArrayEncoder.encodeModQ((int[])this.negOnes, (int)n2);
        byte[] byArray3 = Arrays.copyOf((byte[])byArray, (int)(byArray.length + byArray2.length));
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public IntegerPolynomial toIntegerPolynomial() {
        int n2;
        int n3;
        int[] nArray = new int[this.N];
        for (n3 = 0; n3 != this.ones.length; ++n3) {
            n2 = this.ones[n3];
            nArray[n2] = 1;
        }
        for (n3 = 0; n3 != this.negOnes.length; ++n3) {
            n2 = this.negOnes[n3];
            nArray[n2] = -1;
        }
        return new IntegerPolynomial(nArray);
    }

    public int size() {
        return this.N;
    }

    public void clear() {
        int n2;
        for (n2 = 0; n2 < this.ones.length; ++n2) {
            this.ones[n2] = 0;
        }
        for (n2 = 0; n2 < this.negOnes.length; ++n2) {
            this.negOnes[n2] = 0;
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.N;
        n3 = 31 * n3 + Arrays.hashCode((int[])this.negOnes);
        n3 = 31 * n3 + Arrays.hashCode((int[])this.ones);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SparseTernaryPolynomial sparseTernaryPolynomial = (SparseTernaryPolynomial)object;
        if (this.N != sparseTernaryPolynomial.N) {
            return false;
        }
        if (!Arrays.areEqual((int[])this.negOnes, (int[])sparseTernaryPolynomial.negOnes)) {
            return false;
        }
        return Arrays.areEqual((int[])this.ones, (int[])sparseTernaryPolynomial.ones);
    }
}

