/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.xmss;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.nist.NISTObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPair;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHA256Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHA512Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHAKEDigest;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.spec.XMSSMTParameterSpec;

public class XMSSMTKeyPairGeneratorSpi
extends KeyPairGenerator {
    private XMSSMTKeyGenerationParameters param;
    private XMSSMTKeyPairGenerator engine = new XMSSMTKeyPairGenerator();
    private ASN1ObjectIdentifier treeDigest;
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public XMSSMTKeyPairGeneratorSpi() {
        super("XMSSMT");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof XMSSMTParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a XMSSMTParameterSpec");
        }
        XMSSMTParameterSpec xMSSMTParameterSpec = (XMSSMTParameterSpec)algorithmParameterSpec;
        if (xMSSMTParameterSpec.getTreeDigest().equals("SHA256")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha256;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), (Digest)new SHA256Digest()), secureRandom);
        } else if (xMSSMTParameterSpec.getTreeDigest().equals("SHA512")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha512;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), (Digest)new SHA512Digest()), secureRandom);
        } else if (xMSSMTParameterSpec.getTreeDigest().equals("SHAKE128")) {
            this.treeDigest = NISTObjectIdentifiers.id_shake128;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), (Digest)new SHAKEDigest(128)), secureRandom);
        } else if (xMSSMTParameterSpec.getTreeDigest().equals("SHAKE256")) {
            this.treeDigest = NISTObjectIdentifiers.id_shake256;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), (Digest)new SHAKEDigest(256)), secureRandom);
        }
        this.engine.init((KeyGenerationParameters)this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(10, 20, (Digest)new SHA512Digest()), this.random);
            this.engine.init((KeyGenerationParameters)this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = (XMSSMTPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = (XMSSMTPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair((PublicKey)new BCXMSSMTPublicKey(this.treeDigest, xMSSMTPublicKeyParameters), (PrivateKey)new BCXMSSMTPrivateKey(this.treeDigest, xMSSMTPrivateKeyParameters));
    }
}

