/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.rainbow;

import java.security.PublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERNull;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.PQCObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.RainbowPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.rainbow.RainbowParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.rainbow.util.RainbowUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.util.KeyUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.spec.RainbowPublicKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class BCRainbowPublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private short[][] coeffquadratic;
    private short[][] coeffsingular;
    private short[] coeffscalar;
    private int docLength;
    private RainbowParameters rainbowParams;

    public BCRainbowPublicKey(int n2, short[][] sArray, short[][] sArray2, short[] sArray3) {
        this.docLength = n2;
        this.coeffquadratic = sArray;
        this.coeffsingular = sArray2;
        this.coeffscalar = sArray3;
    }

    public BCRainbowPublicKey(RainbowPublicKeySpec rainbowPublicKeySpec) {
        this(rainbowPublicKeySpec.getDocLength(), rainbowPublicKeySpec.getCoeffQuadratic(), rainbowPublicKeySpec.getCoeffSingular(), rainbowPublicKeySpec.getCoeffScalar());
    }

    public BCRainbowPublicKey(RainbowPublicKeyParameters rainbowPublicKeyParameters) {
        this(rainbowPublicKeyParameters.getDocLength(), rainbowPublicKeyParameters.getCoeffQuadratic(), rainbowPublicKeyParameters.getCoeffSingular(), rainbowPublicKeyParameters.getCoeffScalar());
    }

    public int getDocLength() {
        return this.docLength;
    }

    public short[][] getCoeffQuadratic() {
        return this.coeffquadratic;
    }

    public short[][] getCoeffSingular() {
        short[][] sArrayArray = new short[this.coeffsingular.length][];
        for (int i2 = 0; i2 != this.coeffsingular.length; ++i2) {
            sArrayArray[i2] = Arrays.clone((short[])this.coeffsingular[i2]);
        }
        return sArrayArray;
    }

    public short[] getCoeffScalar() {
        return Arrays.clone((short[])this.coeffscalar);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCRainbowPublicKey)) {
            return false;
        }
        BCRainbowPublicKey bCRainbowPublicKey = (BCRainbowPublicKey)object;
        return this.docLength == bCRainbowPublicKey.getDocLength() && RainbowUtil.equals((short[][])this.coeffquadratic, (short[][])bCRainbowPublicKey.getCoeffQuadratic()) && RainbowUtil.equals((short[][])this.coeffsingular, (short[][])bCRainbowPublicKey.getCoeffSingular()) && RainbowUtil.equals((short[])this.coeffscalar, (short[])bCRainbowPublicKey.getCoeffScalar());
    }

    public int hashCode() {
        int n2 = this.docLength;
        n2 = n2 * 37 + Arrays.hashCode((short[][])this.coeffquadratic);
        n2 = n2 * 37 + Arrays.hashCode((short[][])this.coeffsingular);
        n2 = n2 * 37 + Arrays.hashCode((short[])this.coeffscalar);
        return n2;
    }

    @Override
    public final String getAlgorithm() {
        return "Rainbow";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        RainbowPublicKey rainbowPublicKey = new RainbowPublicKey(this.docLength, this.coeffquadratic, this.coeffsingular, this.coeffscalar);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, (ASN1Encodable)DERNull.INSTANCE);
        return KeyUtil.getEncodedSubjectPublicKeyInfo((AlgorithmIdentifier)algorithmIdentifier, (ASN1Encodable)rainbowPublicKey);
    }
}

