/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.mceliece;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.mceliece.McElieceKeysToParams;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.util.AsymmetricBlockCipher;

public class McEliecePKCSCipherSpi
extends AsymmetricBlockCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private McElieceCipher cipher;

    public McEliecePKCSCipherSpi(McElieceCipher mcElieceCipher) {
        this.cipher = mcElieceCipher;
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter asymmetricKeyParameter = McElieceKeysToParams.generatePublicKeyParameter((PublicKey)((PublicKey)key));
        asymmetricKeyParameter = new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, secureRandom);
        this.cipher.init(true, (CipherParameters)asymmetricKeyParameter);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter asymmetricKeyParameter = McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
        this.cipher.init(false, (CipherParameters)asymmetricKeyParameter);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    protected byte[] messageEncrypt(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.cipher.messageEncrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    protected byte[] messageDecrypt(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.cipher.messageDecrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public String getName() {
        return "McEliecePKCS";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        McElieceKeyParameters mcElieceKeyParameters = key instanceof PublicKey ? (McElieceKeyParameters)McElieceKeysToParams.generatePublicKeyParameter((PublicKey)((PublicKey)key)) : (McElieceKeyParameters)McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
        return this.cipher.getKeySize(mcElieceKeyParameters);
    }
}

