/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.StateAwareMessageSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.KeyedHashFunctions;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.OTSHashAddress;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.WOTSPlus;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.WOTSPlusSignature;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSNode;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSReducedSignature;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSSignature;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSVerifierUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class XMSSSigner
implements StateAwareMessageSigner {
    private XMSSPrivateKeyParameters privateKey;
    private XMSSPrivateKeyParameters nextKeyGenerator;
    private XMSSPublicKeyParameters publicKey;
    private XMSSParameters params;
    private KeyedHashFunctions khf;
    private boolean initSign;
    private boolean hasGenerated;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            this.initSign = true;
            this.hasGenerated = false;
            this.nextKeyGenerator = this.privateKey = (XMSSPrivateKeyParameters)cipherParameters;
            this.params = this.privateKey.getParameters();
            this.khf = this.params.getWOTSPlus().getKhf();
        } else {
            this.initSign = false;
            this.publicKey = (XMSSPublicKeyParameters)cipherParameters;
            this.params = this.publicKey.getParameters();
            this.khf = this.params.getWOTSPlus().getKhf();
        }
    }

    public byte[] generateSignature(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (this.initSign) {
            if (this.privateKey == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        if (this.privateKey.getBDSState().getAuthenticationPath().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        int n2 = this.privateKey.getIndex();
        if (!XMSSUtil.isIndexValid((int)this.params.getHeight(), (long)n2)) {
            throw new IllegalStateException("index out of bounds");
        }
        byte[] byArray2 = this.khf.PRF(this.privateKey.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian((long)n2, (int)32));
        byte[] byArray3 = Arrays.concatenate((byte[])byArray2, (byte[])this.privateKey.getRoot(), (byte[])XMSSUtil.toBytesBigEndian((long)n2, (int)this.params.getDigestSize()));
        byte[] byArray4 = this.khf.HMsg(byArray3, byArray);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        WOTSPlusSignature wOTSPlusSignature = this.wotsSign(byArray4, oTSHashAddress);
        XMSSSignature xMSSSignature = (XMSSSignature)new XMSSSignature.Builder(this.params).withIndex(n2).withRandom(byArray2).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(this.privateKey.getBDSState().getAuthenticationPath()).build();
        this.hasGenerated = true;
        if (this.nextKeyGenerator != null) {
            this.nextKeyGenerator = this.privateKey = this.nextKeyGenerator.getNextKey();
        } else {
            this.privateKey = null;
        }
        return xMSSSignature.toByteArray();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        XMSSSignature xMSSSignature = new XMSSSignature.Builder(this.params).withSignature(byArray2).build();
        int n2 = xMSSSignature.getIndex();
        this.params.getWOTSPlus().importKeys(new byte[this.params.getDigestSize()], this.publicKey.getPublicSeed());
        byte[] byArray3 = Arrays.concatenate((byte[])xMSSSignature.getRandom(), (byte[])this.publicKey.getRoot(), (byte[])XMSSUtil.toBytesBigEndian((long)n2, (int)this.params.getDigestSize()));
        byte[] byArray4 = this.khf.HMsg(byArray3, byArray);
        int n3 = this.params.getHeight();
        int n4 = XMSSUtil.getLeafIndex((long)n2, (int)n3);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        XMSSNode xMSSNode = XMSSVerifierUtil.getRootNodeFromSignature((WOTSPlus)this.params.getWOTSPlus(), (int)n3, (byte[])byArray4, (XMSSReducedSignature)xMSSSignature, (OTSHashAddress)oTSHashAddress, (int)n4);
        return Arrays.constantTimeAreEqual((byte[])xMSSNode.getValue(), (byte[])this.publicKey.getRoot());
    }

    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.hasGenerated) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.privateKey;
            this.privateKey = null;
            this.nextKeyGenerator = null;
            return xMSSPrivateKeyParameters;
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.nextKeyGenerator.getNextKey();
        this.nextKeyGenerator = null;
        return xMSSPrivateKeyParameters;
    }

    private WOTSPlusSignature wotsSign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.params.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.params.getWOTSPlus().importKeys(this.params.getWOTSPlus().getWOTSPlusSecretKey(this.privateKey.getSecretKeySeed(), oTSHashAddress), this.privateKey.getPublicSeed());
        return this.params.getWOTSPlus().sign(byArray, oTSHashAddress);
    }
}

