/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDS;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.OTSHashAddress;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XMSSPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final BDS bdsState;

    private XMSSPrivateKeyParameters(Builder builder) {
        super(true);
        this.params = Builder.access$000((Builder)builder);
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.params.getDigestSize();
        byte[] byArray = Builder.access$100((Builder)builder);
        if (byArray != null) {
            if (Builder.access$200((Builder)builder) == null) {
                throw new NullPointerException("xmss == null");
            }
            int n3 = this.params.getHeight();
            int n4 = 4;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = 0;
            int n10 = Pack.bigEndianToInt((byte[])byArray, (int)n9);
            if (!XMSSUtil.isIndexValid((int)n3, (long)n10)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n4), (int)n5);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n5), (int)n6);
            this.publicSeed = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n6), (int)n7);
            this.root = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n7), (int)n8);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n8), (int)(byArray.length - n9));
            try {
                BDS bDS = (BDS)XMSSUtil.deserialize((byte[])byArray2, BDS.class);
                bDS.setXMSS(Builder.access$200((Builder)builder));
                bDS.validate();
                if (bDS.getIndex() != n10) {
                    throw new IllegalStateException("serialized BDS has wrong index");
                }
                this.bdsState = bDS;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            byte[] byArray3 = Builder.access$300((Builder)builder);
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = byArray3;
            } else {
                this.secretKeySeed = new byte[n2];
            }
            byte[] byArray4 = Builder.access$400((Builder)builder);
            if (byArray4 != null) {
                if (byArray4.length != n2) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = byArray4;
            } else {
                this.secretKeyPRF = new byte[n2];
            }
            byte[] byArray5 = Builder.access$500((Builder)builder);
            if (byArray5 != null) {
                if (byArray5.length != n2) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = byArray5;
            } else {
                this.publicSeed = new byte[n2];
            }
            byte[] byArray6 = Builder.access$600((Builder)builder);
            if (byArray6 != null) {
                if (byArray6.length != n2) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = byArray6;
            } else {
                this.root = new byte[n2];
            }
            BDS bDS = Builder.access$700((Builder)builder);
            this.bdsState = bDS != null ? bDS : (Builder.access$800((Builder)builder) < (1 << this.params.getHeight()) - 2 && byArray5 != null && byArray3 != null ? new BDS(this.params, byArray5, byArray3, (OTSHashAddress)new OTSHashAddress.Builder().build(), Builder.access$800((Builder)builder)) : new BDS(this.params, Builder.access$800((Builder)builder)));
        }
    }

    public byte[] toByteArray() {
        int n2 = this.params.getDigestSize();
        int n3 = 4;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n3 + n4 + n5 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        Pack.intToBigEndian((int)this.bdsState.getIndex(), (byte[])byArray, (int)n9);
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.secretKeySeed, (int)(n9 += n3));
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.secretKeyPRF, (int)(n9 += n4));
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.publicSeed, (int)(n9 += n5));
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.root, (int)(n9 += n6));
        byte[] byArray2 = null;
        try {
            byArray2 = XMSSUtil.serialize((Object)this.bdsState);
        }
        catch (IOException iOException) {
            throw new RuntimeException("error serializing bds state: " + iOException.getMessage());
        }
        return Arrays.concatenate((byte[])byArray, (byte[])byArray2);
    }

    public int getIndex() {
        return this.bdsState.getIndex();
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray((byte[])this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray((byte[])this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray((byte[])this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray((byte[])this.root);
    }

    BDS getBDSState() {
        return this.bdsState;
    }

    public XMSSParameters getParameters() {
        return this.params;
    }

    public XMSSPrivateKeyParameters getNextKey() {
        int n2 = this.params.getHeight();
        if (this.getIndex() < (1 << n2) - 1) {
            return new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(this.bdsState.getNextState(this.publicSeed, this.secretKeySeed, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        }
        return new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(new BDS(this.params, this.getIndex() + 1)).build();
    }
}

