/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.DefaultXMSSOid;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.WOTSPlus;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.WOTSPlusParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSOid;

public final class XMSSParameters {
    private final XMSSOid oid;
    private final WOTSPlus wotsPlus;
    private final int height;
    private final int k;

    public XMSSParameters(int n2, Digest digest) {
        if (n2 < 2) {
            throw new IllegalArgumentException("height must be >= 2");
        }
        if (digest == null) {
            throw new NullPointerException("digest == null");
        }
        this.wotsPlus = new WOTSPlus(new WOTSPlusParameters(digest));
        this.height = n2;
        this.k = this.determineMinK();
        this.oid = DefaultXMSSOid.lookup((String)this.getDigest().getAlgorithmName(), (int)this.getDigestSize(), (int)this.getWinternitzParameter(), (int)this.wotsPlus.getParams().getLen(), (int)n2);
    }

    private int determineMinK() {
        for (int i2 = 2; i2 <= this.height; ++i2) {
            if ((this.height - i2) % 2 != 0) continue;
            return i2;
        }
        throw new IllegalStateException("should never happen...");
    }

    protected Digest getDigest() {
        return this.wotsPlus.getParams().getDigest();
    }

    public int getDigestSize() {
        return this.wotsPlus.getParams().getDigestSize();
    }

    public int getWinternitzParameter() {
        return this.wotsPlus.getParams().getWinternitzParameter();
    }

    public int getHeight() {
        return this.height;
    }

    WOTSPlus getWOTSPlus() {
        return this.wotsPlus;
    }

    int getK() {
        return this.k;
    }
}

