/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.StateAwareMessageSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDS;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDSStateMap;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.OTSHashAddress;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.WOTSPlus;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.WOTSPlusParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.WOTSPlusSignature;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTSignature;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSNode;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSReducedSignature;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSVerifierUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class XMSSMTSigner
implements StateAwareMessageSigner {
    private XMSSMTPrivateKeyParameters privateKey;
    private XMSSMTPrivateKeyParameters nextKeyGenerator;
    private XMSSMTPublicKeyParameters publicKey;
    private XMSSMTParameters params;
    private XMSSParameters xmssParams;
    private WOTSPlus wotsPlus;
    private boolean hasGenerated;
    private boolean initSign;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            this.initSign = true;
            this.hasGenerated = false;
            this.nextKeyGenerator = this.privateKey = (XMSSMTPrivateKeyParameters)cipherParameters;
            this.params = this.privateKey.getParameters();
            this.xmssParams = this.params.getXMSSParameters();
        } else {
            this.initSign = false;
            this.publicKey = (XMSSMTPublicKeyParameters)cipherParameters;
            this.params = this.publicKey.getParameters();
            this.xmssParams = this.params.getXMSSParameters();
        }
        this.wotsPlus = new WOTSPlus(new WOTSPlusParameters(this.params.getDigest()));
    }

    public byte[] generateSignature(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (this.initSign) {
            if (this.privateKey == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        if (this.privateKey.getBDSState().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        BDSStateMap bDSStateMap = this.privateKey.getBDSState();
        long l2 = this.privateKey.getIndex();
        int n2 = this.params.getHeight();
        int n3 = this.xmssParams.getHeight();
        if (!XMSSUtil.isIndexValid((int)n2, (long)l2)) {
            throw new IllegalStateException("index out of bounds");
        }
        byte[] byArray2 = this.wotsPlus.getKhf().PRF(this.privateKey.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian((long)l2, (int)32));
        byte[] byArray3 = Arrays.concatenate((byte[])byArray2, (byte[])this.privateKey.getRoot(), (byte[])XMSSUtil.toBytesBigEndian((long)l2, (int)this.params.getDigestSize()));
        byte[] byArray4 = this.wotsPlus.getKhf().HMsg(byArray3, byArray);
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.params).withIndex(l2).withRandom(byArray2).build();
        long l3 = XMSSUtil.getTreeIndex((long)l2, (int)n3);
        int n4 = XMSSUtil.getLeafIndex((long)l2, (int)n3);
        this.wotsPlus.importKeys(new byte[this.params.getDigestSize()], this.privateKey.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n4).build();
        if (bDSStateMap.get(0) == null || n4 == 0) {
            bDSStateMap.put(0, new BDS(this.xmssParams, this.privateKey.getPublicSeed(), this.privateKey.getSecretKeySeed(), oTSHashAddress));
        }
        WOTSPlusSignature wOTSPlusSignature = this.wotsSign(byArray4, oTSHashAddress);
        XMSSReducedSignature xMSSReducedSignature = new XMSSReducedSignature.Builder(this.xmssParams).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(bDSStateMap.get(0).getAuthenticationPath()).build();
        xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
        for (int i2 = 1; i2 < this.params.getLayers(); ++i2) {
            XMSSNode xMSSNode = bDSStateMap.get(i2 - 1).getRoot();
            n4 = XMSSUtil.getLeafIndex((long)l3, (int)n3);
            l3 = XMSSUtil.getTreeIndex((long)l3, (int)n3);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n4).build();
            wOTSPlusSignature = this.wotsSign(xMSSNode.getValue(), oTSHashAddress);
            if (bDSStateMap.get(i2) == null || XMSSUtil.isNewBDSInitNeeded((long)l2, (int)n3, (int)i2)) {
                bDSStateMap.put(i2, new BDS(this.xmssParams, this.privateKey.getPublicSeed(), this.privateKey.getSecretKeySeed(), oTSHashAddress));
            }
            xMSSReducedSignature = new XMSSReducedSignature.Builder(this.xmssParams).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(bDSStateMap.get(i2).getAuthenticationPath()).build();
            xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
        }
        this.hasGenerated = true;
        if (this.nextKeyGenerator != null) {
            this.nextKeyGenerator = this.privateKey = this.nextKeyGenerator.getNextKey();
        } else {
            this.privateKey = null;
        }
        return xMSSMTSignature.toByteArray();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("signature == null");
        }
        if (this.publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.params).withSignature(byArray2).build();
        byte[] byArray3 = Arrays.concatenate((byte[])xMSSMTSignature.getRandom(), (byte[])this.publicKey.getRoot(), (byte[])XMSSUtil.toBytesBigEndian((long)xMSSMTSignature.getIndex(), (int)this.params.getDigestSize()));
        byte[] byArray4 = this.wotsPlus.getKhf().HMsg(byArray3, byArray);
        long l2 = xMSSMTSignature.getIndex();
        int n2 = this.xmssParams.getHeight();
        long l3 = XMSSUtil.getTreeIndex((long)l2, (int)n2);
        int n3 = XMSSUtil.getLeafIndex((long)l2, (int)n2);
        this.wotsPlus.importKeys(new byte[this.params.getDigestSize()], this.publicKey.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n3).build();
        XMSSReducedSignature xMSSReducedSignature = (XMSSReducedSignature)xMSSMTSignature.getReducedSignatures().get(0);
        XMSSNode xMSSNode = XMSSVerifierUtil.getRootNodeFromSignature((WOTSPlus)this.wotsPlus, (int)n2, (byte[])byArray4, (XMSSReducedSignature)xMSSReducedSignature, (OTSHashAddress)oTSHashAddress, (int)n3);
        for (int i2 = 1; i2 < this.params.getLayers(); ++i2) {
            xMSSReducedSignature = (XMSSReducedSignature)xMSSMTSignature.getReducedSignatures().get(i2);
            n3 = XMSSUtil.getLeafIndex((long)l3, (int)n2);
            l3 = XMSSUtil.getTreeIndex((long)l3, (int)n2);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n3).build();
            xMSSNode = XMSSVerifierUtil.getRootNodeFromSignature((WOTSPlus)this.wotsPlus, (int)n2, (byte[])xMSSNode.getValue(), (XMSSReducedSignature)xMSSReducedSignature, (OTSHashAddress)oTSHashAddress, (int)n3);
        }
        return Arrays.constantTimeAreEqual((byte[])xMSSNode.getValue(), (byte[])this.publicKey.getRoot());
    }

    private WOTSPlusSignature wotsSign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.params.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.wotsPlus.importKeys(this.wotsPlus.getWOTSPlusSecretKey(this.privateKey.getSecretKeySeed(), oTSHashAddress), this.privateKey.getPublicSeed());
        return this.wotsPlus.sign(byArray, oTSHashAddress);
    }

    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.hasGenerated) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.privateKey;
            this.privateKey = null;
            this.nextKeyGenerator = null;
            return xMSSMTPrivateKeyParameters;
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.nextKeyGenerator.getNextKey();
        this.nextKeyGenerator = null;
        return xMSSMTPrivateKeyParameters;
    }
}

