/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDSStateMap;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XMSSMTPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters params;
    private final long index;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final BDSStateMap bdsState;

    private XMSSMTPrivateKeyParameters(Builder builder) {
        super(true);
        this.params = Builder.access$000((Builder)builder);
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.params.getDigestSize();
        byte[] byArray = Builder.access$100((Builder)builder);
        if (byArray != null) {
            if (Builder.access$200((Builder)builder) == null) {
                throw new NullPointerException("xmss == null");
            }
            int n3 = this.params.getHeight();
            int n4 = (n3 + 7) / 8;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = 0;
            this.index = XMSSUtil.bytesToXBigEndian((byte[])byArray, (int)n9, (int)n4);
            if (!XMSSUtil.isIndexValid((int)n3, (long)this.index)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n4), (int)n5);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n5), (int)n6);
            this.publicSeed = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n6), (int)n7);
            this.root = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n7), (int)n8);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n8), (int)(byArray.length - n9));
            try {
                BDSStateMap bDSStateMap = (BDSStateMap)XMSSUtil.deserialize((byte[])byArray2, BDSStateMap.class);
                bDSStateMap.setXMSS(Builder.access$200((Builder)builder));
                this.bdsState = bDSStateMap;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            this.index = Builder.access$300((Builder)builder);
            byte[] byArray3 = Builder.access$400((Builder)builder);
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = byArray3;
            } else {
                this.secretKeySeed = new byte[n2];
            }
            byte[] byArray4 = Builder.access$500((Builder)builder);
            if (byArray4 != null) {
                if (byArray4.length != n2) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = byArray4;
            } else {
                this.secretKeyPRF = new byte[n2];
            }
            byte[] byArray5 = Builder.access$600((Builder)builder);
            if (byArray5 != null) {
                if (byArray5.length != n2) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = byArray5;
            } else {
                this.publicSeed = new byte[n2];
            }
            byte[] byArray6 = Builder.access$700((Builder)builder);
            if (byArray6 != null) {
                if (byArray6.length != n2) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = byArray6;
            } else {
                this.root = new byte[n2];
            }
            BDSStateMap bDSStateMap = Builder.access$800((Builder)builder);
            if (bDSStateMap != null) {
                this.bdsState = bDSStateMap;
            } else {
                long l2 = Builder.access$300((Builder)builder);
                int n10 = this.params.getHeight();
                this.bdsState = XMSSUtil.isIndexValid((int)n10, (long)l2) && byArray5 != null && byArray3 != null ? new BDSStateMap(this.params, Builder.access$300((Builder)builder), byArray5, byArray3) : new BDSStateMap();
            }
        }
    }

    public byte[] toByteArray() {
        int n2 = this.params.getDigestSize();
        int n3 = (this.params.getHeight() + 7) / 8;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n3 + n4 + n5 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        byte[] byArray2 = XMSSUtil.toBytesBigEndian((long)this.index, (int)n3);
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])byArray2, (int)n9);
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.secretKeySeed, (int)(n9 += n3));
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.secretKeyPRF, (int)(n9 += n4));
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.publicSeed, (int)(n9 += n5));
        XMSSUtil.copyBytesAtOffset((byte[])byArray, (byte[])this.root, (int)(n9 += n6));
        try {
            return Arrays.concatenate((byte[])byArray, (byte[])XMSSUtil.serialize((Object)this.bdsState));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("error serializing bds state: " + iOException.getMessage(), iOException);
        }
    }

    public long getIndex() {
        return this.index;
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray((byte[])this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray((byte[])this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray((byte[])this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray((byte[])this.root);
    }

    BDSStateMap getBDSState() {
        return this.bdsState;
    }

    public XMSSMTParameters getParameters() {
        return this.params;
    }

    public XMSSMTPrivateKeyParameters getNextKey() {
        BDSStateMap bDSStateMap = new BDSStateMap(this.bdsState, this.params, this.getIndex(), this.publicSeed, this.secretKeySeed);
        return new Builder(this.params).withIndex(this.index + 1L).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(bDSStateMap).build();
    }
}

