/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDS;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.OTSHashAddress;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;

public class BDSStateMap
implements Serializable {
    private final Map<Integer, BDS> bdsState = new TreeMap();

    BDSStateMap() {
    }

    BDSStateMap(XMSSMTParameters xMSSMTParameters, long l2, byte[] byArray, byte[] byArray2) {
        for (long i2 = 0L; i2 < l2; ++i2) {
            this.updateState(xMSSMTParameters, i2, byArray, byArray2);
        }
    }

    BDSStateMap(BDSStateMap bDSStateMap, XMSSMTParameters xMSSMTParameters, long l2, byte[] byArray, byte[] byArray2) {
        for (Integer n2 : bDSStateMap.bdsState.keySet()) {
            this.bdsState.put(n2, bDSStateMap.bdsState.get(n2));
        }
        this.updateState(xMSSMTParameters, l2, byArray, byArray2);
    }

    private void updateState(XMSSMTParameters xMSSMTParameters, long l2, byte[] byArray, byte[] byArray2) {
        XMSSParameters xMSSParameters = xMSSMTParameters.getXMSSParameters();
        int n2 = xMSSParameters.getHeight();
        long l3 = XMSSUtil.getTreeIndex((long)l2, (int)n2);
        int n3 = XMSSUtil.getLeafIndex((long)l2, (int)n2);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n3).build();
        if (n3 < (1 << n2) - 1) {
            if (this.get(0) == null || n3 == 0) {
                this.put(0, new BDS(xMSSParameters, byArray, byArray2, oTSHashAddress));
            }
            this.update(0, byArray, byArray2, oTSHashAddress);
        }
        for (int i2 = 1; i2 < xMSSMTParameters.getLayers(); ++i2) {
            n3 = XMSSUtil.getLeafIndex((long)l3, (int)n2);
            l3 = XMSSUtil.getTreeIndex((long)l3, (int)n2);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n3).build();
            if (n3 >= (1 << n2) - 1 || !XMSSUtil.isNewAuthenticationPathNeeded((long)l2, (int)n2, (int)i2)) continue;
            if (this.get(i2) == null) {
                this.put(i2, new BDS(xMSSMTParameters.getXMSSParameters(), byArray, byArray2, oTSHashAddress));
            }
            this.update(i2, byArray, byArray2, oTSHashAddress);
        }
    }

    void setXMSS(XMSSParameters xMSSParameters) {
        for (Integer n2 : this.bdsState.keySet()) {
            BDS bDS = (BDS)this.bdsState.get(n2);
            bDS.setXMSS(xMSSParameters);
            bDS.validate();
        }
    }

    public boolean isEmpty() {
        return this.bdsState.isEmpty();
    }

    public BDS get(int n2) {
        return (BDS)this.bdsState.get(Integers.valueOf((int)n2));
    }

    public BDS update(int n2, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        return this.bdsState.put(Integers.valueOf((int)n2), ((BDS)this.bdsState.get(Integers.valueOf((int)n2))).getNextState(byArray, byArray2, oTSHashAddress));
    }

    public void put(int n2, BDS bDS) {
        this.bdsState.put(Integers.valueOf((int)n2), bDS);
    }
}

