/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;

public class NTRUSigningPrivateKeyParameters
extends AsymmetricKeyParameter {
    private List<Basis> bases;
    private NTRUSigningPublicKeyParameters publicKey;

    public NTRUSigningPrivateKeyParameters(byte[] byArray, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) throws IOException {
        this((InputStream)new ByteArrayInputStream(byArray), nTRUSigningKeyGenerationParameters);
    }

    public NTRUSigningPrivateKeyParameters(InputStream inputStream, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) throws IOException {
        super(true);
        this.bases = new ArrayList();
        for (int i2 = 0; i2 <= nTRUSigningKeyGenerationParameters.B; ++i2) {
            this.add(new Basis(inputStream, nTRUSigningKeyGenerationParameters, i2 != 0));
        }
        this.publicKey = new NTRUSigningPublicKeyParameters(inputStream, nTRUSigningKeyGenerationParameters.getSigningParameters());
    }

    public NTRUSigningPrivateKeyParameters(List<Basis> list, NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters) {
        super(true);
        this.bases = new ArrayList<Basis>(list);
        this.publicKey = nTRUSigningPublicKeyParameters;
    }

    private void add(Basis basis) {
        this.bases.add(basis);
    }

    public Basis getBasis(int n2) {
        return (Basis)this.bases.get(n2);
    }

    public NTRUSigningPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < this.bases.size(); ++i2) {
            ((Basis)this.bases.get(i2)).encode((OutputStream)byteArrayOutputStream, i2 != 0);
        }
        byteArrayOutputStream.write(this.publicKey.getEncoded());
        return byteArrayOutputStream.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3;
        if (this.bases == null) {
            return n3;
        }
        n3 += this.bases.hashCode();
        for (Basis basis : this.bases) {
            n3 += basis.hashCode();
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = (NTRUSigningPrivateKeyParameters)object;
        if (this.bases == null != (nTRUSigningPrivateKeyParameters.bases == null)) {
            return false;
        }
        if (this.bases == null) {
            return true;
        }
        if (this.bases.size() != nTRUSigningPrivateKeyParameters.bases.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.bases.size(); ++i2) {
            Basis basis = (Basis)this.bases.get(i2);
            Basis basis2 = (Basis)nTRUSigningPrivateKeyParameters.bases.get(i2);
            if (!basis.f.equals(basis2.f)) {
                return false;
            }
            if (!basis.fPrime.equals(basis2.fPrime)) {
                return false;
            }
            if (i2 != 0 && !basis.h.equals((Object)basis2.h)) {
                return false;
            }
            if (basis.params.equals((Object)basis2.params)) continue;
            return false;
        }
        return true;
    }
}

