/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece;

import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHA1Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.DigestRandomGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.MessageEncryptor;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.Conversions;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceCCA2Primitives;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.Utils;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.linearalgebra.ByteUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.linearalgebra.GF2Vector;

public class McElieceFujisakiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.1";
    private static final String DEFAULT_PRNG_NAME = "SHA1PRNG";
    private Digest messDigest;
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    McElieceCCA2KeyParameters key;
    private boolean forEncryption;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forEncryption = bl2;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.sr = parametersWithRandom.getRandom();
                this.key = (McElieceCCA2PublicKeyParameters)parametersWithRandom.getParameters();
                this.initCipherEncrypt((McElieceCCA2PublicKeyParameters)this.key);
            } else {
                this.sr = CryptoServicesRegistrar.getSecureRandom();
                this.key = (McElieceCCA2PublicKeyParameters)cipherParameters;
                this.initCipherEncrypt((McElieceCCA2PublicKeyParameters)this.key);
            }
        } else {
            this.key = (McElieceCCA2PrivateKeyParameters)cipherParameters;
            this.initCipherDecrypt((McElieceCCA2PrivateKeyParameters)this.key);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters mcElieceCCA2KeyParameters) throws IllegalArgumentException {
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private void initCipherEncrypt(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.sr = this.sr != null ? this.sr : CryptoServicesRegistrar.getSecureRandom();
        this.messDigest = Utils.getDigest((String)mcElieceCCA2PublicKeyParameters.getDigest());
        this.n = mcElieceCCA2PublicKeyParameters.getN();
        this.k = mcElieceCCA2PublicKeyParameters.getK();
        this.t = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void initCipherDecrypt(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.messDigest = Utils.getDigest((String)mcElieceCCA2PrivateKeyParameters.getDigest());
        this.n = mcElieceCCA2PrivateKeyParameters.getN();
        this.t = mcElieceCCA2PrivateKeyParameters.getT();
    }

    public byte[] messageEncrypt(byte[] byArray) {
        if (!this.forEncryption) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        GF2Vector gF2Vector = new GF2Vector(this.k, this.sr);
        byte[] byArray2 = gF2Vector.getEncoded();
        byte[] byArray3 = ByteUtils.concatenate((byte[])byArray2, (byte[])byArray);
        this.messDigest.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray4, 0);
        GF2Vector gF2Vector2 = Conversions.encode((int)this.n, (int)this.t, (byte[])byArray4);
        byte[] byArray5 = McElieceCCA2Primitives.encryptionPrimitive((McElieceCCA2PublicKeyParameters)((McElieceCCA2PublicKeyParameters)this.key), (GF2Vector)gF2Vector, (GF2Vector)gF2Vector2).getEncoded();
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator((Digest)new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray2);
        byte[] byArray6 = new byte[byArray.length];
        digestRandomGenerator.nextBytes(byArray6);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2;
            byArray6[n2] = (byte)(byArray6[n2] ^ byArray[i2]);
        }
        return ByteUtils.concatenate((byte[])byArray5, (byte[])byArray6);
    }

    public byte[] messageDecrypt(byte[] byArray) throws InvalidCipherTextException {
        if (this.forEncryption) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.n + 7 >> 3;
        int n3 = byArray.length - n2;
        byte[][] byArray2 = ByteUtils.split((byte[])byArray, (int)n2);
        byte[] byArray3 = byArray2[0];
        byte[] byArray4 = byArray2[1];
        GF2Vector gF2Vector = GF2Vector.OS2VP((int)this.n, (byte[])byArray3);
        GF2Vector[] gF2VectorArray = McElieceCCA2Primitives.decryptionPrimitive((McElieceCCA2PrivateKeyParameters)((McElieceCCA2PrivateKeyParameters)this.key), (GF2Vector)gF2Vector);
        byte[] byArray5 = gF2VectorArray[0].getEncoded();
        GF2Vector gF2Vector2 = gF2VectorArray[1];
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator((Digest)new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray5);
        byte[] byArray6 = new byte[n3];
        digestRandomGenerator.nextBytes(byArray6);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray4[i2]);
        }
        byte[] byArray7 = ByteUtils.concatenate((byte[])byArray5, (byte[])byArray6);
        byte[] byArray8 = new byte[this.messDigest.getDigestSize()];
        this.messDigest.update(byArray7, 0, byArray7.length);
        this.messDigest.doFinal(byArray8, 0);
        gF2Vector = Conversions.encode((int)this.n, (int)this.t, (byte[])byArray8);
        if (!gF2Vector.equals((Object)gF2Vector2)) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        return byArray6;
    }
}

