/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class XMSSPublicKey
extends ASN1Object {
    private final byte[] publicSeed;
    private final byte[] root;

    public XMSSPublicKey(byte[] byArray, byte[] byArray2) {
        this.publicSeed = Arrays.clone((byte[])byArray);
        this.root = Arrays.clone((byte[])byArray2);
    }

    private XMSSPublicKey(ASN1Sequence aSN1Sequence) {
        if (!ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).getValue().equals(BigInteger.valueOf(0L))) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.publicSeed = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets());
        this.root = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence.getObjectAt(2)).getOctets());
    }

    public static XMSSPublicKey getInstance(Object object) {
        if (object instanceof XMSSPublicKey) {
            return (XMSSPublicKey)object;
        }
        if (object != null) {
            return new XMSSPublicKey(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public byte[] getPublicSeed() {
        return Arrays.clone((byte[])this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone((byte[])this.root);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(0L));
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.publicSeed));
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.root));
        return new DERSequence(aSN1EncodableVector);
    }
}

