/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class GMSSPublicKey
extends ASN1Object {
    private ASN1Integer version;
    private byte[] publicKey;

    private GMSSPublicKey(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("size of seq = " + aSN1Sequence.size());
        }
        this.version = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.publicKey = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets();
    }

    public GMSSPublicKey(byte[] byArray) {
        this.version = new ASN1Integer(0L);
        this.publicKey = byArray;
    }

    public static GMSSPublicKey getInstance(Object object) {
        if (object instanceof GMSSPublicKey) {
            return (GMSSPublicKey)object;
        }
        if (object != null) {
            return new GMSSPublicKey(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public byte[] getPublicKey() {
        return Arrays.clone((byte[])this.publicKey);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.publicKey));
        return new DERSequence(aSN1EncodableVector);
    }
}

