/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.rfc8032;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHA512Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.rfc7748.X25519Field;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.rfc8032.Ed25519;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Interleave;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat256;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Ed25519 {
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int POINT_BYTES = 32;
    private static final int SCALAR_INTS = 8;
    private static final int SCALAR_BYTES = 32;
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] L = new int[]{1559614445, 1477600026, -1560830762, 350157278, 0, 0, 0, 0x10000000};
    private static final int L0 = -50998291;
    private static final int L1 = 19280294;
    private static final int L2 = 127719000;
    private static final int L3 = -6428113;
    private static final int L4 = 5343;
    private static final int[] B_x = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] B_y = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] C_d = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] C_d2 = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] C_d4 = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static final int WNAF_WIDTH_BASE = 7;
    private static final int PRECOMP_BLOCKS = 8;
    private static final int PRECOMP_TEETH = 4;
    private static final int PRECOMP_SPACING = 8;
    private static final int PRECOMP_POINTS = 8;
    private static final int PRECOMP_MASK = 7;
    private static PointExt[] precompBaseTable = null;
    private static int[] precompBase = null;

    private static byte[] calculateS(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[16];
        Ed25519.decodeScalar((byte[])byArray, (int)0, (int[])nArray);
        int[] nArray2 = new int[8];
        Ed25519.decodeScalar((byte[])byArray2, (int)0, (int[])nArray2);
        int[] nArray3 = new int[8];
        Ed25519.decodeScalar((byte[])byArray3, (int)0, (int[])nArray3);
        Nat256.mulAddTo((int[])nArray2, (int[])nArray3, (int[])nArray);
        byte[] byArray4 = new byte[64];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Ed25519.encode32((int)nArray[i2], (byte[])byArray4, (int)(i2 * 4));
        }
        return Ed25519.reduceScalar((byte[])byArray4);
    }

    private static boolean checkPointVar(byte[] byArray) {
        int[] nArray = new int[8];
        Ed25519.decode32((byte[])byArray, (int)0, (int[])nArray, (int)0, (int)8);
        nArray[7] = nArray[7] & Integer.MAX_VALUE;
        return !Nat256.gte((int[])nArray, (int[])P);
    }

    private static boolean checkScalarVar(byte[] byArray) {
        int[] nArray = new int[8];
        Ed25519.decodeScalar((byte[])byArray, (int)0, (int[])nArray);
        return !Nat256.gte((int[])nArray, (int[])L);
    }

    private static int decode24(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return n3 |= (byArray[++n2] & 0xFF) << 16;
    }

    private static int decode32(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        return n3 |= byArray[++n2] << 24;
    }

    private static void decode32(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[n3 + i2] = Ed25519.decode32((byte[])byArray, (int)(n2 + i2 * 4));
        }
    }

    private static boolean decodePointVar(byte[] byArray, int n2, boolean bl2, PointExt pointExt) {
        byte[] byArray2 = Arrays.copyOfRange((byte[])byArray, (int)n2, (int)(n2 + 32));
        if (!Ed25519.checkPointVar((byte[])byArray2)) {
            return false;
        }
        int n3 = (byArray2[31] & 0x80) >>> 7;
        byArray2[31] = (byte)(byArray2[31] & 0x7F);
        X25519Field.decode((byte[])byArray2, (int)0, (int[])pointExt.y);
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        X25519Field.sqr((int[])pointExt.y, (int[])nArray);
        X25519Field.mul((int[])C_d, (int[])nArray, (int[])nArray2);
        X25519Field.subOne((int[])nArray);
        X25519Field.addOne((int[])nArray2);
        if (!X25519Field.sqrtRatioVar((int[])nArray, (int[])nArray2, (int[])pointExt.x)) {
            return false;
        }
        X25519Field.normalize((int[])pointExt.x);
        if (n3 == 1 && X25519Field.isZeroVar((int[])pointExt.x)) {
            return false;
        }
        if (bl2 ^ n3 != (pointExt.x[0] & 1)) {
            X25519Field.negate((int[])pointExt.x, (int[])pointExt.x);
        }
        Ed25519.pointExtendXY((PointExt)pointExt);
        return true;
    }

    private static void decodeScalar(byte[] byArray, int n2, int[] nArray) {
        Ed25519.decode32((byte[])byArray, (int)n2, (int[])nArray, (int)0, (int)8);
    }

    private static void encode24(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
    }

    private static void encode32(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
        byArray[++n3] = (byte)(n2 >>> 24);
    }

    private static void encode56(long l2, byte[] byArray, int n2) {
        Ed25519.encode32((int)((int)l2), (byte[])byArray, (int)n2);
        Ed25519.encode24((int)((int)(l2 >>> 32)), (byte[])byArray, (int)(n2 + 4));
    }

    private static void encodePoint(PointExt pointExt, byte[] byArray, int n2) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        X25519Field.inv((int[])pointExt.z, (int[])nArray2);
        X25519Field.mul((int[])pointExt.x, (int[])nArray2, (int[])nArray);
        X25519Field.mul((int[])pointExt.y, (int[])nArray2, (int[])nArray2);
        X25519Field.normalize((int[])nArray);
        X25519Field.normalize((int[])nArray2);
        X25519Field.encode((int[])nArray2, (byte[])byArray, (int)n2);
        int n3 = n2 + 32 - 1;
        byArray[n3] = (byte)(byArray[n3] | (nArray[0] & 1) << 7);
    }

    public static void generatePublicKey(byte[] byArray, int n2, byte[] byArray2, int n3) {
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray3 = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(byArray, n2, 32);
        sHA512Digest.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[32];
        Ed25519.pruneScalar((byte[])byArray3, (int)0, (byte[])byArray4);
        Ed25519.scalarMultBaseEncoded((byte[])byArray4, (byte[])byArray2, (int)n3);
    }

    private static byte[] getWNAF(int[] nArray, int n2) {
        int n3;
        int[] nArray2 = new int[16];
        int n4 = nArray2.length;
        int n5 = 0;
        int n6 = 8;
        while (--n6 >= 0) {
            n3 = nArray[n6];
            nArray2[--n4] = n3 >>> 16 | n5 << 16;
            nArray2[--n4] = n5 = n3;
        }
        byte[] byArray = new byte[256];
        n5 = 1 << n2;
        n6 = n5 - 1;
        n3 = n5 >>> 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < nArray2.length) {
            int n10 = nArray2[n9];
            while (n7 < 16) {
                int n11 = n10 >>> n7;
                int n12 = n11 & 1;
                if (n12 == n8) {
                    ++n7;
                    continue;
                }
                int n13 = (n11 & n6) + n8;
                n8 = n13 & n3;
                n13 -= n8 << 1;
                n8 >>>= n2 - 1;
                byArray[(n9 << 4) + n7] = (byte)n13;
                n7 += n2;
            }
            ++n9;
            n7 -= 16;
        }
        return byArray;
    }

    private static void implSign(SHA512Digest sHA512Digest, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, byte[] byArray4, int n3, int n4, byte[] byArray5, int n5) {
        sHA512Digest.update(byArray, 32, 32);
        sHA512Digest.update(byArray4, n3, n4);
        sHA512Digest.doFinal(byArray, 0);
        byte[] byArray6 = Ed25519.reduceScalar((byte[])byArray);
        byte[] byArray7 = new byte[32];
        Ed25519.scalarMultBaseEncoded((byte[])byArray6, (byte[])byArray7, (int)0);
        sHA512Digest.update(byArray7, 0, 32);
        sHA512Digest.update(byArray3, 0, 32);
        sHA512Digest.update(byArray4, n3, n4);
        sHA512Digest.doFinal(byArray, 0);
        byte[] byArray8 = Ed25519.reduceScalar((byte[])byArray);
        byte[] byArray9 = Ed25519.calculateS((byte[])byArray6, (byte[])byArray8, (byte[])byArray2);
        System.arraycopy(byArray7, 0, byArray5, n5, 32);
        System.arraycopy(byArray9, 0, byArray5, n5 + 32, 32);
    }

    private static void pointAddVar(boolean bl2, PointExt pointExt, PointExt pointExt2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        int[] nArray8 = X25519Field.create();
        int[] nArray9 = X25519Field.create();
        int[] nArray10 = X25519Field.create();
        int[] nArray11 = X25519Field.create();
        int[] nArray12 = X25519Field.create();
        if (bl2) {
            nArray4 = nArray8;
            nArray3 = nArray7;
            nArray2 = nArray11;
            nArray = nArray10;
        } else {
            nArray4 = nArray7;
            nArray3 = nArray8;
            nArray2 = nArray10;
            nArray = nArray11;
        }
        X25519Field.apm((int[])pointExt2.y, (int[])pointExt2.x, (int[])nArray6, (int[])nArray5);
        X25519Field.apm((int[])pointExt.y, (int[])pointExt.x, (int[])nArray3, (int[])nArray4);
        X25519Field.mul((int[])nArray5, (int[])nArray7, (int[])nArray5);
        X25519Field.mul((int[])nArray6, (int[])nArray8, (int[])nArray6);
        X25519Field.mul((int[])pointExt2.t, (int[])pointExt.t, (int[])nArray7);
        X25519Field.mul((int[])nArray7, (int[])C_d2, (int[])nArray7);
        X25519Field.mul((int[])pointExt2.z, (int[])pointExt.z, (int[])nArray8);
        X25519Field.add((int[])nArray8, (int[])nArray8, (int[])nArray8);
        X25519Field.apm((int[])nArray6, (int[])nArray5, (int[])nArray12, (int[])nArray9);
        X25519Field.apm((int[])nArray8, (int[])nArray7, (int[])nArray, (int[])nArray2);
        X25519Field.carry((int[])nArray);
        X25519Field.mul((int[])nArray9, (int[])nArray10, (int[])pointExt2.x);
        X25519Field.mul((int[])nArray11, (int[])nArray12, (int[])pointExt2.y);
        X25519Field.mul((int[])nArray10, (int[])nArray11, (int[])pointExt2.z);
        X25519Field.mul((int[])nArray9, (int[])nArray12, (int[])pointExt2.t);
    }

    private static void pointAddPrecomp(PointPrecomp pointPrecomp, PointExt pointExt) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        X25519Field.apm((int[])pointExt.y, (int[])pointExt.x, (int[])nArray2, (int[])nArray);
        X25519Field.mul((int[])nArray, (int[])pointPrecomp.ymx_h, (int[])nArray);
        X25519Field.mul((int[])nArray2, (int[])pointPrecomp.ypx_h, (int[])nArray2);
        X25519Field.mul((int[])pointExt.t, (int[])pointPrecomp.xyd, (int[])nArray3);
        X25519Field.apm((int[])nArray2, (int[])nArray, (int[])nArray7, (int[])nArray4);
        X25519Field.apm((int[])pointExt.z, (int[])nArray3, (int[])nArray6, (int[])nArray5);
        X25519Field.carry((int[])nArray6);
        X25519Field.mul((int[])nArray4, (int[])nArray5, (int[])pointExt.x);
        X25519Field.mul((int[])nArray6, (int[])nArray7, (int[])pointExt.y);
        X25519Field.mul((int[])nArray5, (int[])nArray6, (int[])pointExt.z);
        X25519Field.mul((int[])nArray4, (int[])nArray7, (int[])pointExt.t);
    }

    private static PointExt pointCopy(PointExt pointExt) {
        PointExt pointExt2 = new PointExt(null);
        X25519Field.copy((int[])pointExt.x, (int)0, (int[])pointExt2.x, (int)0);
        X25519Field.copy((int[])pointExt.y, (int)0, (int[])pointExt2.y, (int)0);
        X25519Field.copy((int[])pointExt.z, (int)0, (int[])pointExt2.z, (int)0);
        X25519Field.copy((int[])pointExt.t, (int)0, (int[])pointExt2.t, (int)0);
        return pointExt2;
    }

    private static void pointDouble(PointExt pointExt) {
        int[] nArray = X25519Field.create();
        int[] nArray2 = X25519Field.create();
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        X25519Field.sqr((int[])pointExt.x, (int[])nArray);
        X25519Field.sqr((int[])pointExt.y, (int[])nArray2);
        X25519Field.sqr((int[])pointExt.z, (int[])nArray3);
        X25519Field.add((int[])nArray3, (int[])nArray3, (int[])nArray3);
        X25519Field.apm((int[])nArray, (int[])nArray2, (int[])nArray7, (int[])nArray6);
        X25519Field.add((int[])pointExt.x, (int[])pointExt.y, (int[])nArray4);
        X25519Field.sqr((int[])nArray4, (int[])nArray4);
        X25519Field.sub((int[])nArray7, (int[])nArray4, (int[])nArray4);
        X25519Field.add((int[])nArray3, (int[])nArray6, (int[])nArray5);
        X25519Field.carry((int[])nArray5);
        X25519Field.mul((int[])nArray4, (int[])nArray5, (int[])pointExt.x);
        X25519Field.mul((int[])nArray6, (int[])nArray7, (int[])pointExt.y);
        X25519Field.mul((int[])nArray5, (int[])nArray6, (int[])pointExt.z);
        X25519Field.mul((int[])nArray4, (int[])nArray7, (int[])pointExt.t);
    }

    private static void pointExtendXY(PointExt pointExt) {
        X25519Field.one((int[])pointExt.z);
        X25519Field.mul((int[])pointExt.x, (int[])pointExt.y, (int[])pointExt.t);
    }

    private static void pointLookup(int n2, int n3, PointPrecomp pointPrecomp) {
        int n4 = n2 * 8 * 3 * 10;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n5 = (i2 ^ n3) - 1 >> 31;
            Nat.cmov((int)10, (int)n5, (int[])precompBase, (int)n4, (int[])pointPrecomp.ypx_h, (int)0);
            Nat.cmov((int)10, (int)n5, (int[])precompBase, (int)(n4 += 10), (int[])pointPrecomp.ymx_h, (int)0);
            Nat.cmov((int)10, (int)n5, (int[])precompBase, (int)(n4 += 10), (int[])pointPrecomp.xyd, (int)0);
            n4 += 10;
        }
    }

    private static PointExt[] pointPrecompVar(PointExt pointExt, int n2) {
        PointExt pointExt2 = Ed25519.pointCopy((PointExt)pointExt);
        Ed25519.pointDouble((PointExt)pointExt2);
        PointExt[] pointExtArray = new PointExt[n2];
        pointExtArray[0] = Ed25519.pointCopy((PointExt)pointExt);
        for (int i2 = 1; i2 < n2; ++i2) {
            pointExtArray[i2] = Ed25519.pointCopy((PointExt)pointExtArray[i2 - 1]);
            Ed25519.pointAddVar((boolean)false, (PointExt)pointExt2, (PointExt)pointExtArray[i2]);
        }
        return pointExtArray;
    }

    private static void pointSetNeutral(PointExt pointExt) {
        X25519Field.zero((int[])pointExt.x);
        X25519Field.one((int[])pointExt.y);
        X25519Field.one((int[])pointExt.z);
        X25519Field.zero((int[])pointExt.t);
    }

    public static synchronized void precompute() {
        if (precompBase != null) {
            return;
        }
        PointExt pointExt = new PointExt(null);
        X25519Field.copy((int[])B_x, (int)0, (int[])pointExt.x, (int)0);
        X25519Field.copy((int[])B_y, (int)0, (int[])pointExt.y, (int)0);
        Ed25519.pointExtendXY((PointExt)pointExt);
        precompBaseTable = Ed25519.pointPrecompVar((PointExt)pointExt, (int)32);
        precompBase = new int[1920];
        int n2 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3;
            int n4;
            PointExt[] pointExtArray = new PointExt[4];
            PointExt pointExt2 = new PointExt(null);
            Ed25519.pointSetNeutral((PointExt)pointExt2);
            for (int i3 = 0; i3 < 4; ++i3) {
                Ed25519.pointAddVar((boolean)true, (PointExt)pointExt, (PointExt)pointExt2);
                Ed25519.pointDouble((PointExt)pointExt);
                pointExtArray[i3] = Ed25519.pointCopy((PointExt)pointExt);
                for (n4 = 1; n4 < 8; ++n4) {
                    Ed25519.pointDouble((PointExt)pointExt);
                }
            }
            PointExt[] pointExtArray2 = new PointExt[8];
            n4 = 0;
            pointExtArray2[n4++] = pointExt2;
            for (n3 = 0; n3 < 3; ++n3) {
                int n5 = 1 << n3;
                for (int i4 = 0; i4 < n5; ++i4) {
                    pointExtArray2[n4] = Ed25519.pointCopy((PointExt)pointExtArray2[n4 - n5]);
                    Ed25519.pointAddVar((boolean)false, (PointExt)pointExtArray[n3], (PointExt)pointExtArray2[n4++]);
                }
            }
            for (n3 = 0; n3 < 8; ++n3) {
                PointExt pointExt3 = pointExtArray2[n3];
                int[] nArray = X25519Field.create();
                int[] nArray2 = X25519Field.create();
                X25519Field.add((int[])pointExt3.z, (int[])pointExt3.z, (int[])nArray);
                X25519Field.inv((int[])nArray, (int[])nArray2);
                X25519Field.mul((int[])pointExt3.x, (int[])nArray2, (int[])nArray);
                X25519Field.mul((int[])pointExt3.y, (int[])nArray2, (int[])nArray2);
                PointPrecomp pointPrecomp = new PointPrecomp(null);
                X25519Field.apm((int[])nArray2, (int[])nArray, (int[])pointPrecomp.ypx_h, (int[])pointPrecomp.ymx_h);
                X25519Field.mul((int[])nArray, (int[])nArray2, (int[])pointPrecomp.xyd);
                X25519Field.mul((int[])pointPrecomp.xyd, (int[])C_d4, (int[])pointPrecomp.xyd);
                X25519Field.normalize((int[])pointPrecomp.ypx_h);
                X25519Field.normalize((int[])pointPrecomp.ymx_h);
                X25519Field.copy((int[])pointPrecomp.ypx_h, (int)0, (int[])precompBase, (int)n2);
                X25519Field.copy((int[])pointPrecomp.ymx_h, (int)0, (int[])precompBase, (int)(n2 += 10));
                X25519Field.copy((int[])pointPrecomp.xyd, (int)0, (int[])precompBase, (int)(n2 += 10));
                n2 += 10;
            }
        }
    }

    private static void pruneScalar(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray, n2, byArray2, 0, 32);
        byArray2[0] = (byte)(byArray2[0] & 0xF8);
        byArray2[31] = (byte)(byArray2[31] & 0x7F);
        byArray2[31] = (byte)(byArray2[31] | 0x40);
    }

    private static byte[] reduceScalar(byte[] byArray) {
        long l2 = (long)Ed25519.decode32((byte[])byArray, (int)0) & 0xFFFFFFFFL;
        long l3 = (long)(Ed25519.decode24((byte[])byArray, (int)4) << 4) & 0xFFFFFFFFL;
        long l4 = (long)Ed25519.decode32((byte[])byArray, (int)7) & 0xFFFFFFFFL;
        long l5 = (long)(Ed25519.decode24((byte[])byArray, (int)11) << 4) & 0xFFFFFFFFL;
        long l6 = (long)Ed25519.decode32((byte[])byArray, (int)14) & 0xFFFFFFFFL;
        long l7 = (long)(Ed25519.decode24((byte[])byArray, (int)18) << 4) & 0xFFFFFFFFL;
        long l8 = (long)Ed25519.decode32((byte[])byArray, (int)21) & 0xFFFFFFFFL;
        long l9 = (long)(Ed25519.decode24((byte[])byArray, (int)25) << 4) & 0xFFFFFFFFL;
        long l10 = (long)Ed25519.decode32((byte[])byArray, (int)28) & 0xFFFFFFFFL;
        long l11 = (long)(Ed25519.decode24((byte[])byArray, (int)32) << 4) & 0xFFFFFFFFL;
        long l12 = (long)Ed25519.decode32((byte[])byArray, (int)35) & 0xFFFFFFFFL;
        long l13 = (long)(Ed25519.decode24((byte[])byArray, (int)39) << 4) & 0xFFFFFFFFL;
        long l14 = (long)Ed25519.decode32((byte[])byArray, (int)42) & 0xFFFFFFFFL;
        long l15 = (long)(Ed25519.decode24((byte[])byArray, (int)46) << 4) & 0xFFFFFFFFL;
        long l16 = (long)Ed25519.decode32((byte[])byArray, (int)49) & 0xFFFFFFFFL;
        long l17 = (long)(Ed25519.decode24((byte[])byArray, (int)53) << 4) & 0xFFFFFFFFL;
        long l18 = (long)Ed25519.decode32((byte[])byArray, (int)56) & 0xFFFFFFFFL;
        long l19 = (long)(Ed25519.decode24((byte[])byArray, (int)60) << 4) & 0xFFFFFFFFL;
        long l20 = (long)byArray[63] & 0xFFL;
        l11 -= l20 * -50998291L;
        l12 -= l20 * 19280294L;
        l13 -= l20 * 127719000L;
        l14 -= l20 * -6428113L;
        l15 -= l20 * 5343L;
        l19 += l18 >> 28;
        l18 &= 0xFFFFFFFL;
        l10 -= l19 * -50998291L;
        l11 -= l19 * 19280294L;
        l12 -= l19 * 127719000L;
        l13 -= l19 * -6428113L;
        l14 -= l19 * 5343L;
        l9 -= l18 * -50998291L;
        l10 -= l18 * 19280294L;
        l11 -= l18 * 127719000L;
        l12 -= l18 * -6428113L;
        l13 -= l18 * 5343L;
        l17 += l16 >> 28;
        l16 &= 0xFFFFFFFL;
        l8 -= l17 * -50998291L;
        l9 -= l17 * 19280294L;
        l10 -= l17 * 127719000L;
        l11 -= l17 * -6428113L;
        l12 -= l17 * 5343L;
        l7 -= l16 * -50998291L;
        l8 -= l16 * 19280294L;
        l9 -= l16 * 127719000L;
        l10 -= l16 * -6428113L;
        l11 -= l16 * 5343L;
        l15 += l14 >> 28;
        l14 &= 0xFFFFFFFL;
        l6 -= l15 * -50998291L;
        l7 -= l15 * 19280294L;
        l8 -= l15 * 127719000L;
        l9 -= l15 * -6428113L;
        l10 -= l15 * 5343L;
        l14 += l13 >> 28;
        l13 &= 0xFFFFFFFL;
        l5 -= l14 * -50998291L;
        l6 -= l14 * 19280294L;
        l7 -= l14 * 127719000L;
        l8 -= l14 * -6428113L;
        l9 -= l14 * 5343L;
        l13 += l12 >> 28;
        l12 &= 0xFFFFFFFL;
        l4 -= l13 * -50998291L;
        l5 -= l13 * 19280294L;
        l6 -= l13 * 127719000L;
        l7 -= l13 * -6428113L;
        l8 -= l13 * 5343L;
        l12 += l11 >> 28;
        l11 &= 0xFFFFFFFL;
        l3 -= l12 * -50998291L;
        l4 -= l12 * 19280294L;
        l5 -= l12 * 127719000L;
        l6 -= l12 * -6428113L;
        l7 -= l12 * 5343L;
        l10 += l9 >> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >> 28;
        long l21 = (l10 &= 0xFFFFFFFL) >>> 27;
        l3 -= l11 * 19280294L;
        l4 -= l11 * 127719000L;
        l5 -= l11 * -6428113L;
        l6 -= l11 * 5343L;
        l2 &= 0xFFFFFFFL;
        l3 &= 0xFFFFFFFL;
        l4 &= 0xFFFFFFFL;
        l5 &= 0xFFFFFFFL;
        l6 &= 0xFFFFFFFL;
        l7 &= 0xFFFFFFFL;
        l8 &= 0xFFFFFFFL;
        l9 &= 0xFFFFFFFL;
        l11 = (l10 += (l9 += (l8 += (l7 += (l6 += (l5 += (l4 += (l3 += (l2 -= (l11 += l21) * -50998291L) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        l10 &= 0xFFFFFFFL;
        l3 += l11 & 0x12631A6L;
        l4 += l11 & 0x79CD658L;
        l5 += l11 & 0xFFFFFFFFFF9DEA2FL;
        l6 += l11 & 0x14DFL;
        l2 &= 0xFFFFFFFL;
        l3 &= 0xFFFFFFFL;
        l4 &= 0xFFFFFFFL;
        l5 &= 0xFFFFFFFL;
        l6 &= 0xFFFFFFFL;
        l7 &= 0xFFFFFFFL;
        l8 &= 0xFFFFFFFL;
        l10 += (l9 += (l8 += (l7 += (l6 += (l5 += (l4 += (l3 += (l2 += (l11 -= l21) & 0xFFFFFFFFFCF5D3EDL) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        byte[] byArray2 = new byte[32];
        Ed25519.encode56((long)(l2 | l3 << 28), (byte[])byArray2, (int)0);
        Ed25519.encode56((long)(l4 | l5 << 28), (byte[])byArray2, (int)7);
        Ed25519.encode56((long)(l6 | l7 << 28), (byte[])byArray2, (int)14);
        Ed25519.encode56((long)(l8 | (l9 &= 0xFFFFFFFL) << 28), (byte[])byArray2, (int)21);
        Ed25519.encode32((int)((int)l10), (byte[])byArray2, (int)28);
        return byArray2;
    }

    private static void scalarMultBase(byte[] byArray, PointExt pointExt) {
        Ed25519.precompute();
        Ed25519.pointSetNeutral((PointExt)pointExt);
        int[] nArray = new int[8];
        Ed25519.decodeScalar((byte[])byArray, (int)0, (int[])nArray);
        Nat.cadd((int)8, (int)(~nArray[0] & 1), (int[])nArray, (int[])L, (int[])nArray);
        Nat.shiftDownBit((int)8, (int[])nArray, (int)1);
        for (int i2 = 0; i2 < 8; ++i2) {
            nArray[i2] = Interleave.shuffle2((int)nArray[i2]);
        }
        PointPrecomp pointPrecomp = new PointPrecomp(null);
        int n2 = 28;
        while (true) {
            for (int i3 = 0; i3 < 8; ++i3) {
                int n3 = nArray[i3] >>> n2;
                int n4 = n3 >>> 3 & 1;
                int n5 = (n3 ^ -n4) & 7;
                Ed25519.pointLookup((int)i3, (int)n5, (PointPrecomp)pointPrecomp);
                X25519Field.cswap((int)n4, (int[])pointPrecomp.ypx_h, (int[])pointPrecomp.ymx_h);
                X25519Field.cnegate((int)n4, (int[])pointPrecomp.xyd);
                Ed25519.pointAddPrecomp((PointPrecomp)pointPrecomp, (PointExt)pointExt);
            }
            if ((n2 -= 4) < 0) break;
            Ed25519.pointDouble((PointExt)pointExt);
        }
    }

    private static void scalarMultBaseEncoded(byte[] byArray, byte[] byArray2, int n2) {
        PointExt pointExt = new PointExt(null);
        Ed25519.scalarMultBase((byte[])byArray, (PointExt)pointExt);
        Ed25519.encodePoint((PointExt)pointExt, (byte[])byArray2, (int)n2);
    }

    private static void scalarMultStraussVar(int[] nArray, int[] nArray2, PointExt pointExt, PointExt pointExt2) {
        int n2;
        Ed25519.precompute();
        int n3 = 5;
        byte[] byArray = Ed25519.getWNAF((int[])nArray, (int)7);
        byte[] byArray2 = Ed25519.getWNAF((int[])nArray2, (int)5);
        PointExt[] pointExtArray = Ed25519.pointPrecompVar((PointExt)pointExt, (int)8);
        Ed25519.pointSetNeutral((PointExt)pointExt2);
        for (n2 = 255; n2 > 0 && (byArray[n2] | byArray2[n2]) == 0; --n2) {
        }
        while (true) {
            int n4;
            int n5;
            byte by2;
            if ((by2 = byArray[n2]) != 0) {
                n5 = by2 >> 31;
                n4 = (by2 ^ n5) >>> 1;
                Ed25519.pointAddVar((n5 != 0 ? 1 : 0) != 0, (PointExt)precompBaseTable[n4], (PointExt)pointExt2);
            }
            if ((n5 = byArray2[n2]) != 0) {
                n4 = n5 >> 31;
                int n6 = (n5 ^ n4) >>> 1;
                Ed25519.pointAddVar((n4 != 0 ? 1 : 0) != 0, (PointExt)pointExtArray[n6], (PointExt)pointExt2);
            }
            if (--n2 < 0) break;
            Ed25519.pointDouble((PointExt)pointExt2);
        }
    }

    public static void sign(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5) {
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray4 = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(byArray, n2, 32);
        sHA512Digest.doFinal(byArray4, 0);
        byte[] byArray5 = new byte[32];
        Ed25519.pruneScalar((byte[])byArray4, (int)0, (byte[])byArray5);
        byte[] byArray6 = new byte[32];
        Ed25519.scalarMultBaseEncoded((byte[])byArray5, (byte[])byArray6, (int)0);
        Ed25519.implSign((SHA512Digest)sHA512Digest, (byte[])byArray4, (byte[])byArray5, (byte[])byArray6, (int)0, (byte[])byArray2, (int)n3, (int)n4, (byte[])byArray3, (int)n5);
    }

    public static void sign(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, int n4, int n5, byte[] byArray4, int n6) {
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray5 = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(byArray, n2, 32);
        sHA512Digest.doFinal(byArray5, 0);
        byte[] byArray6 = new byte[32];
        Ed25519.pruneScalar((byte[])byArray5, (int)0, (byte[])byArray6);
        Ed25519.implSign((SHA512Digest)sHA512Digest, (byte[])byArray5, (byte[])byArray6, (byte[])byArray2, (int)n3, (byte[])byArray3, (int)n4, (int)n5, (byte[])byArray4, (int)n6);
    }

    public static boolean verify(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, int n4, int n5) {
        byte[] byArray4 = Arrays.copyOfRange((byte[])byArray, (int)n2, (int)(n2 + 32));
        byte[] byArray5 = Arrays.copyOfRange((byte[])byArray, (int)(n2 + 32), (int)(n2 + 64));
        if (!Ed25519.checkPointVar((byte[])byArray4)) {
            return false;
        }
        if (!Ed25519.checkScalarVar((byte[])byArray5)) {
            return false;
        }
        PointExt pointExt = new PointExt(null);
        if (!Ed25519.decodePointVar((byte[])byArray2, (int)n3, (boolean)true, (PointExt)pointExt)) {
            return false;
        }
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray6 = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.update(byArray4, 0, 32);
        sHA512Digest.update(byArray2, n3, 32);
        sHA512Digest.update(byArray3, n4, n5);
        sHA512Digest.doFinal(byArray6, 0);
        byte[] byArray7 = Ed25519.reduceScalar((byte[])byArray6);
        int[] nArray = new int[8];
        Ed25519.decodeScalar((byte[])byArray5, (int)0, (int[])nArray);
        int[] nArray2 = new int[8];
        Ed25519.decodeScalar((byte[])byArray7, (int)0, (int[])nArray2);
        PointExt pointExt2 = new PointExt(null);
        Ed25519.scalarMultStraussVar((int[])nArray, (int[])nArray2, (PointExt)pointExt, (PointExt)pointExt2);
        byte[] byArray8 = new byte[32];
        Ed25519.encodePoint((PointExt)pointExt2, (byte[])byArray8, (int)0);
        return Arrays.areEqual((byte[])byArray8, (byte[])byArray4);
    }
}

