/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP521R1Curve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP521R1Field;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Mod;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class SecP521R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = SecP521R1Curve.q;
    protected int[] x;

    public SecP521R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP521R1FieldElement");
        }
        this.x = SecP521R1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP521R1FieldElement() {
        this.x = Nat.create((int)17);
    }

    protected SecP521R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat.isZero((int)17, (int[])this.x);
    }

    public boolean isOne() {
        return Nat.isOne((int)17, (int[])this.x);
    }

    public boolean testBitZero() {
        return Nat.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat.toBigInteger((int)17, (int[])this.x);
    }

    public String getFieldName() {
        return "SecP521R1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)17);
        SecP521R1Field.add((int[])this.x, (int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat.create((int)17);
        SecP521R1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)17);
        SecP521R1Field.subtract((int[])this.x, (int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)17);
        SecP521R1Field.multiply((int[])this.x, (int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)17);
        Mod.invert((int[])SecP521R1Field.P, (int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP521R1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat.create((int)17);
        SecP521R1Field.negate((int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat.create((int)17);
        SecP521R1Field.square((int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat.create((int)17);
        Mod.invert((int[])SecP521R1Field.P, (int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat.isZero((int)17, (int[])nArray) || Nat.isOne((int)17, (int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat.create((int)17);
        int[] nArray3 = Nat.create((int)17);
        SecP521R1Field.squareN((int[])nArray, (int)519, (int[])nArray2);
        SecP521R1Field.square((int[])nArray2, (int[])nArray3);
        return Nat.eq((int)17, (int[])nArray, (int[])nArray3) ? new SecP521R1FieldElement(nArray2) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP521R1FieldElement)) {
            return false;
        }
        SecP521R1FieldElement secP521R1FieldElement = (SecP521R1FieldElement)object;
        return Nat.eq((int)17, (int[])this.x, (int[])secP521R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)17);
    }
}

