/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECLookupTable;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP384R1FieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP384R1Point;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.encoders.Hex;

public class SecP384R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF"));
    private static final int SecP384R1_DEFAULT_COORDS = 2;
    protected SecP384R1Point infinity = new SecP384R1Point((ECCurve)this, null, null);

    public SecP384R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode((String)"B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF")));
        this.order = new BigInteger(1, Hex.decode((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP384R1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP384R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecP384R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecP384R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        int n4 = 12;
        int[] nArray = new int[n3 * 12 * 2];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat.copy((int)12, (int[])((SecP384R1FieldElement)eCPoint.getRawXCoord()).x, (int)0, (int[])nArray, (int)n5);
            Nat.copy((int)12, (int[])((SecP384R1FieldElement)eCPoint.getRawYCoord()).x, (int)0, (int[])nArray, (int)(n5 += 12));
            n5 += 12;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

