/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP192R1Curve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP192R1Field;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Mod;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat192;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class SecP192R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = SecP192R1Curve.q;
    protected int[] x;

    public SecP192R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP192R1FieldElement");
        }
        this.x = SecP192R1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP192R1FieldElement() {
        this.x = Nat192.create();
    }

    protected SecP192R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat192.isZero((int[])this.x);
    }

    public boolean isOne() {
        return Nat192.isOne((int[])this.x);
    }

    public boolean testBitZero() {
        return Nat192.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat192.toBigInteger((int[])this.x);
    }

    public String getFieldName() {
        return "SecP192R1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192R1Field.add((int[])this.x, (int[])((SecP192R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat192.create();
        SecP192R1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192R1Field.subtract((int[])this.x, (int[])((SecP192R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192R1Field.multiply((int[])this.x, (int[])((SecP192R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        Mod.invert((int[])SecP192R1Field.P, (int[])((SecP192R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP192R1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat192.create();
        SecP192R1Field.negate((int[])this.x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat192.create();
        SecP192R1Field.square((int[])this.x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat192.create();
        Mod.invert((int[])SecP192R1Field.P, (int[])this.x, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat192.isZero((int[])nArray) || Nat192.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat192.create();
        int[] nArray3 = Nat192.create();
        SecP192R1Field.square((int[])nArray, (int[])nArray2);
        SecP192R1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        SecP192R1Field.squareN((int[])nArray2, (int)2, (int[])nArray3);
        SecP192R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        SecP192R1Field.squareN((int[])nArray3, (int)4, (int[])nArray2);
        SecP192R1Field.multiply((int[])nArray2, (int[])nArray3, (int[])nArray2);
        SecP192R1Field.squareN((int[])nArray2, (int)8, (int[])nArray3);
        SecP192R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        SecP192R1Field.squareN((int[])nArray3, (int)16, (int[])nArray2);
        SecP192R1Field.multiply((int[])nArray2, (int[])nArray3, (int[])nArray2);
        SecP192R1Field.squareN((int[])nArray2, (int)32, (int[])nArray3);
        SecP192R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        SecP192R1Field.squareN((int[])nArray3, (int)64, (int[])nArray2);
        SecP192R1Field.multiply((int[])nArray2, (int[])nArray3, (int[])nArray2);
        SecP192R1Field.squareN((int[])nArray2, (int)62, (int[])nArray2);
        SecP192R1Field.square((int[])nArray2, (int[])nArray3);
        return Nat192.eq((int[])nArray, (int[])nArray3) ? new SecP192R1FieldElement(nArray2) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP192R1FieldElement)) {
            return false;
        }
        SecP192R1FieldElement secP192R1FieldElement = (SecP192R1FieldElement)object;
        return Nat192.eq((int[])this.x, (int[])secP192R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)6);
    }
}

