/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec;

import java.math.BigInteger;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECAlgorithms;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECConstants;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.PreCompCallback;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ValidityPrecompInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ECPoint {
    protected static ECFieldElement[] EMPTY_ZS = new ECFieldElement[0];
    protected ECCurve curve;
    protected ECFieldElement x;
    protected ECFieldElement y;
    protected ECFieldElement[] zs;
    protected boolean withCompression;
    protected Hashtable preCompTable = null;

    protected static ECFieldElement[] getInitialZCoords(ECCurve eCCurve) {
        int n2 = null == eCCurve ? 0 : eCCurve.getCoordinateSystem();
        switch (n2) {
            case 0: 
            case 5: {
                return EMPTY_ZS;
            }
        }
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(ECConstants.ONE);
        switch (n2) {
            case 1: 
            case 2: 
            case 6: {
                return new ECFieldElement[]{eCFieldElement};
            }
            case 3: {
                return new ECFieldElement[]{eCFieldElement, eCFieldElement, eCFieldElement};
            }
            case 4: {
                return new ECFieldElement[]{eCFieldElement, eCCurve.getA()};
            }
        }
        throw new IllegalArgumentException("unknown coordinate system");
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, ECPoint.getInitialZCoords((ECCurve)eCCurve));
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
        this.zs = eCFieldElementArray;
    }

    protected abstract boolean satisfiesCurveEquation();

    protected boolean satisfiesOrder() {
        if (ECConstants.ONE.equals(this.curve.getCofactor())) {
            return true;
        }
        BigInteger bigInteger = this.curve.getOrder();
        return bigInteger == null || ECAlgorithms.referenceMultiply((ECPoint)this, (BigInteger)bigInteger).isInfinity();
    }

    public final ECPoint getDetachedPoint() {
        return this.normalize().detach();
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    protected abstract ECPoint detach();

    protected int getCurveCoordinateSystem() {
        return null == this.curve ? 0 : this.curve.getCoordinateSystem();
    }

    public ECFieldElement getAffineXCoord() {
        this.checkNormalized();
        return this.getXCoord();
    }

    public ECFieldElement getAffineYCoord() {
        this.checkNormalized();
        return this.getYCoord();
    }

    public ECFieldElement getXCoord() {
        return this.x;
    }

    public ECFieldElement getYCoord() {
        return this.y;
    }

    public ECFieldElement getZCoord(int n2) {
        return n2 < 0 || n2 >= this.zs.length ? null : this.zs[n2];
    }

    public ECFieldElement[] getZCoords() {
        int n2 = this.zs.length;
        if (n2 == 0) {
            return EMPTY_ZS;
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n2];
        System.arraycopy(this.zs, 0, eCFieldElementArray, 0, n2);
        return eCFieldElementArray;
    }

    public final ECFieldElement getRawXCoord() {
        return this.x;
    }

    public final ECFieldElement getRawYCoord() {
        return this.y;
    }

    protected final ECFieldElement[] getRawZCoords() {
        return this.zs;
    }

    protected void checkNormalized() {
        if (!this.isNormalized()) {
            throw new IllegalStateException("point not in normal form");
        }
    }

    public boolean isNormalized() {
        int n2 = this.getCurveCoordinateSystem();
        return n2 == 0 || n2 == 5 || this.isInfinity() || this.zs[0].isOne();
    }

    public ECPoint normalize() {
        if (this.isInfinity()) {
            return this;
        }
        switch (this.getCurveCoordinateSystem()) {
            case 0: 
            case 5: {
                return this;
            }
        }
        ECFieldElement eCFieldElement = this.getZCoord(0);
        if (eCFieldElement.isOne()) {
            return this;
        }
        return this.normalize(eCFieldElement.invert());
    }

    ECPoint normalize(ECFieldElement eCFieldElement) {
        switch (this.getCurveCoordinateSystem()) {
            case 1: 
            case 6: {
                return this.createScaledPoint(eCFieldElement, eCFieldElement);
            }
            case 2: 
            case 3: 
            case 4: {
                ECFieldElement eCFieldElement2 = eCFieldElement.square();
                ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                return this.createScaledPoint(eCFieldElement2, eCFieldElement3);
            }
        }
        throw new IllegalStateException("not a projective coordinate system");
    }

    protected ECPoint createScaledPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().multiply(eCFieldElement2), this.withCompression);
    }

    public boolean isInfinity() {
        return this.x == null || this.y == null || this.zs.length > 0 && this.zs[0].isZero();
    }

    public boolean isCompressed() {
        return this.withCompression;
    }

    public boolean isValid() {
        return this.implIsValid(true);
    }

    boolean isValidPartial() {
        return this.implIsValid(false);
    }

    boolean implIsValid(boolean bl2) {
        if (this.isInfinity()) {
            return true;
        }
        ValidityPrecompInfo validityPrecompInfo = (ValidityPrecompInfo)this.getCurve().precompute(this, "bc_validity", (PreCompCallback)new /* Unavailable Anonymous Inner Class!! */);
        return !validityPrecompInfo.hasFailed();
    }

    public ECPoint scaleX(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord(), this.getRawZCoords(), this.withCompression);
    }

    public ECPoint scaleY(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord(), this.getRawYCoord().multiply(eCFieldElement), this.getRawZCoords(), this.withCompression);
    }

    public boolean equals(ECPoint eCPoint) {
        if (null == eCPoint) {
            return false;
        }
        ECCurve eCCurve = this.getCurve();
        ECCurve eCCurve2 = eCPoint.getCurve();
        boolean bl2 = null == eCCurve;
        boolean bl3 = null == eCCurve2;
        boolean bl4 = this.isInfinity();
        boolean bl5 = eCPoint.isInfinity();
        if (bl4 || bl5) {
            return bl4 && bl5 && (bl2 || bl3 || eCCurve.equals(eCCurve2));
        }
        ECPoint eCPoint2 = this;
        ECPoint eCPoint3 = eCPoint;
        if (!bl2 || !bl3) {
            if (bl2) {
                eCPoint3 = eCPoint3.normalize();
            } else if (bl3) {
                eCPoint2 = eCPoint2.normalize();
            } else {
                if (!eCCurve.equals(eCCurve2)) {
                    return false;
                }
                ECPoint[] eCPointArray = new ECPoint[]{this, eCCurve.importPoint(eCPoint3)};
                eCCurve.normalizeAll(eCPointArray);
                eCPoint2 = eCPointArray[0];
                eCPoint3 = eCPointArray[1];
            }
        }
        return eCPoint2.getXCoord().equals(eCPoint3.getXCoord()) && eCPoint2.getYCoord().equals(eCPoint3.getYCoord());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        return this.equals((ECPoint)object);
    }

    public int hashCode() {
        int n2;
        ECCurve eCCurve = this.getCurve();
        int n3 = n2 = null == eCCurve ? 0 : ~eCCurve.hashCode();
        if (!this.isInfinity()) {
            ECPoint eCPoint = this.normalize();
            n2 ^= eCPoint.getXCoord().hashCode() * 17;
            n2 ^= eCPoint.getYCoord().hashCode() * 257;
        }
        return n2;
    }

    public String toString() {
        if (this.isInfinity()) {
            return "INF";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getRawXCoord());
        stringBuffer.append(',');
        stringBuffer.append(this.getRawYCoord());
        for (int i2 = 0; i2 < this.zs.length; ++i2) {
            stringBuffer.append(',');
            stringBuffer.append(this.zs[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.withCompression);
    }

    public byte[] getEncoded(boolean bl2) {
        if (this.isInfinity()) {
            return new byte[1];
        }
        ECPoint eCPoint = this.normalize();
        byte[] byArray = eCPoint.getXCoord().getEncoded();
        if (bl2) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = (byte)(eCPoint.getCompressionYTilde() ? 3 : 2);
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        byte[] byArray3 = eCPoint.getYCoord().getEncoded();
        byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
        byArray4[0] = 4;
        System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
        return byArray4;
    }

    protected abstract boolean getCompressionYTilde();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint subtract(ECPoint var1);

    public ECPoint timesPow2(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("'e' cannot be negative");
        }
        ECPoint eCPoint = this;
        while (--n2 >= 0) {
            eCPoint = eCPoint.twice();
        }
        return eCPoint;
    }

    public abstract ECPoint twice();

    public ECPoint twicePlus(ECPoint eCPoint) {
        return this.twice().add(eCPoint);
    }

    public ECPoint threeTimes() {
        return this.twicePlus(this);
    }

    public ECPoint multiply(BigInteger bigInteger) {
        return this.getCurve().getMultiplier().multiply(this, bigInteger);
    }
}

