/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertSelector;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.CRLDistPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.DistributionPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.DistributionPointName;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extension;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralName;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralNames;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.TargetInformation;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXCRLStore;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXCertStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXExtendedBuilderParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXExtendedParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.JcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.exception.ExtCertPathValidatorException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.AnnotatedException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.CertPathValidatorUtilities;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.CertStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.RFC3280CertPathUtilities;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.ReasonsMask;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.PKIXAttrCertChecker;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509AttributeCertificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509CertStoreSelector;

/*
 * Exception performing whole class analysis ignored.
 */
class RFC3281CertPathUtilities {
    private static final String TARGET_INFORMATION = Extension.targetInformation.getId();
    private static final String NO_REV_AVAIL = Extension.noRevAvail.getId();
    private static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    private static final String AUTHORITY_INFO_ACCESS = Extension.authorityInfoAccess.getId();

    RFC3281CertPathUtilities() {
    }

    protected static void processAttrCert7(X509AttributeCertificate x509AttributeCertificate, CertPath certPath, CertPath certPath2, PKIXExtendedParameters pKIXExtendedParameters, Set set) throws CertPathValidatorException {
        Set set2 = x509AttributeCertificate.getCriticalExtensionOIDs();
        if (set2.contains(TARGET_INFORMATION)) {
            try {
                TargetInformation.getInstance((Object)CertPathValidatorUtilities.getExtensionValue((X509Extension)x509AttributeCertificate, (String)TARGET_INFORMATION));
            }
            catch (AnnotatedException annotatedException) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", (Throwable)annotatedException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", (Throwable)illegalArgumentException);
            }
        }
        set2.remove(TARGET_INFORMATION);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((PKIXAttrCertChecker)iterator.next()).check(x509AttributeCertificate, certPath, certPath2, (Collection)set2);
        }
        if (!set2.isEmpty()) {
            throw new CertPathValidatorException("Attribute certificate contains unsupported critical extensions: " + set2);
        }
    }

    protected static void checkCRLs(X509AttributeCertificate x509AttributeCertificate, PKIXExtendedParameters pKIXExtendedParameters, X509Certificate x509Certificate, Date date, List list, JcaJceHelper jcaJceHelper) throws CertPathValidatorException {
        if (pKIXExtendedParameters.isRevocationEnabled()) {
            if (x509AttributeCertificate.getExtensionValue(NO_REV_AVAIL) == null) {
                PKIXExtendedParameters pKIXExtendedParameters2;
                Object object;
                CRLDistPoint cRLDistPoint = null;
                try {
                    cRLDistPoint = CRLDistPoint.getInstance((Object)CertPathValidatorUtilities.getExtensionValue((X509Extension)x509AttributeCertificate, (String)CRL_DISTRIBUTION_POINTS));
                }
                catch (AnnotatedException annotatedException) {
                    throw new CertPathValidatorException("CRL distribution point extension could not be read.", annotatedException);
                }
                ArrayList arrayList = new ArrayList();
                try {
                    arrayList.addAll(CertPathValidatorUtilities.getAdditionalStoresFromCRLDistributionPoint((CRLDistPoint)cRLDistPoint, (Map)pKIXExtendedParameters.getNamedCRLStoreMap()));
                }
                catch (AnnotatedException annotatedException) {
                    throw new CertPathValidatorException("No additional CRL locations could be decoded from CRL distribution point extension.", annotatedException);
                }
                PKIXExtendedParameters.Builder builder = new PKIXExtendedParameters.Builder(pKIXExtendedParameters);
                CertStatus certStatus = arrayList.iterator();
                while (certStatus.hasNext()) {
                    builder.addCRLStore((PKIXCRLStore)arrayList);
                }
                pKIXExtendedParameters = builder.build();
                certStatus = new CertStatus();
                ReasonsMask reasonsMask = new ReasonsMask();
                AnnotatedException annotatedException = null;
                boolean bl2 = false;
                if (cRLDistPoint != null) {
                    object = null;
                    try {
                        object = cRLDistPoint.getDistributionPoints();
                    }
                    catch (Exception exception) {
                        throw new ExtCertPathValidatorException("Distribution points could not be read.", (Throwable)exception);
                    }
                    try {
                        for (int i2 = 0; i2 < ((DistributionPoint[])object).length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i2) {
                            pKIXExtendedParameters2 = (PKIXExtendedParameters)pKIXExtendedParameters.clone();
                            RFC3281CertPathUtilities.checkCRL((DistributionPoint)object[i2], (X509AttributeCertificate)x509AttributeCertificate, (PKIXExtendedParameters)pKIXExtendedParameters2, (Date)date, (X509Certificate)x509Certificate, (CertStatus)certStatus, (ReasonsMask)reasonsMask, (List)list, (JcaJceHelper)jcaJceHelper);
                            bl2 = true;
                        }
                    }
                    catch (AnnotatedException annotatedException2) {
                        annotatedException = new AnnotatedException("No valid CRL for distribution point found.", (Throwable)annotatedException2);
                    }
                }
                if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
                    try {
                        object = null;
                        try {
                            object = new ASN1InputStream(((X500Principal)x509AttributeCertificate.getIssuer().getPrincipals()[0]).getEncoded()).readObject();
                        }
                        catch (Exception exception) {
                            throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", (Throwable)exception);
                        }
                        DistributionPoint distributionPoint = new DistributionPoint(new DistributionPointName(0, (ASN1Encodable)new GeneralNames(new GeneralName(4, (ASN1Encodable)object))), null, null);
                        pKIXExtendedParameters2 = (PKIXExtendedParameters)pKIXExtendedParameters.clone();
                        RFC3281CertPathUtilities.checkCRL((DistributionPoint)distributionPoint, (X509AttributeCertificate)x509AttributeCertificate, (PKIXExtendedParameters)pKIXExtendedParameters2, (Date)date, (X509Certificate)x509Certificate, (CertStatus)certStatus, (ReasonsMask)reasonsMask, (List)list, (JcaJceHelper)jcaJceHelper);
                        bl2 = true;
                    }
                    catch (AnnotatedException annotatedException3) {
                        annotatedException = new AnnotatedException("No valid CRL for distribution point found.", (Throwable)annotatedException3);
                    }
                }
                if (!bl2) {
                    throw new ExtCertPathValidatorException("No valid CRL found.", annotatedException);
                }
                if (certStatus.getCertStatus() != 11) {
                    object = "Attribute certificate revocation after " + certStatus.getRevocationDate();
                    object = (String)object + ", reason: " + RFC3280CertPathUtilities.crlReasons[certStatus.getCertStatus()];
                    throw new CertPathValidatorException((String)object);
                }
                if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
                    certStatus.setCertStatus(12);
                }
                if (certStatus.getCertStatus() == 12) {
                    throw new CertPathValidatorException("Attribute certificate status could not be determined.");
                }
            } else if (x509AttributeCertificate.getExtensionValue(CRL_DISTRIBUTION_POINTS) != null || x509AttributeCertificate.getExtensionValue(AUTHORITY_INFO_ACCESS) != null) {
                throw new CertPathValidatorException("No rev avail extension is set, but also an AC revocation pointer.");
            }
        }
    }

    protected static void additionalChecks(X509AttributeCertificate x509AttributeCertificate, Set set, Set set2) throws CertPathValidatorException {
        for (String string : set) {
            if (x509AttributeCertificate.getAttributes(string) == null) continue;
            throw new CertPathValidatorException("Attribute certificate contains prohibited attribute: " + string + ".");
        }
        for (String string : set2) {
            if (x509AttributeCertificate.getAttributes(string) != null) continue;
            throw new CertPathValidatorException("Attribute certificate does not contain necessary attribute: " + string + ".");
        }
    }

    protected static void processAttrCert5(X509AttributeCertificate x509AttributeCertificate, PKIXExtendedParameters pKIXExtendedParameters) throws CertPathValidatorException {
        try {
            x509AttributeCertificate.checkValidity(CertPathValidatorUtilities.getValidDate((PKIXExtendedParameters)pKIXExtendedParameters));
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", (Throwable)certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", (Throwable)certificateNotYetValidException);
        }
    }

    protected static void processAttrCert4(X509Certificate x509Certificate, Set set) throws CertPathValidatorException {
        Set set2 = set;
        boolean bl2 = false;
        for (TrustAnchor trustAnchor : set2) {
            if (!x509Certificate.getSubjectX500Principal().getName("RFC2253").equals(trustAnchor.getCAName()) && !x509Certificate.equals(trustAnchor.getTrustedCert())) continue;
            bl2 = true;
        }
        if (!bl2) {
            throw new CertPathValidatorException("Attribute certificate issuer is not directly trusted.");
        }
    }

    protected static void processAttrCert3(X509Certificate x509Certificate, PKIXExtendedParameters pKIXExtendedParameters) throws CertPathValidatorException {
        if (x509Certificate.getKeyUsage() != null && !x509Certificate.getKeyUsage()[0] && !x509Certificate.getKeyUsage()[1]) {
            throw new CertPathValidatorException("Attribute certificate issuer public key cannot be used to validate digital signatures.");
        }
        if (x509Certificate.getBasicConstraints() != -1) {
            throw new CertPathValidatorException("Attribute certificate issuer is also a public key certificate issuer.");
        }
    }

    protected static CertPathValidatorResult processAttrCert2(CertPath certPath, PKIXExtendedParameters pKIXExtendedParameters) throws CertPathValidatorException {
        CertPathValidator certPathValidator = null;
        try {
            certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ExtCertPathValidatorException("Support class could not be created.", (Throwable)noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ExtCertPathValidatorException("Support class could not be created.", (Throwable)noSuchAlgorithmException);
        }
        try {
            return certPathValidator.validate(certPath, (CertPathParameters)pKIXExtendedParameters);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new ExtCertPathValidatorException("Certification path for issuer certificate of attribute certificate could not be validated.", (Throwable)certPathValidatorException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected static CertPath processAttrCert1(X509AttributeCertificate x509AttributeCertificate, PKIXExtendedParameters pKIXExtendedParameters) throws CertPathValidatorException {
        int n2;
        ExtCertPathValidatorException extCertPathValidatorException;
        X509CertSelector x509CertSelector;
        CertPathBuilderResult certPathBuilderResult = null;
        HashSet hashSet = new HashSet();
        if (x509AttributeCertificate.getHolder().getIssuer() != null) {
            x509CertSelector = new X509CertSelector();
            x509CertSelector.setSerialNumber(x509AttributeCertificate.getHolder().getSerialNumber());
            extCertPathValidatorException = x509AttributeCertificate.getHolder().getIssuer();
            for (n2 = 0; n2 < ((Principal[])extCertPathValidatorException).length; ++n2) {
                try {
                    if (extCertPathValidatorException[n2] instanceof X500Principal) {
                        x509CertSelector.setIssuer(((X500Principal)extCertPathValidatorException[n2]).getEncoded());
                    }
                    hashSet.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)new PKIXCertStoreSelector.Builder((CertSelector)x509CertSelector).build(), (List)pKIXExtendedParameters.getCertStores()));
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", (Throwable)annotatedException);
                }
                catch (IOException iOException) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", (Throwable)iOException);
                }
            }
            if (hashSet.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in base certificate ID for attribute certificate cannot be found.");
            }
        }
        if (x509AttributeCertificate.getHolder().getEntityNames() != null) {
            x509CertSelector = new X509CertStoreSelector();
            extCertPathValidatorException = x509AttributeCertificate.getHolder().getEntityNames();
            for (n2 = 0; n2 < ((Principal[])extCertPathValidatorException).length; ++n2) {
                try {
                    if (extCertPathValidatorException[n2] instanceof X500Principal) {
                        x509CertSelector.setIssuer(((X500Principal)extCertPathValidatorException[n2]).getEncoded());
                    }
                    hashSet.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)new PKIXCertStoreSelector.Builder((CertSelector)x509CertSelector).build(), (List)pKIXExtendedParameters.getCertStores()));
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", (Throwable)annotatedException);
                }
                catch (IOException iOException) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", (Throwable)iOException);
                }
            }
            if (hashSet.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in entity name for attribute certificate cannot be found.");
            }
        }
        x509CertSelector = new PKIXExtendedParameters.Builder(pKIXExtendedParameters);
        extCertPathValidatorException = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            X509CertStoreSelector x509CertStoreSelector = new X509CertStoreSelector();
            x509CertStoreSelector.setCertificate((X509Certificate)iterator.next());
            x509CertSelector.setTargetConstraints(new PKIXCertStoreSelector.Builder((CertSelector)x509CertStoreSelector).build());
            CertPathBuilder certPathBuilder = null;
            try {
                certPathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new ExtCertPathValidatorException("Support class could not be created.", (Throwable)noSuchProviderException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ExtCertPathValidatorException("Support class could not be created.", (Throwable)noSuchAlgorithmException);
            }
            try {
                certPathBuilderResult = certPathBuilder.build((CertPathParameters)new PKIXExtendedBuilderParameters.Builder(x509CertSelector.build()).build());
            }
            catch (CertPathBuilderException certPathBuilderException) {
                extCertPathValidatorException = new ExtCertPathValidatorException("Certification path for public key certificate of attribute certificate could not be build.", (Throwable)certPathBuilderException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
            }
        }
        if (extCertPathValidatorException != null) {
            throw extCertPathValidatorException;
        }
        return certPathBuilderResult.getCertPath();
    }

    private static void checkCRL(DistributionPoint distributionPoint, X509AttributeCertificate x509AttributeCertificate, PKIXExtendedParameters pKIXExtendedParameters, Date date, X509Certificate x509Certificate, CertStatus certStatus, ReasonsMask reasonsMask, List list, JcaJceHelper jcaJceHelper) throws AnnotatedException {
        if (x509AttributeCertificate.getExtensionValue(X509Extensions.NoRevAvail.getId()) != null) {
            return;
        }
        Date date2 = new Date(System.currentTimeMillis());
        if (date.getTime() > date2.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set set = CertPathValidatorUtilities.getCompleteCRLs((DistributionPoint)distributionPoint, (Object)x509AttributeCertificate, (Date)date2, (PKIXExtendedParameters)pKIXExtendedParameters);
        boolean bl2 = false;
        AnnotatedException annotatedException = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                X509CRL x509CRL = (X509CRL)iterator.next();
                ReasonsMask reasonsMask2 = RFC3280CertPathUtilities.processCRLD((X509CRL)x509CRL, (DistributionPoint)distributionPoint);
                if (!reasonsMask2.hasNewReasons(reasonsMask)) continue;
                Set set2 = RFC3280CertPathUtilities.processCRLF((X509CRL)x509CRL, (Object)x509AttributeCertificate, null, null, (PKIXExtendedParameters)pKIXExtendedParameters, (List)list, (JcaJceHelper)jcaJceHelper);
                PublicKey publicKey = RFC3280CertPathUtilities.processCRLG((X509CRL)x509CRL, (Set)set2);
                X509CRL x509CRL2 = null;
                if (pKIXExtendedParameters.isUseDeltasEnabled()) {
                    Set set3 = CertPathValidatorUtilities.getDeltaCRLs((Date)date2, (X509CRL)x509CRL, (List)pKIXExtendedParameters.getCertStores(), (List)pKIXExtendedParameters.getCRLStores());
                    x509CRL2 = RFC3280CertPathUtilities.processCRLH((Set)set3, (PublicKey)publicKey);
                }
                if (pKIXExtendedParameters.getValidityModel() != 1 && x509AttributeCertificate.getNotAfter().getTime() < x509CRL.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3280CertPathUtilities.processCRLB1((DistributionPoint)distributionPoint, (Object)x509AttributeCertificate, (X509CRL)x509CRL);
                RFC3280CertPathUtilities.processCRLB2((DistributionPoint)distributionPoint, (Object)x509AttributeCertificate, (X509CRL)x509CRL);
                RFC3280CertPathUtilities.processCRLC((X509CRL)x509CRL2, (X509CRL)x509CRL, (PKIXExtendedParameters)pKIXExtendedParameters);
                RFC3280CertPathUtilities.processCRLI((Date)date, (X509CRL)x509CRL2, (Object)x509AttributeCertificate, (CertStatus)certStatus, (PKIXExtendedParameters)pKIXExtendedParameters);
                RFC3280CertPathUtilities.processCRLJ((Date)date, (X509CRL)x509CRL, (Object)x509AttributeCertificate, (CertStatus)certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonsMask.addReasons(reasonsMask2);
                bl2 = true;
            }
            catch (AnnotatedException annotatedException2) {
                annotatedException = annotatedException2;
            }
        }
        if (!bl2) {
            throw annotatedException;
        }
    }
}

