/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extension;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXCertStore;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXCertStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXExtendedBuilderParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXExtendedParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.x509.CertificateFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.exception.ExtCertPathBuilderException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.AnnotatedException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.CertPathValidatorUtilities;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.PKIXCertPathValidatorSpi;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.ExtendedPKIXBuilderParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.ExtendedPKIXParameters;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    private Exception certPathException;

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        PKIXExtendedBuilderParameters pKIXExtendedBuilderParameters;
        Object object;
        Object object2;
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters;
        Object object3;
        if (certPathParameters instanceof PKIXBuilderParameters) {
            object3 = new PKIXExtendedParameters.Builder((PKIXParameters)((PKIXBuilderParameters)certPathParameters));
            if (certPathParameters instanceof ExtendedPKIXParameters) {
                extendedPKIXBuilderParameters = (ExtendedPKIXBuilderParameters)certPathParameters;
                object2 = extendedPKIXBuilderParameters.getAdditionalStores().iterator();
                while (object2.hasNext()) {
                    object3.addCertificateStore((PKIXCertStore)object2.next());
                }
                object = new PKIXExtendedBuilderParameters.Builder(object3.build());
                object.addExcludedCerts(extendedPKIXBuilderParameters.getExcludedCerts());
                object.setMaxPathLength(extendedPKIXBuilderParameters.getMaxPathLength());
            } else {
                object = new PKIXExtendedBuilderParameters.Builder((PKIXBuilderParameters)certPathParameters);
            }
            pKIXExtendedBuilderParameters = object.build();
        } else if (certPathParameters instanceof PKIXExtendedBuilderParameters) {
            pKIXExtendedBuilderParameters = (PKIXExtendedBuilderParameters)certPathParameters;
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + PKIXExtendedBuilderParameters.class.getName() + ".");
        }
        extendedPKIXBuilderParameters = new ArrayList();
        PKIXCertStoreSelector pKIXCertStoreSelector = pKIXExtendedBuilderParameters.getBaseParameters().getTargetConstraints();
        try {
            object3 = CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)pKIXCertStoreSelector, (List)pKIXExtendedBuilderParameters.getBaseParameters().getCertificateStores());
            object3.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)pKIXCertStoreSelector, (List)pKIXExtendedBuilderParameters.getBaseParameters().getCertStores()));
        }
        catch (AnnotatedException annotatedException) {
            throw new ExtCertPathBuilderException("Error finding target certificate.", (Throwable)annotatedException);
        }
        if (object3.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        object = object3.iterator();
        while (object.hasNext() && certPathBuilderResult == null) {
            object2 = (X509Certificate)object.next();
            certPathBuilderResult = this.build((X509Certificate)object2, pKIXExtendedBuilderParameters, (List)extendedPKIXBuilderParameters);
        }
        if (certPathBuilderResult == null && this.certPathException != null) {
            if (this.certPathException instanceof AnnotatedException) {
                throw new CertPathBuilderException(this.certPathException.getMessage(), this.certPathException.getCause());
            }
            throw new CertPathBuilderException("Possible certificate chain could not be validated.", this.certPathException);
        }
        if (certPathBuilderResult == null && this.certPathException == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    protected CertPathBuilderResult build(X509Certificate x509Certificate, PKIXExtendedBuilderParameters pKIXExtendedBuilderParameters, List list) {
        PKIXCertPathValidatorSpi pKIXCertPathValidatorSpi;
        CertificateFactory certificateFactory;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (pKIXExtendedBuilderParameters.getExcludedCerts().contains(x509Certificate)) {
            return null;
        }
        if (pKIXExtendedBuilderParameters.getMaxPathLength() != -1 && list.size() - 1 > pKIXExtendedBuilderParameters.getMaxPathLength()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            certificateFactory = new CertificateFactory();
            pKIXCertPathValidatorSpi = new PKIXCertPathValidatorSpi();
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (CertPathValidatorUtilities.isIssuerTrustAnchor((X509Certificate)x509Certificate, (Set)pKIXExtendedBuilderParameters.getBaseParameters().getTrustAnchors(), (String)pKIXExtendedBuilderParameters.getBaseParameters().getSigProvider())) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
                try {
                    certPath = certificateFactory.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Certification path could not be constructed from certificate list.", (Throwable)exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)pKIXCertPathValidatorSpi.engineValidate(certPath, (CertPathParameters)pKIXExtendedBuilderParameters);
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Certification path could not be validated.", (Throwable)exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(pKIXExtendedBuilderParameters.getBaseParameters().getCertificateStores());
            try {
                arrayList.addAll(CertPathValidatorUtilities.getAdditionalStoresFromAltNames((byte[])x509Certificate.getExtensionValue(Extension.issuerAlternativeName.getId()), (Map)pKIXExtendedBuilderParameters.getBaseParameters().getNamedCertificateStoreMap()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new AnnotatedException("No additional X.509 stores can be added from certificate locations.", (Throwable)certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(CertPathValidatorUtilities.findIssuerCerts((X509Certificate)x509Certificate, (List)pKIXExtendedBuilderParameters.getBaseParameters().getCertStores(), arrayList));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Cannot find issuer certificate for certificate in certification path.", (Throwable)annotatedException);
            }
            if (hashSet.isEmpty()) {
                throw new AnnotatedException("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.build(x509Certificate2, pKIXExtendedBuilderParameters, list);
            }
        }
        catch (AnnotatedException annotatedException) {
            this.certPathException = annotatedException;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

