/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extension;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXCertStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXExtendedBuilderParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.exception.ExtCertPathBuilderException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.AnnotatedException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.CertPathValidatorUtilities;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Selector;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Store;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.StoreException;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.ExtendedPKIXBuilderParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.ExtendedPKIXParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509AttributeCertStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509AttributeCertificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509CertStoreSelector;

/*
 * Exception performing whole class analysis ignored.
 */
public class PKIXAttrCertPathBuilderSpi
extends CertPathBuilderSpi {
    private Exception certPathException;

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        PKIXExtendedBuilderParameters pKIXExtendedBuilderParameters;
        Object object;
        Object object2;
        if (!(certPathParameters instanceof PKIXBuilderParameters || certPathParameters instanceof ExtendedPKIXBuilderParameters || certPathParameters instanceof PKIXExtendedBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + PKIXExtendedBuilderParameters.class.getName() + ".");
        }
        List list = new ArrayList();
        if (certPathParameters instanceof PKIXBuilderParameters) {
            object2 = new PKIXExtendedBuilderParameters.Builder((PKIXBuilderParameters)certPathParameters);
            if (certPathParameters instanceof ExtendedPKIXParameters) {
                object = (ExtendedPKIXBuilderParameters)certPathParameters;
                object2.addExcludedCerts(object.getExcludedCerts());
                object2.setMaxPathLength(object.getMaxPathLength());
                list = object.getStores();
            }
            pKIXExtendedBuilderParameters = object2.build();
        } else {
            pKIXExtendedBuilderParameters = (PKIXExtendedBuilderParameters)certPathParameters;
        }
        ArrayList arrayList = new ArrayList();
        PKIXCertStoreSelector pKIXCertStoreSelector = pKIXExtendedBuilderParameters.getBaseParameters().getTargetConstraints();
        if (!(pKIXCertStoreSelector instanceof X509AttributeCertStoreSelector)) {
            throw new CertPathBuilderException("TargetConstraints must be an instance of " + X509AttributeCertStoreSelector.class.getName() + " for " + this.getClass().getName() + " class.");
        }
        try {
            object2 = PKIXAttrCertPathBuilderSpi.findCertificates((X509AttributeCertStoreSelector)((X509AttributeCertStoreSelector)pKIXCertStoreSelector), list);
        }
        catch (AnnotatedException annotatedException) {
            throw new ExtCertPathBuilderException("Error finding target attribute certificate.", (Throwable)annotatedException);
        }
        if (object2.isEmpty()) {
            throw new CertPathBuilderException("No attribute certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        object = object2.iterator();
        while (object.hasNext() && certPathBuilderResult == null) {
            X509AttributeCertificate x509AttributeCertificate = (X509AttributeCertificate)object.next();
            X509CertStoreSelector x509CertStoreSelector = new X509CertStoreSelector();
            Principal[] principalArray = x509AttributeCertificate.getIssuer().getPrincipals();
            HashSet hashSet = new HashSet();
            for (int i2 = 0; i2 < principalArray.length; ++i2) {
                try {
                    if (principalArray[i2] instanceof X500Principal) {
                        x509CertStoreSelector.setSubject(((X500Principal)principalArray[i2]).getEncoded());
                    }
                    PKIXCertStoreSelector pKIXCertStoreSelector2 = new PKIXCertStoreSelector.Builder((CertSelector)x509CertStoreSelector).build();
                    hashSet.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)pKIXCertStoreSelector2, (List)pKIXExtendedBuilderParameters.getBaseParameters().getCertStores()));
                    hashSet.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)pKIXCertStoreSelector2, (List)pKIXExtendedBuilderParameters.getBaseParameters().getCertificateStores()));
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    throw new ExtCertPathBuilderException("Public key certificate for attribute certificate cannot be searched.", (Throwable)annotatedException);
                }
                catch (IOException iOException) {
                    throw new ExtCertPathBuilderException("cannot encode X500Principal.", (Throwable)iOException);
                }
            }
            if (hashSet.isEmpty()) {
                throw new CertPathBuilderException("Public key certificate for attribute certificate cannot be found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                certPathBuilderResult = this.build(x509AttributeCertificate, (X509Certificate)iterator.next(), pKIXExtendedBuilderParameters, arrayList);
            }
        }
        if (certPathBuilderResult == null && this.certPathException != null) {
            throw new ExtCertPathBuilderException("Possible certificate chain could not be validated.", (Throwable)this.certPathException);
        }
        if (certPathBuilderResult == null && this.certPathException == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult build(X509AttributeCertificate x509AttributeCertificate, X509Certificate x509Certificate, PKIXExtendedBuilderParameters pKIXExtendedBuilderParameters, List list) {
        CertPathValidator certPathValidator;
        CertificateFactory certificateFactory;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (pKIXExtendedBuilderParameters.getExcludedCerts().contains(x509Certificate)) {
            return null;
        }
        if (pKIXExtendedBuilderParameters.getMaxPathLength() != -1 && list.size() - 1 > pKIXExtendedBuilderParameters.getMaxPathLength()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            certPathValidator = CertPathValidator.getInstance("RFC3281", "BC");
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (CertPathValidatorUtilities.isIssuerTrustAnchor((X509Certificate)x509Certificate, (Set)pKIXExtendedBuilderParameters.getBaseParameters().getTrustAnchors(), (String)pKIXExtendedBuilderParameters.getBaseParameters().getSigProvider())) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = certificateFactory.generateCertPath(list);
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Certification path could not be constructed from certificate list.", (Throwable)exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, (CertPathParameters)pKIXExtendedBuilderParameters);
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Certification path could not be validated.", (Throwable)exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(pKIXExtendedBuilderParameters.getBaseParameters().getCertificateStores());
            try {
                arrayList.addAll(CertPathValidatorUtilities.getAdditionalStoresFromAltNames((byte[])x509Certificate.getExtensionValue(Extension.issuerAlternativeName.getId()), (Map)pKIXExtendedBuilderParameters.getBaseParameters().getNamedCertificateStoreMap()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new AnnotatedException("No additional X.509 stores can be added from certificate locations.", (Throwable)certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(CertPathValidatorUtilities.findIssuerCerts((X509Certificate)x509Certificate, (List)pKIXExtendedBuilderParameters.getBaseParameters().getCertStores(), arrayList));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Cannot find issuer certificate for certificate in certification path.", (Throwable)annotatedException);
            }
            if (hashSet.isEmpty()) {
                throw new AnnotatedException("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                if (x509Certificate2.getIssuerX500Principal().equals(x509Certificate2.getSubjectX500Principal())) continue;
                certPathBuilderResult = this.build(x509AttributeCertificate, x509Certificate2, pKIXExtendedBuilderParameters, list);
            }
        }
        catch (AnnotatedException annotatedException) {
            this.certPathException = new AnnotatedException("No valid certification path could be build.", (Throwable)annotatedException);
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }

    protected static Collection findCertificates(X509AttributeCertStoreSelector x509AttributeCertStoreSelector, List list) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        for (Object e2 : list) {
            if (!(e2 instanceof Store)) continue;
            Store store = (Store)e2;
            try {
                hashSet.addAll(store.getMatches((Selector)x509AttributeCertStoreSelector));
            }
            catch (StoreException storeException) {
                throw new AnnotatedException("Problem while picking certificates from X.509 store.", (Throwable)storeException);
            }
        }
        return hashSet;
    }
}

