/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Null;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERNull;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cryptopro.CryptoProObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cryptopro.ECGOST3410NamedCurves;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.sec.ECPrivateKeyStructure;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X962Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ECParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.EC5Util;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.ECUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPointEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.PKCS12BagAttributeCarrier;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.JCEECPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECNamedCurveSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Strings;

public class JCEECPrivateKey
implements ECPointEncoder,
ECPrivateKey,
PKCS12BagAttributeCarrier,
java.security.interfaces.ECPrivateKey {
    private String algorithm = "EC";
    private BigInteger d;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private DERBitString publicKey;
    private PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected JCEECPrivateKey() {
    }

    public JCEECPrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
    }

    public JCEECPrivateKey(String string, macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getD();
        if (eCPrivateKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPrivateKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])eCPrivateKeySpec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec((EllipticCurve)ellipticCurve, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCPrivateKeySpec.getParams());
        } else {
            this.ecSpec = null;
        }
    }

    public JCEECPrivateKey(String string, ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    public JCEECPrivateKey(String string, JCEECPrivateKey jCEECPrivateKey) {
        this.algorithm = string;
        this.d = jCEECPrivateKey.d;
        this.ecSpec = jCEECPrivateKey.ecSpec;
        this.withCompression = jCEECPrivateKey.withCompression;
        this.attrCarrier = jCEECPrivateKey.attrCarrier;
        this.publicKey = jCEECPrivateKey.publicKey;
    }

    public JCEECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, JCEECPublicKey jCEECPublicKey, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.ecSpec = eCParameterSpec;
        }
        this.publicKey = this.getPublicKeyDetails(jCEECPublicKey);
    }

    public JCEECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, JCEECPublicKey jCEECPublicKey, macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCParameterSpec.getCurve(), (byte[])eCParameterSpec.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCParameterSpec.getG()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
        }
        this.publicKey = this.getPublicKeyDetails(jCEECPublicKey);
    }

    public JCEECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        this.ecSpec = null;
    }

    JCEECPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo privateKeyInfo) throws IOException {
        Object object;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X962Parameters x962Parameters = new X962Parameters((ASN1Primitive)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)x962Parameters.getParameters());
            object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            if (object == null) {
                ECDomainParameters eCDomainParameters = ECGOST3410NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
                EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
                this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier), ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH());
            } else {
                EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)object.getCurve(), (byte[])object.getSeed());
                this.ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1ObjectIdentifier), ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)object.getG()), object.getN(), object.getH());
            }
        } else if (x962Parameters.isImplicitlyCA()) {
            this.ecSpec = null;
        } else {
            aSN1ObjectIdentifier = X9ECParameters.getInstance((Object)x962Parameters.getParameters());
            object = EC5Util.convertCurve((ECCurve)aSN1ObjectIdentifier.getCurve(), (byte[])aSN1ObjectIdentifier.getSeed());
            this.ecSpec = new ECParameterSpec((EllipticCurve)object, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)aSN1ObjectIdentifier.getG()), aSN1ObjectIdentifier.getN(), aSN1ObjectIdentifier.getH().intValue());
        }
        aSN1ObjectIdentifier = privateKeyInfo.parsePrivateKey();
        if (aSN1ObjectIdentifier instanceof ASN1Integer) {
            object = ASN1Integer.getInstance((Object)aSN1ObjectIdentifier);
            this.d = object.getValue();
        } else {
            object = new ECPrivateKeyStructure((ASN1Sequence)aSN1ObjectIdentifier);
            this.d = object.getKey();
            this.publicKey = object.getPublicKey();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ECPrivateKeyStructure eCPrivateKeyStructure;
        X962Parameters x962Parameters;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (this.ecSpec instanceof ECNamedCurveSpec) {
            aSN1ObjectIdentifier = ECUtil.getNamedCurveOid((String)((ECNamedCurveSpec)this.ecSpec).getName());
            if (aSN1ObjectIdentifier == null) {
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.ecSpec).getName());
            }
            x962Parameters = new X962Parameters(aSN1ObjectIdentifier);
        } else if (this.ecSpec == null) {
            x962Parameters = new X962Parameters((ASN1Null)DERNull.INSTANCE);
        } else {
            aSN1ObjectIdentifier = EC5Util.convertCurve((EllipticCurve)this.ecSpec.getCurve());
            eCPrivateKeyStructure = new X9ECParameters((ECCurve)aSN1ObjectIdentifier, EC5Util.convertPoint((ECCurve)aSN1ObjectIdentifier, (ECPoint)this.ecSpec.getGenerator(), (boolean)this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)eCPrivateKeyStructure);
        }
        eCPrivateKeyStructure = this.publicKey != null ? new ECPrivateKeyStructure(this.getS(), this.publicKey, (ASN1Encodable)x962Parameters) : new ECPrivateKeyStructure(this.getS(), (ASN1Encodable)x962Parameters);
        try {
            aSN1ObjectIdentifier = this.algorithm.equals("ECGOST3410") ? new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, (ASN1Encodable)x962Parameters.toASN1Primitive()), (ASN1Encodable)eCPrivateKeyStructure.toASN1Primitive()) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)x962Parameters.toASN1Primitive()), (ASN1Encodable)eCPrivateKeyStructure.toASN1Primitive());
            return aSN1ObjectIdentifier.getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
    }

    macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JCEECPrivateKey)) {
            return false;
        }
        JCEECPrivateKey jCEECPrivateKey = (JCEECPrivateKey)object;
        return this.getD().equals(jCEECPrivateKey.getD()) && this.engineGetSpec().equals((Object)jCEECPrivateKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("EC Private Key").append(string);
        stringBuffer.append("             S: ").append(this.d.toString(16)).append(string);
        return stringBuffer.toString();
    }

    private DERBitString getPublicKeyDetails(JCEECPublicKey jCEECPublicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])jCEECPublicKey.getEncoded()));
            return subjectPublicKeyInfo.getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray)));
        this.algorithm = (String)objectInputStream.readObject();
        this.withCompression = objectInputStream.readBoolean();
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.attrCarrier.readObject(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getEncoded());
        objectOutputStream.writeObject(this.algorithm);
        objectOutputStream.writeBoolean(this.withCompression);
        this.attrCarrier.writeObject(objectOutputStream);
    }
}

