/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms.GCMParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BufferedBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DataLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.OutputLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.DSTU7624Engine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.AEADBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.CBCBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.CCMBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.CFBBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.CTSBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.EAXBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.GCFBBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.GCMBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.GOFBBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.KCCMBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.KCTRBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.KGCMBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.OCBBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.OFBBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.OpenPGPCFBBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.PGPCFBBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.SICBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings.BlockCipherPadding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings.ISO10126d2Padding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings.ISO7816d4Padding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings.TBCPadding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings.X923Padding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings.ZeroBytePadding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AEADParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithSBox;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RC2Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RC5Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PBKDF1Key;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PBKDF1KeyWithParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKCS12Key;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKCS12KeyWithParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.BCPBEKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.BaseBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.BaseWrapCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.BlockCipherProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.ClassUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.PBE;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.AEADParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.GOST28147ParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.RepeatedSecretKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Strings;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseBlockCipher
extends BaseWrapCipher
implements PBE {
    private static final Class gcmSpecClass = ClassUtil.loadClass(BaseBlockCipher.class, (String)"javax.crypto.spec.GCMParameterSpec");
    private Class[] availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, gcmSpecClass, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
    private BlockCipher baseEngine;
    private BlockCipherProvider engineProvider;
    private GenericBlockCipher cipher;
    private ParametersWithIV ivParam;
    private AEADParameters aeadParams;
    private int keySizeInBits;
    private int scheme = -1;
    private int digest;
    private int ivLength = 0;
    private boolean padded;
    private boolean fixedIv = true;
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private String modeName = null;

    protected BaseBlockCipher(BlockCipher blockCipher) {
        this.baseEngine = blockCipher;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n2, int n3, int n4, int n5) {
        this.baseEngine = blockCipher;
        this.scheme = n2;
        this.digest = n3;
        this.keySizeInBits = n4;
        this.ivLength = n5;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
    }

    protected BaseBlockCipher(BlockCipherProvider blockCipherProvider) {
        this.baseEngine = blockCipherProvider.get();
        this.engineProvider = blockCipherProvider;
        this.cipher = new BufferedGenericBlockCipher(blockCipherProvider.get());
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher) {
        this.baseEngine = aEADBlockCipher.getUnderlyingCipher();
        this.ivLength = this.baseEngine.getBlockSize();
        this.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher, boolean bl2, int n2) {
        this.baseEngine = aEADBlockCipher.getUnderlyingCipher();
        this.fixedIv = bl2;
        this.ivLength = n2;
        this.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n2) {
        this(blockCipher, true, n2);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, boolean bl2, int n2) {
        this.baseEngine = blockCipher;
        this.fixedIv = bl2;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
        this.ivLength = n2 / 8;
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, int n2) {
        this(bufferedBlockCipher, true, n2);
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, boolean bl2, int n2) {
        this.baseEngine = bufferedBlockCipher.getUnderlyingCipher();
        this.cipher = new BufferedGenericBlockCipher(bufferedBlockCipher);
        this.fixedIv = bl2;
        this.ivLength = n2 / 8;
    }

    protected int engineGetBlockSize() {
        return this.baseEngine.getBlockSize();
    }

    protected byte[] engineGetIV() {
        if (this.aeadParams != null) {
            return this.aeadParams.getNonce();
        }
        return this.ivParam != null ? this.ivParam.getIV() : null;
    }

    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    protected int engineGetOutputSize(int n2) {
        return this.cipher.getOutputSize(n2);
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = this.createParametersInstance(this.pbeAlgorithm);
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (this.aeadParams != null) {
                try {
                    this.engineParams = this.createParametersInstance("GCM");
                    this.engineParams.init(new GCMParameters(this.aeadParams.getNonce(), this.aeadParams.getMacSize() / 8).getEncoded());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
            if (this.ivParam != null) {
                String string = this.cipher.getUnderlyingCipher().getAlgorithmName();
                if (string.indexOf(47) >= 0) {
                    string = string.substring(0, string.indexOf(47));
                }
                try {
                    this.engineParams = this.createParametersInstance(string);
                    this.engineParams.init(new IvParameterSpec(this.ivParam.getIV()));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
        }
        return this.engineParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.modeName = Strings.toUpperCase((String)string);
        if (this.modeName.equals("ECB")) {
            this.ivLength = 0;
            this.cipher = new BufferedGenericBlockCipher(this.baseEngine);
            return;
        } else if (this.modeName.equals("CBC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher((BlockCipher)new CBCBlockCipher(this.baseEngine));
            return;
        } else if (this.modeName.startsWith("OFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int n2 = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher((BlockCipher)new OFBBlockCipher(this.baseEngine, n2));
                return;
            } else {
                this.cipher = new BufferedGenericBlockCipher((BlockCipher)new OFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
            return;
        } else if (this.modeName.startsWith("CFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int n3 = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher((BlockCipher)new CFBBlockCipher(this.baseEngine, n3));
                return;
            } else {
                this.cipher = new BufferedGenericBlockCipher((BlockCipher)new CFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
            return;
        } else if (this.modeName.startsWith("PGP")) {
            boolean bl2 = this.modeName.equalsIgnoreCase("PGPCFBwithIV");
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher((BlockCipher)new PGPCFBBlockCipher(this.baseEngine, bl2));
            return;
        } else if (this.modeName.equalsIgnoreCase("OpenPGPCFB")) {
            this.ivLength = 0;
            this.cipher = new BufferedGenericBlockCipher((BlockCipher)new OpenPGPCFBBlockCipher(this.baseEngine));
            return;
        } else if (this.modeName.startsWith("SIC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.ivLength < 16) {
                throw new IllegalArgumentException("Warning: SIC-Mode can become a twotime-pad if the blocksize of the cipher is too small. Use a cipher with a block size of at least 128 bits (e.g. AES)");
            }
            this.fixedIv = false;
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher((BlockCipher)new SICBlockCipher(this.baseEngine)));
            return;
        } else if (this.modeName.startsWith("CTR")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.fixedIv = false;
            this.cipher = this.baseEngine instanceof DSTU7624Engine ? new BufferedGenericBlockCipher(new BufferedBlockCipher((BlockCipher)new KCTRBlockCipher(this.baseEngine))) : new BufferedGenericBlockCipher(new BufferedBlockCipher((BlockCipher)new SICBlockCipher(this.baseEngine)));
            return;
        } else if (this.modeName.startsWith("GOFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher((BlockCipher)new GOFBBlockCipher(this.baseEngine)));
            return;
        } else if (this.modeName.startsWith("GCFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher((BlockCipher)new GCFBBlockCipher(this.baseEngine)));
            return;
        } else if (this.modeName.startsWith("CTS")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher((BufferedBlockCipher)new CTSBlockCipher((BlockCipher)new CBCBlockCipher(this.baseEngine)));
            return;
        } else if (this.modeName.startsWith("CCM")) {
            this.ivLength = 12;
            this.cipher = this.baseEngine instanceof DSTU7624Engine ? new AEADGenericBlockCipher((AEADBlockCipher)new KCCMBlockCipher(this.baseEngine)) : new AEADGenericBlockCipher((AEADBlockCipher)new CCMBlockCipher(this.baseEngine));
            return;
        } else if (this.modeName.startsWith("OCB")) {
            if (this.engineProvider == null) throw new NoSuchAlgorithmException("can't support mode " + string);
            this.ivLength = 15;
            this.cipher = new AEADGenericBlockCipher((AEADBlockCipher)new OCBBlockCipher(this.baseEngine, this.engineProvider.get()));
            return;
        } else if (this.modeName.startsWith("EAX")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new AEADGenericBlockCipher((AEADBlockCipher)new EAXBlockCipher(this.baseEngine));
            return;
        } else {
            if (!this.modeName.startsWith("GCM")) throw new NoSuchAlgorithmException("can't support mode " + string);
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = this.baseEngine instanceof DSTU7624Engine ? new AEADGenericBlockCipher((AEADBlockCipher)new KGCMBlockCipher(this.baseEngine)) : new AEADGenericBlockCipher((AEADBlockCipher)new GCMBlockCipher(this.baseEngine));
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase((String)string);
        if (string2.equals("NOPADDING")) {
            if (this.cipher.wrapOnNoPadding()) {
                this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(this.cipher.getUnderlyingCipher()));
            }
        } else if (string2.equals("WITHCTS") || string2.equals("CTSPADDING") || string2.equals("CS3PADDING")) {
            this.cipher = new BufferedGenericBlockCipher((BufferedBlockCipher)new CTSBlockCipher(this.cipher.getUnderlyingCipher()));
        } else {
            this.padded = true;
            if (this.isAEADModeName(this.modeName)) {
                throw new NoSuchPaddingException("Only NoPadding can be used with AEAD modes.");
            }
            if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher());
            } else if (string2.equals("ZEROBYTEPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), (BlockCipherPadding)new ZeroBytePadding());
            } else if (string2.equals("ISO10126PADDING") || string2.equals("ISO10126-2PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), (BlockCipherPadding)new ISO10126d2Padding());
            } else if (string2.equals("X9.23PADDING") || string2.equals("X923PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), (BlockCipherPadding)new X923Padding());
            } else if (string2.equals("ISO7816-4PADDING") || string2.equals("ISO9797-1PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), (BlockCipherPadding)new ISO7816d4Padding());
            } else if (string2.equals("TBCPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), (BlockCipherPadding)new TBCPadding());
            } else {
                throw new NoSuchPaddingException("Padding " + string + " unknown.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEKey pBEKey;
        Object object;
        Object object2;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        this.aeadParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + (key != null ? key.getAlgorithm() : null) + " not suitable for symmetric enryption.");
        }
        if (algorithmParameterSpec == null && this.baseEngine.getAlgorithmName().startsWith("RC5-64")) {
            throw new InvalidAlgorithmParameterException("RC5 requires an RC5ParametersSpec to be passed in.");
        }
        if (this.scheme == 2 || key instanceof PKCS12Key) {
            try {
                object2 = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            }
            if (object2 instanceof PBEKey && this.pbeSpec == null) {
                object = (PBEKey)object2;
                if (object.getSalt() == null) {
                    throw new InvalidAlgorithmParameterException("PBEKey requires parameters to specify salt");
                }
                this.pbeSpec = new PBEParameterSpec(object.getSalt(), object.getIterationCount());
            }
            if (this.pbeSpec == null && !(object2 instanceof PBEKey)) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            if (key instanceof BCPBEKey) {
                object = ((BCPBEKey)key).getParam();
                if (object instanceof ParametersWithIV) {
                    pBEKey = object;
                } else {
                    if (object != null) throw new InvalidKeyException("Algorithm requires a PBE key suitable for PKCS12");
                    pBEKey = PBE.Util.makePBEParameters((byte[])object2.getEncoded(), (int)2, (int)this.digest, (int)this.keySizeInBits, (int)(this.ivLength * 8), (AlgorithmParameterSpec)this.pbeSpec, (String)this.cipher.getAlgorithmName());
                }
            } else {
                pBEKey = PBE.Util.makePBEParameters((byte[])object2.getEncoded(), (int)2, (int)this.digest, (int)this.keySizeInBits, (int)(this.ivLength * 8), (AlgorithmParameterSpec)this.pbeSpec, (String)this.cipher.getAlgorithmName());
            }
            if (pBEKey instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)pBEKey;
            }
        } else if (key instanceof PBKDF1Key) {
            object2 = (PBKDF1Key)key;
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            }
            if (object2 instanceof PBKDF1KeyWithParameters && this.pbeSpec == null) {
                this.pbeSpec = new PBEParameterSpec(((PBKDF1KeyWithParameters)object2).getSalt(), ((PBKDF1KeyWithParameters)object2).getIterationCount());
            }
            if ((pBEKey = PBE.Util.makePBEParameters((byte[])object2.getEncoded(), (int)0, (int)this.digest, (int)this.keySizeInBits, (int)(this.ivLength * 8), (AlgorithmParameterSpec)this.pbeSpec, (String)this.cipher.getAlgorithmName())) instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)pBEKey;
            }
        } else if (key instanceof BCPBEKey) {
            object2 = (BCPBEKey)key;
            this.pbeAlgorithm = object2.getOID() != null ? object2.getOID().getId() : object2.getAlgorithm();
            if (object2.getParam() != null) {
                pBEKey = this.adjustParameters(algorithmParameterSpec, object2.getParam());
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
                pBEKey = PBE.Util.makePBEParameters((BCPBEKey)object2, (AlgorithmParameterSpec)algorithmParameterSpec, (String)this.cipher.getUnderlyingCipher().getAlgorithmName());
            }
            if (pBEKey instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)pBEKey;
            }
        } else if (key instanceof PBEKey) {
            object2 = (PBEKey)key;
            this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            if (object2 instanceof PKCS12KeyWithParameters && this.pbeSpec == null) {
                this.pbeSpec = new PBEParameterSpec(object2.getSalt(), object2.getIterationCount());
            }
            if ((pBEKey = PBE.Util.makePBEParameters((byte[])object2.getEncoded(), (int)this.scheme, (int)this.digest, (int)this.keySizeInBits, (int)(this.ivLength * 8), (AlgorithmParameterSpec)this.pbeSpec, (String)this.cipher.getAlgorithmName())) instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)pBEKey;
            }
        } else if (!(key instanceof RepeatedSecretKeySpec)) {
            if (this.scheme == 0 || this.scheme == 4 || this.scheme == 1 || this.scheme == 5) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            pBEKey = new KeyParameter(key.getEncoded());
        } else {
            pBEKey = null;
        }
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            if (!this.isAEADModeName(this.modeName) && !(this.cipher instanceof AEADGenericBlockCipher)) {
                throw new InvalidAlgorithmParameterException("AEADParameterSpec can only be used with AEAD modes.");
            }
            object2 = (AEADParameterSpec)algorithmParameterSpec;
            object = pBEKey instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)pBEKey).getParameters() : (KeyParameter)pBEKey;
            this.aeadParams = new AEADParameters((KeyParameter)object, object2.getMacSizeInBits(), object2.getNonce(), object2.getAssociatedData());
            pBEKey = this.aeadParams;
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (this.ivLength != 0) {
                object2 = (IvParameterSpec)algorithmParameterSpec;
                if (((IvParameterSpec)object2).getIV().length != this.ivLength && !(this.cipher instanceof AEADGenericBlockCipher) && this.fixedIv) {
                    throw new InvalidAlgorithmParameterException("IV must be " + this.ivLength + " bytes long.");
                }
                pBEKey = pBEKey instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)pBEKey).getParameters(), ((IvParameterSpec)object2).getIV()) : new ParametersWithIV((CipherParameters)pBEKey, ((IvParameterSpec)object2).getIV());
                this.ivParam = (ParametersWithIV)pBEKey;
            } else if (this.modeName != null && this.modeName.equals("ECB")) {
                throw new InvalidAlgorithmParameterException("ECB mode does not use an IV");
            }
        } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
            object2 = (GOST28147ParameterSpec)algorithmParameterSpec;
            pBEKey = new ParametersWithSBox((CipherParameters)new KeyParameter(key.getEncoded()), ((GOST28147ParameterSpec)algorithmParameterSpec).getSbox());
            if (object2.getIV() != null && this.ivLength != 0) {
                pBEKey = pBEKey instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)pBEKey).getParameters(), object2.getIV()) : new ParametersWithIV((CipherParameters)pBEKey, object2.getIV());
                this.ivParam = (ParametersWithIV)pBEKey;
            }
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            object2 = (RC2ParameterSpec)algorithmParameterSpec;
            pBEKey = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits());
            if (((RC2ParameterSpec)object2).getIV() != null && this.ivLength != 0) {
                pBEKey = pBEKey instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)pBEKey).getParameters(), ((RC2ParameterSpec)object2).getIV()) : new ParametersWithIV((CipherParameters)pBEKey, ((RC2ParameterSpec)object2).getIV());
                this.ivParam = (ParametersWithIV)pBEKey;
            }
        } else if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            object2 = (RC5ParameterSpec)algorithmParameterSpec;
            pBEKey = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)algorithmParameterSpec).getRounds());
            if (!this.baseEngine.getAlgorithmName().startsWith("RC5")) throw new InvalidAlgorithmParameterException("RC5 parameters passed to a cipher that is not RC5.");
            if (this.baseEngine.getAlgorithmName().equals("RC5-32")) {
                if (((RC5ParameterSpec)object2).getWordSize() != 32) {
                    throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 32 not " + ((RC5ParameterSpec)object2).getWordSize() + ".");
                }
            } else if (this.baseEngine.getAlgorithmName().equals("RC5-64") && ((RC5ParameterSpec)object2).getWordSize() != 64) {
                throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 64 not " + ((RC5ParameterSpec)object2).getWordSize() + ".");
            }
            if (((RC5ParameterSpec)object2).getIV() != null && this.ivLength != 0) {
                pBEKey = pBEKey instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)pBEKey).getParameters(), ((RC5ParameterSpec)object2).getIV()) : new ParametersWithIV((CipherParameters)pBEKey, ((RC5ParameterSpec)object2).getIV());
                this.ivParam = (ParametersWithIV)pBEKey;
            }
        } else if (gcmSpecClass != null && gcmSpecClass.isInstance(algorithmParameterSpec)) {
            if (!this.isAEADModeName(this.modeName) && !(this.cipher instanceof AEADGenericBlockCipher)) {
                throw new InvalidAlgorithmParameterException("GCMParameterSpec can only be used with AEAD modes.");
            }
            try {
                object2 = gcmSpecClass.getDeclaredMethod("getTLen", new Class[0]);
                object = gcmSpecClass.getDeclaredMethod("getIV", new Class[0]);
                KeyParameter keyParameter = pBEKey instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)pBEKey).getParameters() : (KeyParameter)pBEKey;
                this.aeadParams = new AEADParameters(keyParameter, ((Integer)((Method)object2).invoke((Object)algorithmParameterSpec, new Object[0])).intValue(), (byte[])((Method)object).invoke((Object)algorithmParameterSpec, new Object[0]));
                pBEKey = this.aeadParams;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
            }
        } else if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(pBEKey instanceof ParametersWithIV) && !(pBEKey instanceof AEADParameters)) {
            object2 = secureRandom;
            if (object2 == null) {
                object2 = CryptoServicesRegistrar.getSecureRandom();
            }
            if (n2 == 1 || n2 == 3) {
                object = new byte[this.ivLength];
                ((SecureRandom)object2).nextBytes((byte[])object);
                pBEKey = new ParametersWithIV((CipherParameters)pBEKey, (byte[])object);
                this.ivParam = (ParametersWithIV)pBEKey;
            } else if (this.cipher.getUnderlyingCipher().getAlgorithmName().indexOf("PGPCFB") < 0) {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        if (secureRandom != null && this.padded) {
            pBEKey = new ParametersWithRandom((CipherParameters)pBEKey, secureRandom);
        }
        try {
            switch (n2) {
                case 1: 
                case 3: {
                    this.cipher.init(true, (CipherParameters)pBEKey);
                    break;
                }
                case 2: 
                case 4: {
                    this.cipher.init(false, (CipherParameters)pBEKey);
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown opmode " + n2 + " passed");
                }
            }
            if (!(this.cipher instanceof AEADGenericBlockCipher) || this.aeadParams != null) return;
            object2 = AEADGenericBlockCipher.access$000((AEADGenericBlockCipher)((AEADGenericBlockCipher)this.cipher));
            this.aeadParams = new AEADParameters((KeyParameter)this.ivParam.getParameters(), object2.getMac().length * 8, this.ivParam.getIV());
            return;
        }
        catch (Exception exception) {
            throw new InvalidKeyOrParametersException(exception.getMessage(), (Throwable)exception);
        }
    }

    private CipherParameters adjustParameters(AlgorithmParameterSpec algorithmParameterSpec, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            CipherParameters cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
                this.ivParam = new ParametersWithIV(cipherParameters2, ivParameterSpec.getIV());
                cipherParameters = this.ivParam;
            } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                GOST28147ParameterSpec gOST28147ParameterSpec = (GOST28147ParameterSpec)algorithmParameterSpec;
                cipherParameters = new ParametersWithSBox(cipherParameters, gOST28147ParameterSpec.getSbox());
                if (gOST28147ParameterSpec.getIV() != null && this.ivLength != 0) {
                    this.ivParam = new ParametersWithIV(cipherParameters2, gOST28147ParameterSpec.getIV());
                    cipherParameters = this.ivParam;
                }
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.ivParam = new ParametersWithIV(cipherParameters, ivParameterSpec.getIV());
            cipherParameters = this.ivParam;
        } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
            GOST28147ParameterSpec gOST28147ParameterSpec = (GOST28147ParameterSpec)algorithmParameterSpec;
            cipherParameters = new ParametersWithSBox(cipherParameters, gOST28147ParameterSpec.getSbox());
            if (gOST28147ParameterSpec.getIV() != null && this.ivLength != 0) {
                cipherParameters = new ParametersWithIV(cipherParameters, gOST28147ParameterSpec.getIV());
            }
        }
        return cipherParameters;
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                if (this.availableSpecs[i2] == null) continue;
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected void engineUpdateAAD(byte[] byArray, int n2, int n3) {
        this.cipher.updateAAD(byArray, n2, n3);
    }

    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.limit() - byteBuffer.position();
        this.engineUpdateAAD(byteBuffer.array(), n2, n3);
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        int n4 = this.cipher.getUpdateOutputSize(n3);
        if (n4 > 0) {
            byte[] byArray2 = new byte[n4];
            int n5 = this.cipher.processBytes(byArray, n2, n3, byArray2, 0);
            if (n5 == 0) {
                return null;
            }
            if (n5 != byArray2.length) {
                byte[] byArray3 = new byte[n5];
                System.arraycopy(byArray2, 0, byArray3, 0, n5);
                return byArray3;
            }
            return byArray2;
        }
        this.cipher.processBytes(byArray, n2, n3, null, 0);
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (n4 + this.cipher.getUpdateOutputSize(n3) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            return this.cipher.processBytes(byArray, n2, n3, byArray2, n4);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalStateException(dataLengthException.toString());
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        int n4 = 0;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n3)];
        if (n3 != 0) {
            n4 = this.cipher.processBytes(byArray, n2, n3, byArray2, 0);
        }
        try {
            n4 += this.cipher.doFinal(byArray2, n4);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        if (n4 == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int n5 = 0;
        if (n4 + this.engineGetOutputSize(n3) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            if (n3 != 0) {
                n5 = this.cipher.processBytes(byArray, n2, n3, byArray2, n4);
            }
            return n5 + this.cipher.doFinal(byArray2, n4 + n5);
        }
        catch (OutputLengthException outputLengthException) {
            throw new IllegalBlockSizeException(outputLengthException.getMessage());
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
    }

    private boolean isAEADModeName(String string) {
        return "CCM".equals(string) || "EAX".equals(string) || "GCM".equals(string) || "OCB".equals(string);
    }
}

