/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.rsa;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAPrivateCrtKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Fingerprint;

public class RSAUtil {
    public static final ASN1ObjectIdentifier[] rsaOids = new ASN1ObjectIdentifier[]{PKCSObjectIdentifiers.rsaEncryption, X509ObjectIdentifiers.id_ea_rsa, PKCSObjectIdentifiers.id_RSAES_OAEP, PKCSObjectIdentifiers.id_RSASSA_PSS};

    public static boolean isRsaOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        for (int i2 = 0; i2 != rsaOids.length; ++i2) {
            if (!aSN1ObjectIdentifier.equals((Object)rsaOids[i2])) continue;
            return true;
        }
        return false;
    }

    static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey rSAPublicKey) {
        return new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
            return new RSAPrivateCrtKeyParameters(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }
        RSAPrivateKey rSAPrivateKey2 = rSAPrivateKey;
        return new RSAKeyParameters(true, rSAPrivateKey2.getModulus(), rSAPrivateKey2.getPrivateExponent());
    }

    static String generateKeyFingerprint(BigInteger bigInteger, BigInteger bigInteger2) {
        return new Fingerprint(Arrays.concatenate((byte[])bigInteger.toByteArray(), (byte[])bigInteger2.toByteArray())).toString();
    }
}

