/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.rsa;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers.ISO9796d2Signer;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.rsa.RSAUtil;

public class ISOSignatureSpi
extends SignatureSpi {
    private ISO9796d2Signer signer;

    protected ISOSignatureSpi(Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.signer = new ISO9796d2Signer(asymmetricBlockCipher, digest, true);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)((RSAPublicKey)publicKey));
        this.signer.init(false, (CipherParameters)rSAKeyParameters);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)((RSAPrivateKey)privateKey));
        this.signer.init(true, (CipherParameters)rSAKeyParameters);
    }

    protected void engineUpdate(byte by2) throws SignatureException {
        this.signer.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.signer.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.signer.generateSignature();
            return byArray;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        boolean bl2 = this.signer.verifySignature(byArray);
        return bl2;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

