/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.rsa;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.encodings.ISO9796d1Encoding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.encodings.OAEPEncoding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.encodings.PKCS1Encoding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.RSABlindedEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.rsa.RSAUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.BaseCipherSpi;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.util.BadBlockException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.util.DigestFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.BCJcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.JcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Strings;

public class CipherSpi
extends BaseCipherSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private AsymmetricBlockCipher cipher;
    private AlgorithmParameterSpec paramSpec;
    private AlgorithmParameters engineParams;
    private boolean publicKeyOnly = false;
    private boolean privateKeyOnly = false;
    private BaseCipherSpi.ErasableOutputStream bOut = new BaseCipherSpi.ErasableOutputStream();

    public CipherSpi(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.cipher = asymmetricBlockCipher;
    }

    public CipherSpi(OAEPParameterSpec oAEPParameterSpec) {
        try {
            this.initFromSpec(oAEPParameterSpec);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new IllegalArgumentException(noSuchPaddingException.getMessage());
        }
    }

    public CipherSpi(boolean bl2, boolean bl3, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.publicKeyOnly = bl2;
        this.privateKeyOnly = bl3;
        this.cipher = asymmetricBlockCipher;
    }

    private void initFromSpec(OAEPParameterSpec oAEPParameterSpec) throws NoSuchPaddingException {
        MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
        Digest digest = DigestFactory.getDigest((String)mGF1ParameterSpec.getDigestAlgorithm());
        if (digest == null) {
            throw new NoSuchPaddingException("no match on OAEP constructor for digest algorithm: " + mGF1ParameterSpec.getDigestAlgorithm());
        }
        this.cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSABlindedEngine(), digest, ((PSource.PSpecified)oAEPParameterSpec.getPSource()).getValue());
        this.paramSpec = oAEPParameterSpec;
    }

    protected int engineGetBlockSize() {
        try {
            return this.cipher.getInputBlockSize();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            return rSAPrivateKey.getModulus().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            return rSAPublicKey.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an RSA key!");
    }

    protected int engineGetOutputSize(int n2) {
        try {
            return this.cipher.getOutputBlockSize();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("OAEP");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase((String)string);
        if (string2.equals("NONE") || string2.equals("ECB")) {
            return;
        }
        if (string2.equals("1")) {
            this.privateKeyOnly = true;
            this.publicKeyOnly = false;
            return;
        }
        if (string2.equals("2")) {
            this.privateKeyOnly = false;
            this.publicKeyOnly = true;
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase((String)string);
        if (string2.equals("NOPADDING")) {
            this.cipher = new RSABlindedEngine();
        } else if (string2.equals("PKCS1PADDING")) {
            this.cipher = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
        } else if (string2.equals("ISO9796-1PADDING")) {
            this.cipher = new ISO9796d1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
        } else if (string2.equals("OAEPWITHMD5ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("MD5", "MGF1", new MGF1ParameterSpec("MD5"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPPADDING")) {
            this.initFromSpec(OAEPParameterSpec.DEFAULT);
        } else if (string2.equals("OAEPWITHSHA1ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-1ANDMGF1PADDING")) {
            this.initFromSpec(OAEPParameterSpec.DEFAULT);
        } else if (string2.equals("OAEPWITHSHA224ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-224ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA-224", "MGF1", new MGF1ParameterSpec("SHA-224"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA256ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-256ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA384ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-384ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA512ANDMGF1PADDING") || string2.equals("OAEPWITHSHA-512ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-224ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA3-224", "MGF1", new MGF1ParameterSpec("SHA3-224"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-256ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA3-256", "MGF1", new MGF1ParameterSpec("SHA3-256"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-384ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA3-384", "MGF1", new MGF1ParameterSpec("SHA3-384"), PSource.PSpecified.DEFAULT));
        } else if (string2.equals("OAEPWITHSHA3-512ANDMGF1PADDING")) {
            this.initFromSpec(new OAEPParameterSpec("SHA3-512", "MGF1", new MGF1ParameterSpec("SHA3-512"), PSource.PSpecified.DEFAULT));
        } else {
            throw new NoSuchPaddingException(string + " unavailable with RSA.");
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        RSAKeyParameters rSAKeyParameters;
        if (algorithmParameterSpec == null || algorithmParameterSpec instanceof OAEPParameterSpec) {
            if (key instanceof RSAPublicKey) {
                if (this.privateKeyOnly && n2 == 1) {
                    throw new InvalidKeyException("mode 1 requires RSAPrivateKey");
                }
                rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)((RSAPublicKey)key));
            } else if (key instanceof RSAPrivateKey) {
                if (this.publicKeyOnly && n2 == 1) {
                    throw new InvalidKeyException("mode 2 requires RSAPublicKey");
                }
                rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)((RSAPrivateKey)key));
            } else {
                throw new InvalidKeyException("unknown key type passed to RSA");
            }
            if (algorithmParameterSpec != null) {
                OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
                this.paramSpec = algorithmParameterSpec;
                if (!oAEPParameterSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1") && !oAEPParameterSpec.getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                    throw new InvalidAlgorithmParameterException("unknown mask generation function specified");
                }
                if (!(oAEPParameterSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("unkown MGF parameters");
                }
                Digest digest = DigestFactory.getDigest((String)oAEPParameterSpec.getDigestAlgorithm());
                if (digest == null) {
                    throw new InvalidAlgorithmParameterException("no match on digest algorithm: " + oAEPParameterSpec.getDigestAlgorithm());
                }
                MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
                Digest digest2 = DigestFactory.getDigest((String)mGF1ParameterSpec.getDigestAlgorithm());
                if (digest2 == null) {
                    throw new InvalidAlgorithmParameterException("no match on MGF digest algorithm: " + mGF1ParameterSpec.getDigestAlgorithm());
                }
                this.cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSABlindedEngine(), digest, digest2, ((PSource.PSpecified)oAEPParameterSpec.getPSource()).getValue());
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameter type: " + algorithmParameterSpec.getClass().getName());
        }
        if (!(this.cipher instanceof RSABlindedEngine)) {
            rSAKeyParameters = secureRandom != null ? new ParametersWithRandom((CipherParameters)rSAKeyParameters, secureRandom) : new ParametersWithRandom((CipherParameters)rSAKeyParameters, CryptoServicesRegistrar.getSecureRandom());
        }
        this.bOut.reset();
        switch (n2) {
            case 1: 
            case 3: {
                this.cipher.init(true, (CipherParameters)rSAKeyParameters);
                break;
            }
            case 2: 
            case 4: {
                this.cipher.init(false, (CipherParameters)rSAKeyParameters);
                break;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + n2 + " passed to RSA");
            }
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        OAEPParameterSpec oAEPParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                oAEPParameterSpec = algorithmParameters.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + invalidParameterSpecException.toString(), invalidParameterSpecException);
            }
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n2, key, (AlgorithmParameterSpec)oAEPParameterSpec, secureRandom);
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Eeeek! " + invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.bOut.write(byArray, n2, n3);
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.bOut.write(byArray, n2, n3);
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return 0;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (byArray != null) {
            this.bOut.write(byArray, n2, n3);
        }
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return this.getOutput();
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (n4 + this.engineGetOutputSize(n3) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        if (byArray != null) {
            this.bOut.write(byArray, n2, n3);
        }
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        byte[] byArray3 = this.getOutput();
        for (int i2 = 0; i2 != byArray3.length; ++i2) {
            byArray2[n4 + i2] = byArray3[i2];
        }
        return byArray3.length;
    }

    private byte[] getOutput() throws BadPaddingException {
        try {
            byte[] byArray = this.cipher.processBlock(this.bOut.getBuf(), 0, this.bOut.size());
            return byArray;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadBlockException("unable to decrypt block", (Throwable)invalidCipherTextException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BadBlockException("unable to decrypt block", (Throwable)arrayIndexOutOfBoundsException);
        }
        finally {
            this.bOut.erase();
        }
    }
}

