/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.elgamal;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.ElGamalKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.ElGamalParametersGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ElGamalKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ElGamalParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ElGamalPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ElGamalPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.elgamal.BCElGamalPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.elgamal.BCElGamalPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ElGamalParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    ElGamalKeyGenerationParameters param;
    ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
    int strength = 1024;
    int certainty = 20;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("ElGamal");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        this.strength = n2;
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
        }
        if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
            ElGamalParameterSpec elGamalParameterSpec = (ElGamalParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(elGamalParameterSpec.getP(), elGamalParameterSpec.getG()));
        } else {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL()));
        }
        this.engine.init((KeyGenerationParameters)this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        ElGamalPublicKeyParameters elGamalPublicKeyParameters;
        Object object;
        if (!this.initialised) {
            object = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
            if (object != null) {
                this.param = new ElGamalKeyGenerationParameters(this.random, new ElGamalParameters(((DHParameterSpec)object).getP(), ((DHParameterSpec)object).getG(), ((DHParameterSpec)object).getL()));
            } else {
                elGamalPublicKeyParameters = new ElGamalParametersGenerator();
                elGamalPublicKeyParameters.init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, elGamalPublicKeyParameters.generateParameters());
            }
            this.engine.init((KeyGenerationParameters)this.param);
            this.initialised = true;
        }
        object = this.engine.generateKeyPair();
        elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)object.getPublic();
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)object.getPrivate();
        return new KeyPair((PublicKey)new BCElGamalPublicKey(elGamalPublicKeyParameters), (PrivateKey)new BCElGamalPrivateKey(elGamalPrivateKeyParameters));
    }
}

