/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ecgost12;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Null;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERNull;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cryptopro.ECGOST3410NamedCurves;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.rosstandart.RosstandartObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.sec.ECPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X962Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ECParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.EC5Util;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.ECUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.config.ProviderConfiguration;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.ECGOST3410NamedCurveTable;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPointEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.PKCS12BagAttributeCarrier;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECNamedCurveParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECNamedCurveSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;

public class BCECGOST3410_2012PrivateKey
implements ECPointEncoder,
macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPrivateKey,
PKCS12BagAttributeCarrier,
java.security.interfaces.ECPrivateKey {
    static final long serialVersionUID = 7245981689601667138L;
    private String algorithm = "ECGOST3410-2012";
    private boolean withCompression;
    private transient GOST3410PublicKeyAlgParameters gostParams;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected BCECGOST3410_2012PrivateKey() {
    }

    public BCECGOST3410_2012PrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
    }

    public BCECGOST3410_2012PrivateKey(macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.d = eCPrivateKeySpec.getD();
        if (eCPrivateKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPrivateKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])eCPrivateKeySpec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec((EllipticCurve)ellipticCurve, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCPrivateKeySpec.getParams());
        } else {
            this.ecSpec = null;
        }
    }

    public BCECGOST3410_2012PrivateKey(ECPrivateKeySpec eCPrivateKeySpec) {
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    public BCECGOST3410_2012PrivateKey(BCECGOST3410_2012PrivateKey bCECGOST3410_2012PrivateKey) {
        this.d = bCECGOST3410_2012PrivateKey.d;
        this.ecSpec = bCECGOST3410_2012PrivateKey.ecSpec;
        this.withCompression = bCECGOST3410_2012PrivateKey.withCompression;
        this.attrCarrier = bCECGOST3410_2012PrivateKey.attrCarrier;
        this.publicKey = bCECGOST3410_2012PrivateKey.publicKey;
        this.gostParams = bCECGOST3410_2012PrivateKey.gostParams;
    }

    public BCECGOST3410_2012PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCECGOST3410_2012PublicKey bCECGOST3410_2012PublicKey, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.ecSpec = eCParameterSpec;
        }
        this.gostParams = bCECGOST3410_2012PublicKey.getGostParams();
        this.publicKey = this.getPublicKeyDetails(bCECGOST3410_2012PublicKey);
    }

    public BCECGOST3410_2012PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCECGOST3410_2012PublicKey bCECGOST3410_2012PublicKey, macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCParameterSpec.getCurve(), (byte[])eCParameterSpec.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCParameterSpec.getG()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
        }
        this.gostParams = bCECGOST3410_2012PublicKey.getGostParams();
        this.publicKey = this.getPublicKeyDetails(bCECGOST3410_2012PublicKey);
    }

    public BCECGOST3410_2012PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        this.ecSpec = null;
    }

    BCECGOST3410_2012PrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1Primitive aSN1Primitive = privateKeyInfo.getPrivateKeyAlgorithm().getParameters().toASN1Primitive();
        if (aSN1Primitive instanceof ASN1Sequence && (ASN1Sequence.getInstance((Object)aSN1Primitive).size() == 2 || ASN1Sequence.getInstance((Object)aSN1Primitive).size() == 3)) {
            this.gostParams = GOST3410PublicKeyAlgParameters.getInstance((Object)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec((String)ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)this.gostParams.getPublicKeyParamSet()));
            ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])eCNamedCurveParameterSpec.getSeed());
            this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)this.gostParams.getPublicKeyParamSet()), ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCNamedCurveParameterSpec.getG()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH());
            ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
            if (aSN1Encodable instanceof ASN1Integer) {
                this.d = ASN1Integer.getInstance((Object)aSN1Encodable).getPositiveValue();
            } else {
                byte[] byArray = ASN1OctetString.getInstance((Object)aSN1Encodable).getOctets();
                byte[] byArray2 = new byte[byArray.length];
                for (int i2 = 0; i2 != byArray.length; ++i2) {
                    byArray2[i2] = byArray[byArray.length - 1 - i2];
                }
                this.d = new BigInteger(1, byArray2);
            }
        } else {
            Object object;
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            X962Parameters x962Parameters = X962Parameters.getInstance((Object)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)x962Parameters.getParameters());
                object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
                if (object == null) {
                    ECDomainParameters eCDomainParameters = ECGOST3410NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
                    EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
                    this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier), ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH());
                } else {
                    EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)object.getCurve(), (byte[])object.getSeed());
                    this.ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1ObjectIdentifier), ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)object.getG()), object.getN(), object.getH());
                }
            } else if (x962Parameters.isImplicitlyCA()) {
                this.ecSpec = null;
            } else {
                aSN1ObjectIdentifier = X9ECParameters.getInstance((Object)x962Parameters.getParameters());
                object = EC5Util.convertCurve((ECCurve)aSN1ObjectIdentifier.getCurve(), (byte[])aSN1ObjectIdentifier.getSeed());
                this.ecSpec = new ECParameterSpec((EllipticCurve)object, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)aSN1ObjectIdentifier.getG()), aSN1ObjectIdentifier.getN(), aSN1ObjectIdentifier.getH().intValue());
            }
            aSN1ObjectIdentifier = privateKeyInfo.parsePrivateKey();
            if (aSN1ObjectIdentifier instanceof ASN1Integer) {
                object = ASN1Integer.getInstance((Object)aSN1ObjectIdentifier);
                this.d = object.getValue();
            } else {
                object = ECPrivateKey.getInstance((Object)aSN1ObjectIdentifier);
                this.d = object.getKey();
                this.publicKey = object.getPublicKey();
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ECPrivateKey eCPrivateKey;
        int n2;
        X962Parameters x962Parameters;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        int n3;
        boolean bl2 = this.d.bitLength() > 256;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = bl2 ? RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512 : RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
        int n4 = n3 = bl2 ? 64 : 32;
        if (this.gostParams != null) {
            byte[] byArray = new byte[n3];
            this.extractBytes(byArray, n3, 0, this.getS());
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier2, (ASN1Encodable)this.gostParams), (ASN1Encodable)new DEROctetString(byArray));
                return privateKeyInfo.getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this.ecSpec instanceof ECNamedCurveSpec) {
            aSN1ObjectIdentifier = ECUtil.getNamedCurveOid((String)((ECNamedCurveSpec)this.ecSpec).getName());
            if (aSN1ObjectIdentifier == null) {
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.ecSpec).getName());
            }
            x962Parameters = new X962Parameters(aSN1ObjectIdentifier);
            n2 = ECUtil.getOrderBitLength((ProviderConfiguration)BouncyCastleProvider.CONFIGURATION, (BigInteger)this.ecSpec.getOrder(), (BigInteger)this.getS());
        } else if (this.ecSpec == null) {
            x962Parameters = new X962Parameters((ASN1Null)DERNull.INSTANCE);
            n2 = ECUtil.getOrderBitLength((ProviderConfiguration)BouncyCastleProvider.CONFIGURATION, null, (BigInteger)this.getS());
        } else {
            aSN1ObjectIdentifier = EC5Util.convertCurve((EllipticCurve)this.ecSpec.getCurve());
            eCPrivateKey = new X9ECParameters((ECCurve)aSN1ObjectIdentifier, EC5Util.convertPoint((ECCurve)aSN1ObjectIdentifier, (ECPoint)this.ecSpec.getGenerator(), (boolean)this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)eCPrivateKey);
            n2 = ECUtil.getOrderBitLength((ProviderConfiguration)BouncyCastleProvider.CONFIGURATION, (BigInteger)this.ecSpec.getOrder(), (BigInteger)this.getS());
        }
        eCPrivateKey = this.publicKey != null ? new ECPrivateKey(n2, this.getS(), this.publicKey, (ASN1Encodable)x962Parameters) : new ECPrivateKey(n2, this.getS(), (ASN1Encodable)x962Parameters);
        try {
            aSN1ObjectIdentifier = new PrivateKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier2, (ASN1Encodable)x962Parameters.toASN1Primitive()), (ASN1Encodable)eCPrivateKey.toASN1Primitive());
            return aSN1ObjectIdentifier.getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void extractBytes(byte[] byArray, int n2, int n3, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < n2) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != n2; ++i2) {
            byArray[n3 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
    }

    macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECGOST3410_2012PrivateKey)) {
            return false;
        }
        BCECGOST3410_2012PrivateKey bCECGOST3410_2012PrivateKey = (BCECGOST3410_2012PrivateKey)object;
        return this.getD().equals(bCECGOST3410_2012PrivateKey.getD()) && this.engineGetSpec().equals((Object)bCECGOST3410_2012PrivateKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        return ECUtil.privateKeyToString((String)this.algorithm, (BigInteger)this.d, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)this.engineGetSpec());
    }

    private DERBitString getPublicKeyDetails(BCECGOST3410_2012PublicKey bCECGOST3410_2012PublicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)bCECGOST3410_2012PublicKey.getEncoded());
        return subjectPublicKeyInfo.getPublicKeyData();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray)));
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

