/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ec;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ec.BCECPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.EC5Util;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.config.ProviderConfiguration;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.util.AsymmetricKeyInfoConverter;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECPrivateKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECPublicKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    String algorithm;
    ProviderConfiguration configuration;

    KeyFactorySpi(String string, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.configuration = providerConfiguration;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            return new BCECPublicKey((ECPublicKey)key, this.configuration);
        }
        if (key instanceof ECPrivateKey) {
            return new BCECPrivateKey((ECPrivateKey)key, this.configuration);
        }
        throw new InvalidKeyException("key type unknown");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(java.security.spec.ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            if (eCPublicKey.getParams() != null) {
                return new java.security.spec.ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
            }
            macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new java.security.spec.ECPublicKeySpec(eCPublicKey.getW(), EC5Util.convertSpec((EllipticCurve)EC5Util.convertCurve((ECCurve)eCParameterSpec.getCurve(), (byte[])eCParameterSpec.getSeed()), (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCParameterSpec));
        }
        if (clazz.isAssignableFrom(java.security.spec.ECPrivateKeySpec.class) && key instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            if (eCPrivateKey.getParams() != null) {
                return new java.security.spec.ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new java.security.spec.ECPrivateKeySpec(eCPrivateKey.getS(), EC5Util.convertSpec((EllipticCurve)EC5Util.convertCurve((ECCurve)eCParameterSpec.getCurve(), (byte[])eCParameterSpec.getSeed()), (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCParameterSpec));
        }
        if (clazz.isAssignableFrom(ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            if (eCPublicKey.getParams() != null) {
                return new ECPublicKeySpec(EC5Util.convertPoint((ECParameterSpec)eCPublicKey.getParams(), (ECPoint)eCPublicKey.getW(), (boolean)false), EC5Util.convertSpec((ECParameterSpec)eCPublicKey.getParams(), (boolean)false));
            }
            macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPublicKeySpec(EC5Util.convertPoint((ECParameterSpec)eCPublicKey.getParams(), (ECPoint)eCPublicKey.getW(), (boolean)false), eCParameterSpec);
        }
        if (clazz.isAssignableFrom(ECPrivateKeySpec.class) && key instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            if (eCPrivateKey.getParams() != null) {
                return new ECPrivateKeySpec(eCPrivateKey.getS(), EC5Util.convertSpec((ECParameterSpec)eCPrivateKey.getParams(), (boolean)false));
            }
            macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPrivateKeySpec(eCPrivateKey.getS(), eCParameterSpec);
        }
        return super.engineGetKeySpec(key, clazz);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPrivateKeySpec) {
            return new BCECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec, this.configuration);
        }
        if (keySpec instanceof java.security.spec.ECPrivateKeySpec) {
            return new BCECPrivateKey(this.algorithm, (java.security.spec.ECPrivateKeySpec)keySpec, this.configuration);
        }
        return super.engineGeneratePrivate(keySpec);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ECPublicKeySpec) {
                return new BCECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec, this.configuration);
            }
            if (keySpec instanceof java.security.spec.ECPublicKeySpec) {
                return new BCECPublicKey(this.algorithm, (java.security.spec.ECPublicKeySpec)keySpec, this.configuration);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("invalid KeySpec: " + exception.getMessage(), exception);
        }
        return super.engineGeneratePublic(keySpec);
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (aSN1ObjectIdentifier.equals((Object)X9ObjectIdentifiers.id_ecPublicKey)) {
            return new BCECPrivateKey(this.algorithm, privateKeyInfo, this.configuration);
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognised");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (aSN1ObjectIdentifier.equals((Object)X9ObjectIdentifiers.id_ecPublicKey)) {
            return new BCECPublicKey(this.algorithm, subjectPublicKeyInfo, this.configuration);
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognised");
    }
}

